/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.bean;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.CloudRequest;
import com.clustercontrol.cloud.util.AuthorizingUtil;
import com.clustercontrol.cloud.validation.CustomEntityValidator;
import com.clustercontrol.cloud.validation.EntityValidator;
import com.clustercontrol.cloud.validation.ModifiableAccountResource;
import com.clustercontrol.cloud.validation.ValidationConstants;
import com.clustercontrol.cloud.validation.ValidationFault;
import com.clustercontrol.cloud.validation.annotation.CustomEntityValidation;
import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.IntRange;
import com.clustercontrol.cloud.validation.annotation.NotNull;

@CustomEntityValidation(value=ModifyAccountBillingDetailValidator.class)
public class ModifyAccountBillingDetailRequest
extends CloudRequest {
    private String accountResourceId;
    private boolean billingDetailCollectorFlg;
    private Integer retentionPeriod;

    @ElementId(value="accountResourceId")
    @Identity
    @ModifiableAccountResource
    public String getAccountResourceId() {
        return this.accountResourceId;
    }

    public void setAccountResourceId(String accountResourceId) {
        this.accountResourceId = accountResourceId;
    }

    @ElementId(value="billingDetailCollectorFlg")
    @NotNull
    public Boolean isBillingDetailCollectorFlg() {
        return this.billingDetailCollectorFlg;
    }

    public void setBillingDetailCollectorFlg(Boolean billingDetailCollectorFlg) {
        this.billingDetailCollectorFlg = billingDetailCollectorFlg;
    }

    @ElementId(value="retentionPeriod")
    @NotNull
    @IntRange(min=0L, max=180L)
    public Integer getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public void setRetentionPeriod(Integer retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }

    public static class ModifyAccountBillingDetailValidator
    implements CustomEntityValidator<ModifyAccountBillingDetailRequest>,
    ValidationConstants {
        public void validate(ModifyAccountBillingDetailRequest entity, String group, IMessagesHolder messages, EntityValidator.EntityValidationContext context) throws ValidationFault {
            try {
                if (!AuthorizingUtil.checkHinemousUser_administrators_account(SessionService.current().getHinemosCredential().getUserId(), entity.getAccountResourceId())) {
                    throw ErrorCode.NEED_ADMINISTRATORS_ROLE_OR_ACCOUNT_USER.cloudManagerFaultByIndex(1, SessionService.current().getHinemosCredential().getUserId(), entity.getAccountResourceId());
                }
            }
            catch (CloudManagerFault e) {
                throw new ValidationFault((Throwable)((Object)e));
            }
        }
    }
}

