/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud;

import com.clustercontrol.accesscontrol.session.AccessControllerBean;
import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.CloudPlugin;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.HinemosCredential;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.MessagesHolder;
import com.clustercontrol.cloud.PluginFault;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.CloudAccountResource;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.commons.CloudPropertyConstants;
import com.clustercontrol.cloud.dao.CloudUserDao;
import com.clustercontrol.cloud.factory.AccountResourceOperator;
import com.clustercontrol.cloud.factory.CloudServiceOperator;
import com.clustercontrol.cloud.factory.CloudUserOperator;
import com.clustercontrol.cloud.factory.CriticalPoint;
import com.clustercontrol.cloud.factory.IAccountResourceOperator;
import com.clustercontrol.cloud.factory.ICloudServiceOperator;
import com.clustercontrol.cloud.factory.ICloudUserOperator;
import com.clustercontrol.cloud.factory.IInstanceOperator;
import com.clustercontrol.cloud.factory.IStorageOperator;
import com.clustercontrol.cloud.factory.ITemplateOperator;
import com.clustercontrol.cloud.factory.InstanceOperator;
import com.clustercontrol.cloud.factory.StorageOperator;
import com.clustercontrol.cloud.factory.TemplateOperator;
import com.clustercontrol.cloud.factory.monitors.AutoDetectionManager;
import com.clustercontrol.cloud.factory.monitors.CloudServiceBillingMonitor;
import com.clustercontrol.cloud.registry.AbstractObjectChangedListener;
import com.clustercontrol.cloud.registry.IObjectChangedListener;
import com.clustercontrol.cloud.registry.IObjectChangedService;
import com.clustercontrol.cloud.registry.ObjectChangedService;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.util.AccessControllerBeanWrapper;
import com.clustercontrol.cloud.util.AccountResourceUtil;
import com.clustercontrol.cloud.util.proxy.IProxyStore;
import com.clustercontrol.cloud.util.proxy.ProxyAuthenticator;
import com.clustercontrol.cloud.util.proxy.ProxyStore;
import com.clustercontrol.cloud.validation.ValidationUtil;
import com.clustercontrol.commons.util.HinemosProperties;
import com.clustercontrol.commons.util.ObjectSharingService;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.InvalidSetting;
import com.clustercontrol.fault.InvalidUserPass;
import com.clustercontrol.fault.JobMasterNotFound;
import com.clustercontrol.fault.PrivilegeDuplicate;
import com.clustercontrol.fault.UsedObjectPrivilege;
import com.clustercontrol.monitor.run.factory.RunMonitor;
import com.clustercontrol.ws.cloud.CloudEndpointImpl;
import com.clustercontrol.ws.cloud.IWebServiceBase;
import com.clustercontrol.ws.cloud.Publisher;
import com.clustercontrol.ws.util.HttpAuthenticator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import javax.xml.ws.WebServiceContext;
import org.apache.log4j.Logger;

public class CloudManagerBaseService
extends CloudPlugin {
    public static final String id = "com.clustercontrol.cloud.CloudService";
    public static final String Key_MainEndpoint = "main_endpoint";
    private static CloudManagerBaseService singleton;
    private Publisher publisher = new Publisher();

    public CloudManagerBaseService() {
        singleton = this;
    }

    public synchronized void publish(String postAddress, IWebServiceBase implementor) {
        String address = HinemosProperties.getProperty((String)"common.ws.address", (String)"http://0.0.0.0:8080") + postAddress;
        Logger.getLogger(this.getClass()).info((Object)("publish " + address));
        this.publisher.publish(address, implementor);
    }

    public Set<String> getDependency() {
        return Collections.emptySet();
    }

    public void create() {
        Logger logger = Logger.getLogger(this.getClass());
        logger.info((Object)("creating " + this.getClass().getSimpleName() + "..."));
        for (CloudPropertyConstants value : CloudPropertyConstants.values()) {
            logger.info((Object)(value.id + " = " + value.value() + " (" + value.defaultValue() + ")"));
        }
        logger.info((Object)("successful in creating " + this.getClass().getSimpleName() + "..."));
    }

    public void activate() {
        Logger logger = Logger.getLogger(this.getClass());
        logger.info((Object)("activate " + this.getClass().getSimpleName() + "..."));
        final HashMap<String, CloudPlugin> pluginMap = new HashMap<String, CloudPlugin>();
        ArrayList<CloudPlugin> pluginList = new ArrayList<CloudPlugin>(this.getPluginMap().values());
        for (CloudPlugin plugin : this.getPluginMap().values()) {
            pluginMap.put(plugin.getClass().getName(), plugin);
        }
        Collections.sort(pluginList, new Comparator<CloudPlugin>(){

            @Override
            public int compare(CloudPlugin o1, CloudPlugin o2) {
                if (this.checkNegative(o1, o2)) {
                    return -1;
                }
                if (this.checkPositive(o1, o2)) {
                    return 1;
                }
                return 0;
            }

            private boolean checkNegative(CloudPlugin o1, CloudPlugin dependencyPlugin) {
                for (String dependency : dependencyPlugin.getDependency()) {
                    if (!dependency.equals(o1.getClass().getName())) {
                        CloudPlugin nextDependencyPlugin = (CloudPlugin)pluginMap.get(dependency);
                        if (!this.checkNegative(o1, nextDependencyPlugin)) continue;
                        return true;
                    }
                    return true;
                }
                return false;
            }

            private boolean checkPositive(CloudPlugin o1, CloudPlugin dependencyPlugin) {
                for (String dependency : o1.getDependency()) {
                    if (!dependency.equals(dependencyPlugin.getClass().getName())) {
                        CloudPlugin nextDependencyPlugin = (CloudPlugin)pluginMap.get(dependency);
                        if (!this.checkNegative(nextDependencyPlugin, dependencyPlugin)) continue;
                        return true;
                    }
                    return true;
                }
                return false;
            }
        });
        for (CloudPlugin cloudPlugin : pluginList) {
            cloudPlugin.initialize();
        }
        IWebServiceBase mainEndpoint = (IWebServiceBase)ObjectRegistryService.registry().get(IWebServiceBase.class, (Object)Key_MainEndpoint);
        this.publish("/HinemosWS/CloudEndpoint", mainEndpoint == null ? new CloudEndpointImpl() : mainEndpoint);
        AutoDetectionManager.getService().start();
        logger.info((Object)("successful in activating " + this.getClass().getSimpleName() + "..."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        Logger logger = Logger.getLogger(this.getClass());
        logger.info((Object)("stopping " + this.getClass().getSimpleName() + "..."));
        AutoDetectionManager.getService().stop();
        try {
            CloudManagerBaseService cloudManagerBaseService = this;
            synchronized (cloudManagerBaseService) {
                this.publisher.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        logger.info((Object)("successful in stopping " + this.getClass().getSimpleName() + "..."));
    }

    public void destroy() {
        Logger logger = Logger.getLogger(this.getClass());
        logger.info((Object)("destroying " + this.getClass().getSimpleName() + "..."));
        logger.info((Object)("successful in destroying " + this.getClass().getSimpleName() + "..."));
    }

    public static CloudManagerBaseService getSingleton() {
        return singleton;
    }

    @Override
    public String getPluginId() {
        return id;
    }

    @Override
    public void initialize() {
        Logger logger = Logger.getLogger(this.getClass());
        logger.info((Object)("initializing " + this.getClass().getSimpleName() + "..."));
        ValidationUtil.setMessages((IMessagesHolder)new MessagesHolder("com.clustercontrol.cloud.validation.cloud_validation_messages"));
        this.publisher.setUncaughtExceptionHandler(new Publisher.UncaughtExceptionHandler(){

            public CloudManagerFault uncaughtException(Throwable e) {
                if (e instanceof CloudManagerFault) {
                    return (CloudManagerFault)((Object)e);
                }
                if (e instanceof PluginFault) {
                    return new CloudManagerFault(e);
                }
                return null;
            }
        });
        ObjectRegistryService.registry().put(ICloudServiceOperator.class, CloudServiceOperator.class);
        ObjectRegistryService.registry().put(IAccountResourceOperator.class, AccountResourceOperator.class);
        ObjectRegistryService.registry().put(ICloudUserOperator.class, CloudUserOperator.class);
        ObjectRegistryService.registry().put(IInstanceOperator.class, InstanceOperator.class);
        ObjectRegistryService.registry().put(IStorageOperator.class, StorageOperator.class);
        ObjectRegistryService.registry().put(ITemplateOperator.class, TemplateOperator.class);
        ObjectRegistryService.registry().put(IObjectChangedService.class, (Object)new ObjectChangedService());
        ObjectRegistryService.registry().put(IProxyStore.class, (Object)new ProxyStore());
        if (CloudPropertyConstants.proxy.match("on")) {
            ProxyAuthenticator.setup();
        }
        ObjectSharingService.objectRegistry().put(RunMonitor.class, (Object)"MON_BILLING.1", CloudServiceBillingMonitor.class);
        IObjectChangedService service = (IObjectChangedService)ObjectRegistryService.registry().get(IObjectChangedService.class);
        service.addObjectChangedListener(null, CloudUser.class, (IObjectChangedListener)new AbstractObjectChangedListener<CloudUser>(){

            public void postAdded(String type, CloudUser object) throws PluginFault {
                if (object.getCloudUserType() == CloudUserDao.CloudUserType.user) {
                    try {
                        AccountResourceUtil.addAccountResourceRightToRole((AccessControllerBean)AccessControllerBeanWrapper.bean(), object.getRoleId(), object.getAccountResourceId());
                    }
                    catch (HinemosUnknown | InvalidRole | InvalidSetting | JobMasterNotFound | PrivilegeDuplicate | UsedObjectPrivilege e) {
                        throw ErrorCode.HINEMOS_MANAGER_ERROR.cloudManagerFault((Exception)e);
                    }
                }
            }

            public void preRemoved(String type, CloudUser object) throws PluginFault {
                if (object.getCloudUserType() == CloudUserDao.CloudUserType.user) {
                    try {
                        AccountResourceUtil.removeAccountResourceRightToRole((AccessControllerBean)AccessControllerBeanWrapper.bean(), object.getRoleId(), object.getAccountResourceId());
                    }
                    catch (HinemosUnknown | InvalidRole | InvalidSetting | JobMasterNotFound | PrivilegeDuplicate | UsedObjectPrivilege e) {
                        throw ErrorCode.HINEMOS_MANAGER_ERROR.cloudManagerFault((Exception)e);
                    }
                }
            }
        });
        service.addObjectChangedListener(null, CloudAccountResource.class, (IObjectChangedListener)new AbstractObjectChangedListener<CloudAccountResource>(){

            public void postAdded(String type, CloudAccountResource object) throws PluginFault {
                CriticalPoint.removeCriticalPoint(object.getAccountResourceId());
            }
        });
        SessionService.addInitializer((SessionService.ISessionInitializer)new SessionService.ISessionInitializer(){

            public void initialize(SessionService.ISession context) {
                try {
                    WebServiceContext wsContext = Publisher.getCurrentContext();
                    if (wsContext != null) {
                        String accountName = HttpAuthenticator.getAccount((WebServiceContext)Publisher.getCurrentContext()).split(":")[0];
                        context.setHinemosCredential(new HinemosCredential(accountName));
                    }
                }
                catch (InvalidUserPass e) {
                    throw new InternalManagerError((Throwable)e);
                }
            }

            public void close(SessionService.ISession context) {
            }
        });
        logger.info((Object)("successful in initializing " + this.getClass().getSimpleName() + "..."));
    }
}

