/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.util;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.Messages;
import com.clustercontrol.cloud.cloudn.rest.CloudnCompute;
import com.clustercontrol.cloud.cloudn.rest.CreateTagsRequest;
import com.clustercontrol.cloud.cloudn.rest.ListDiskOfferingsResponse;
import com.clustercontrol.cloud.cloudn.rest.ListServiceOfferingsResponse;
import com.clustercontrol.cloud.cloudn.rest.ListZonesResponse;
import com.clustercontrol.cloud.cloudn.rest.RTag;
import com.clustercontrol.cloud.cloudn.rest.Zone;
import com.clustercontrol.cloud.cloudn.rest.api.CloudnEndpoint;
import com.clustercontrol.cloud.cloudn.rest.api.RestApplicationBuilder;
import com.clustercontrol.cloud.cloudn.rest.api.RestfulApplicationException;
import com.clustercontrol.cloud.util.CloudMessageUtil;
import com.clustercontrol.cloud.util.HinemosUtil;
import com.clustercontrol.cloud.util.Tuple;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class CloudnUtil {
    private static ThreadLocal<Map<Tuple, CloudnEndpoint>> endpointMap = new ThreadLocal<Map<Tuple, CloudnEndpoint>>(){

        @Override
        protected Map<Tuple, CloudnEndpoint> initialValue() {
            return new HashMap<Tuple, CloudnEndpoint>();
        }
    };
    private static Map<String, Map<String, ListServiceOfferingsResponse.ServiceOffering>> serviceOfferingMap = new ConcurrentHashMap<String, Map<String, ListServiceOfferingsResponse.ServiceOffering>>();
    private static Map<String, Map<String, Zone>> zoneMap = new ConcurrentHashMap<String, Map<String, Zone>>();
    private static Map<String, Map<String, ListDiskOfferingsResponse.DiskOffering>> diskOfferingMap = new ConcurrentHashMap<String, Map<String, ListDiskOfferingsResponse.DiskOffering>>();

    private CloudnUtil() {
    }

    public static CloudnCompute createCloudnCompute(IResourceManagement.ICredential credential, String location) throws CloudManagerFault {
        return CloudnUtil.createCloudnEndpoint(CloudnCompute.class, credential, location);
    }

    public static <T extends CloudnEndpoint> T createCloudnEndpoint(Class<T> interfaceClass, IResourceManagement.ICredential credential, String location) throws CloudManagerFault {
        Preconditions.checkNotNull((Object)credential);
        return CloudnUtil.createCloudnEndpoint(interfaceClass, credential.getAccessKey(), credential.getSecretKey(), location);
    }

    public static <T extends CloudnEndpoint> T createCloudnEndpoint(Class<T> interfaceClass, String accessKey, String secretKey, String location) throws CloudManagerFault {
        Preconditions.checkNotNull(interfaceClass);
        Preconditions.checkNotNull((Object)accessKey);
        Preconditions.checkNotNull((Object)secretKey);
        Preconditions.checkNotNull((Object)location);
        T endpoint = RestApplicationBuilder.buildRestApplicationProxy(interfaceClass, accessKey, secretKey);
        endpoint.setEndpoint("https://" + location);
        return endpoint;
    }

    public static <T extends CloudnEndpoint> T getCloudnEndpoint(Class<T> interfaceClass, String accessKey, String secretKey, String location) throws CloudManagerFault {
        try {
            Tuple t = Tuple.build((Object[])new Object[]{interfaceClass, accessKey, secretKey, location});
            Map<Tuple, CloudnEndpoint> emap = endpointMap.get();
            CloudnEndpoint e = emap.get(t);
            if (e == null) {
                e = CloudnUtil.createCloudnEndpoint(interfaceClass, accessKey, secretKey, location);
                emap.put(t, e);
            }
            return (T)e;
        }
        catch (RestfulApplicationException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    public static Map<String, ListServiceOfferingsResponse.ServiceOffering> getInstanceFlavors(String accessKey, String secretKey, String location) throws CloudManagerFault {
        Map<String, ListServiceOfferingsResponse.ServiceOffering> smap = serviceOfferingMap.get(location);
        if (smap == null) {
            try {
                CloudnCompute endpoint = CloudnUtil.getCloudnEndpoint(CloudnCompute.class, accessKey, secretKey, location);
                ListServiceOfferingsResponse res = endpoint.listServiceOfferings();
                smap = new LinkedHashMap<String, ListServiceOfferingsResponse.ServiceOffering>();
                for (ListServiceOfferingsResponse.ServiceOffering so : res.serviceOfferings) {
                    smap.put(so.name, so);
                }
                serviceOfferingMap.put(location, Collections.unmodifiableMap(smap));
            }
            catch (RestfulApplicationException e) {
                throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
            }
        }
        return smap;
    }

    public static Map<String, Zone> getZones(String accessKey, String secretKey, String location) throws CloudManagerFault {
        Map<String, Zone> map = zoneMap.get(location);
        if (map == null) {
            try {
                CloudnCompute endpoint = CloudnUtil.getCloudnEndpoint(CloudnCompute.class, accessKey, secretKey, location);
                ListZonesResponse res = endpoint.listZones();
                map = new LinkedHashMap<String, Zone>();
                for (Zone zone : res.zone) {
                    map.put(zone.name, zone);
                }
                zoneMap.put(location, Collections.unmodifiableMap(map));
            }
            catch (RestfulApplicationException e) {
                throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
            }
        }
        return map;
    }

    public static Map<String, ListDiskOfferingsResponse.DiskOffering> getStorageFlavors(String accessKey, String secretKey, String location) throws CloudManagerFault {
        Map<String, ListDiskOfferingsResponse.DiskOffering> smap = diskOfferingMap.get(location);
        if (smap == null) {
            try {
                CloudnCompute endpoint = CloudnUtil.getCloudnEndpoint(CloudnCompute.class, accessKey, secretKey, location);
                ListDiskOfferingsResponse res = endpoint.listDiskOfferings();
                smap = new LinkedHashMap<String, ListDiskOfferingsResponse.DiskOffering>();
                for (ListDiskOfferingsResponse.DiskOffering so : res.diskOfferings) {
                    smap.put(so.name, so);
                }
                diskOfferingMap.put(location, Collections.unmodifiableMap(smap));
            }
            catch (RestfulApplicationException e) {
                throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
            }
        }
        return smap;
    }

    public static void addTag(CloudnCompute compute, String resourceId, String resourcetype, String key, String value) {
        CloudnUtil.addTags(compute, resourceId, resourcetype, new RTag(key, value));
    }

    public static void addTags(CloudnCompute compute, String resourceId, String resourcetype, List<RTag> tags) {
        if (tags.isEmpty()) {
            return;
        }
        int count = 0;
        int interval = 1000;
        while (true) {
            try {
                CreateTagsRequest createTagsRequest = new CreateTagsRequest();
                createTagsRequest.withTags(tags).withResourceids(resourceId).withResourcetype(resourcetype);
                compute.createTags(createTagsRequest);
            }
            catch (RestfulApplicationException e) {
                Logger logger = Logger.getLogger(CloudnUtil.class);
                logger.debug((Object)e.getMessage(), (Throwable)e);
                if (++count == 5) {
                    throw e;
                }
                try {
                    Thread.sleep(interval);
                    interval += interval;
                }
                catch (InterruptedException e1) {}
                continue;
            }
            break;
        }
    }

    public static void addTags(CloudnCompute compute, String resourceId, String resourcetype, RTag ... tags) {
        CloudnUtil.addTags(compute, resourceId, resourcetype, Arrays.asList(tags));
    }

    public static void notify_Cloudn_Instance_Exception(String accountResourceId, String instanceId, String message, Exception exception) {
        CloudnUtil.notify_Cloudn_Instance_ErrorMessage(accountResourceId, instanceId, message, CloudMessageUtil.getExceptionStackTrace((Exception)exception));
    }

    public static void notify_Cloudn_Instance_ErrorMessage(String accountResourceId, String instanceId, String message, String messageOrg) {
        HinemosUtil.notifyInternalMessage((HinemosUtil.Priority)HinemosUtil.Priority.FAILURE, (String)"CLOUD_CLOUDN", (String)accountResourceId, (String)Messages.messages().getString("message.autoupdate.error.detail1", new Object[]{accountResourceId, instanceId}), (String)"CLOUD_CLOUDN", (String)"CloudnOption", (String)message, (String)messageOrg);
    }
}

