/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.factory;

import com.clustercontrol.cloud.ICloudContext;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.PluginFault;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.CloudStorage;
import com.clustercontrol.cloud.cloudn.factory.CloudnResourceManagement_VPC;
import com.clustercontrol.cloud.dao.CloudStorageBackupDao;
import com.clustercontrol.cloud.dao.CloudStorageDao;
import com.clustercontrol.cloud.factory.IStorageOperator;
import com.clustercontrol.cloud.factory.ResourceStore;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.persistence.TransactionException;
import com.clustercontrol.cloud.registry.AbstractObjectChangedListener;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Query;

public class MigrationProcesser
extends AbstractObjectChangedListener<CloudStorage> {
    public void preRemoved(String eventName, CloudStorage object) throws PluginFault {
        StorageMigration migration;
        StorageMigrationHolder holder = (StorageMigrationHolder)SessionService.current().get(StorageMigrationHolder.class);
        if (holder == null || holder.isEmpty() || (migration = holder.of(object.getStorageId())) == null) {
            return;
        }
        ICloudContext context = (ICloudContext)SessionService.current().get(ICloudContext.class);
        ResourceStore store = new ResourceStore(context.getAccessDestionation().getCloudAccountResource().getAccountResourceId(), context.getAccessDestionation().getCloudAccountResource().getCloudServiceId(), context.getCurrentRegion().getRegion());
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        if (em.find(CloudStorageDao.class, (Object)new CloudStorageDao.CloudStoragePK(migration.getTo().getStorageId(), context.getCurrentRegion().getRegion(), context.getAccessDestionation().getCloudAccountResource().getAccountResourceId())) == null) {
            IStorageOperator operator = (IStorageOperator)ObjectRegistryService.registry().get(IStorageOperator.class);
            operator.setAccessDestination(context.getAccessDestionation());
            operator.setCloudRegion(context.getCurrentRegion());
            try {
                Method m = operator.getClass().getDeclaredMethod("transactionalInternalUpdate", String.class, CloudStorageDao.class, IResourceManagement.Storage.class);
                m.invoke((Object)operator, context.getCurrentRegion().getRegion(), null, migration.getTo());
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new InternalManagerError((Throwable)e);
            }
        }
        Query query = em.createQuery("SELECT b FROM CloudStorageBackupDao b JOIN CloudAccountResourceDao a ON b.accountResourceId = a.accountResourceId JOIN CloudRegionDao r ON a.cloudServiceId = r.cloudServiceId WHERE a.accountResourceId = :accountResourceId AND r.region = :region AND b.backupedData.storageId = :target");
        query.setParameter("accountResourceId", (Object)context.getAccessDestionation().getCloudAccountResource().getAccountResourceId());
        query.setParameter("region", (Object)context.getCurrentRegion().getRegion());
        query.setParameter("target", (Object)migration.getFrom().getStorageId());
        ArrayList backups = new ArrayList(query.getResultList());
        ObjectMapper om = new ObjectMapper();
        ObjectReader or = om.reader(CloudnResourceManagement_VPC.BackupedStorageDetail.class);
        ObjectWriter ow = om.writerWithType(CloudnResourceManagement_VPC.BackupedStorageDetail.class);
        for (CloudStorageBackupDao b : backups) {
            try {
                IResourceManagement.Storage s = migration.getTo();
                String backupDetail = store.get(CloudnResourceManagement_VPC.RT_StorageBackup, b.getStorageBackupId());
                if (backupDetail != null) {
                    CloudnResourceManagement_VPC.BackupedStorageDetail backuped = (CloudnResourceManagement_VPC.BackupedStorageDetail)or.readValue(backupDetail);
                    if (s.getZone().equals(backuped.zone)) {
                        backuped.storageId = s.getStorageId();
                        store.put(CloudnResourceManagement_VPC.RT_StorageBackup, b.getStorageBackupId(), ow.writeValueAsString((Object)backuped));
                    }
                }
                b.getBackupedData().setStorageId(s.getStorageId());
            }
            catch (Exception e) {
                throw new TransactionException((Throwable)e);
            }
        }
    }

    public static class StorageMigrationHolder {
        private Map<String, StorageMigration> map = Collections.synchronizedMap(new HashMap());

        public void add(StorageMigration m) {
            this.map.put(m.getFrom().getStorageId(), m);
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public StorageMigration of(String fromStorageId) {
            return this.map.get(fromStorageId);
        }
    }

    public static class StorageMigration {
        private CloudStorageDao from_;
        private IResourceManagement.Storage to_;

        public StorageMigration() {
        }

        public StorageMigration(CloudStorageDao from, IResourceManagement.Storage to) {
            this.from_ = from;
            this.to_ = to;
        }

        public CloudStorageDao getFrom() {
            return this.from_;
        }

        public IResourceManagement.Storage getTo() {
            return this.to_;
        }

        public StorageMigration from(CloudStorageDao from) {
            this.from_ = from;
            return this;
        }

        public StorageMigration to(IResourceManagement.Storage to) {
            this.to_ = to;
            return this;
        }
    }
}

