/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.Filter;
import com.clustercontrol.cloud.ICloudContext;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.Messages;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.Image;
import com.clustercontrol.cloud.bean.InstanceStateChange;
import com.clustercontrol.cloud.bean.InstanceStateKind;
import com.clustercontrol.cloud.bean.PlatformKind;
import com.clustercontrol.cloud.bean.StorageAttachmentStateKind;
import com.clustercontrol.cloud.bean.StorageStateKind;
import com.clustercontrol.cloud.bean.Tag;
import com.clustercontrol.cloud.bean.Zone;
import com.clustercontrol.cloud.cloudn.CloudnOptionPropertyConstants;
import com.clustercontrol.cloud.cloudn.ErrorCode;
import com.clustercontrol.cloud.cloudn.factory.CloudnAsynchJobTrackingOperator;
import com.clustercontrol.cloud.cloudn.factory.CloudnResourceManagementBase;
import com.clustercontrol.cloud.cloudn.factory.MigrationProcesser;
import com.clustercontrol.cloud.cloudn.rest.AttachVolumeResponse;
import com.clustercontrol.cloud.cloudn.rest.CloudnCompute;
import com.clustercontrol.cloud.cloudn.rest.CloudnResponse;
import com.clustercontrol.cloud.cloudn.rest.CreateSnapshotRequest;
import com.clustercontrol.cloud.cloudn.rest.CreateTagsRequest;
import com.clustercontrol.cloud.cloudn.rest.CreateTemplateRequest;
import com.clustercontrol.cloud.cloudn.rest.CreateTemplateResponse;
import com.clustercontrol.cloud.cloudn.rest.CreateVolumeRequest;
import com.clustercontrol.cloud.cloudn.rest.CreateVolumeResponse;
import com.clustercontrol.cloud.cloudn.rest.DeployVirtualMachineRequest;
import com.clustercontrol.cloud.cloudn.rest.DeployVirtualMachineResponse;
import com.clustercontrol.cloud.cloudn.rest.DestroyVirtualMachineResponse;
import com.clustercontrol.cloud.cloudn.rest.DetachVolumeRequest;
import com.clustercontrol.cloud.cloudn.rest.ListDiskOfferingsResponse;
import com.clustercontrol.cloud.cloudn.rest.ListOSTypesResponse;
import com.clustercontrol.cloud.cloudn.rest.ListOsTypesRequest;
import com.clustercontrol.cloud.cloudn.rest.ListPublicIpAddressesResponse;
import com.clustercontrol.cloud.cloudn.rest.ListServiceOfferingsResponse;
import com.clustercontrol.cloud.cloudn.rest.ListSnapshotsRequest;
import com.clustercontrol.cloud.cloudn.rest.ListSnapshotsResponse;
import com.clustercontrol.cloud.cloudn.rest.ListTemplateRequest;
import com.clustercontrol.cloud.cloudn.rest.ListTemplatesResponse;
import com.clustercontrol.cloud.cloudn.rest.ListVirtualMachinesRequest;
import com.clustercontrol.cloud.cloudn.rest.ListVirtualMachinesResponse;
import com.clustercontrol.cloud.cloudn.rest.ListVolumesRequest;
import com.clustercontrol.cloud.cloudn.rest.ListVolumesResponse;
import com.clustercontrol.cloud.cloudn.rest.Nic;
import com.clustercontrol.cloud.cloudn.rest.QueryAsyncJobResultResponse;
import com.clustercontrol.cloud.cloudn.rest.RTag;
import com.clustercontrol.cloud.cloudn.rest.Snapshot;
import com.clustercontrol.cloud.cloudn.rest.Template;
import com.clustercontrol.cloud.cloudn.rest.VirtualMachine;
import com.clustercontrol.cloud.cloudn.rest.Volume;
import com.clustercontrol.cloud.cloudn.rest.api.RestfulApplicationException;
import com.clustercontrol.cloud.cloudn.util.Cider;
import com.clustercontrol.cloud.cloudn.util.CloudnUtil;
import com.clustercontrol.cloud.dao.CloudInstanceDao;
import com.clustercontrol.cloud.dao.CloudStorageDao;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.persistence.TransactionException;
import com.clustercontrol.cloud.persistence.Transactional;
import com.clustercontrol.cloud.util.Tuple;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@Transactional(value=Transactional.TransactionType.Supported)
@NonNullByDefault(value=false)
public class CloudnResourceManagement_VPC
extends CloudnResourceManagementBase {
    public static String TEMP_HOSTNAME = "TEMP-HOSTNAME";
    public static String RT_Instance = "COMPUTE";
    public static String RT_Image = "COMPUTE_Template";
    public static String RT_Storage = "COMPUTE_Volume";
    public static String RT_Snapshot = "COMPUTE_Snapshot";
    public static String RT_LoadBalancer = "LBA";
    public static String RT_InstanceBackup = "InstanceBackup";
    public static String RT_StorageBackup = "StorageBackup";
    protected Cider cider = null;
    protected static final Pattern imageIdPattern = Pattern.compile("^(.*)\\+([^\\+]*)$");

    protected InstanceStateKind instanceStateKind(String state) {
        if ("Destroyed".equals(state)) {
            return InstanceStateKind.terminated;
        }
        if ("Starting".equals(state)) {
            return InstanceStateKind.pending;
        }
        if ("Error".equals(state)) {
            return InstanceStateKind.terminated;
        }
        if ("Expunging".equals(state)) {
            return InstanceStateKind.shutting_down;
        }
        if ("Expunged".equals(state)) {
            return InstanceStateKind.terminated;
        }
        if ("Migrating".equals(state)) {
            return InstanceStateKind.pending;
        }
        for (InstanceStateKind stateKind : InstanceStateKind.values()) {
            if (!stateKind.label().equalsIgnoreCase(state)) continue;
            return stateKind;
        }
        throw new InternalManagerError(state);
    }

    @NonNull
    protected CloudnCompute getCloudnEndpoint() throws CloudManagerFault {
        return CloudnUtil.getCloudnEndpoint(CloudnCompute.class, this.getCledential().getAccessKey(), this.getCledential().getSecretKey(), this.getRegion().getEndpoint(this.getComputeId()).getLocation());
    }

    @NonNull
    protected Map<String, ListServiceOfferingsResponse.ServiceOffering> getInstanceFlavorsInternal() throws CloudManagerFault {
        return CloudnUtil.getInstanceFlavors(this.getCledential().getAccessKey(), this.getCledential().getSecretKey(), this.getRegion().getEndpoint(this.getComputeId()).getLocation());
    }

    @NonNull
    protected ListServiceOfferingsResponse.ServiceOffering getInstanceFlavorInternal(@NonNull String name) throws CloudManagerFault {
        ListServiceOfferingsResponse.ServiceOffering offering = this.getInstanceFlavorsInternal().get(name);
        if (offering == null) {
            throw ErrorCode.SERVICE_OFFERING_NOT_FONUD.cloudManagerFault(name);
        }
        return offering;
    }

    @NonNull
    protected Map<String, ListDiskOfferingsResponse.DiskOffering> getStorageFlavorsInternal() throws CloudManagerFault {
        return CloudnUtil.getStorageFlavors(this.getCledential().getAccessKey(), this.getCledential().getSecretKey(), this.getRegion().getEndpoint(this.getComputeId()).getLocation());
    }

    @NonNull
    protected ListDiskOfferingsResponse.DiskOffering getStorageFlavorInternal(@NonNull String name) throws CloudManagerFault {
        ListDiskOfferingsResponse.DiskOffering offering = this.getStorageFlavorsInternal().get(name);
        if (offering == null) {
            throw ErrorCode.DISK_OFFERING_NOT_FONUD.cloudManagerFault(name);
        }
        return offering;
    }

    @NonNull
    protected Map<String, com.clustercontrol.cloud.cloudn.rest.Zone> getZonesInternal() throws CloudManagerFault {
        return CloudnUtil.getZones(this.getCledential().getAccessKey(), this.getCledential().getSecretKey(), this.getRegion().getEndpoint(this.getComputeId()).getLocation());
    }

    @NonNull
    protected com.clustercontrol.cloud.cloudn.rest.Zone getZoneInternal(@NonNull String name) throws CloudManagerFault {
        com.clustercontrol.cloud.cloudn.rest.Zone zone = this.getZonesInternal().get(name);
        if (zone == null) {
            throw ErrorCode.ZONE_NOT_FONUD.cloudManagerFault(name);
        }
        return zone;
    }

    @NonNull
    protected StorageStateKind getStorageStatus(@NonNull Volume volume) {
        StorageStateKind state = null;
        switch (volume.state) {
            case "Allocated": 
            case "Ready": {
                if (!(volume.virtualmachineid == null || volume.virtualmachineid.isEmpty() || volume.vmstate != null && volume.vmstate.equals("Destroyed"))) {
                    state = StorageStateKind.in_use;
                    break;
                }
                state = StorageStateKind.available;
                break;
            }
            case "Creating": 
            case "Migrating": {
                state = StorageStateKind.creating;
                break;
            }
            case "Expunged": {
                state = StorageStateKind.deleting;
                break;
            }
            default: {
                Logger logger = Logger.getLogger(this.getClass());
                logger.info((Object)volume.state);
                state = StorageStateKind.error;
            }
        }
        return state;
    }

    @NonNull
    protected StorageAttachmentStateKind getAttachStatus(@NonNull Volume volume) {
        StorageAttachmentStateKind state;
        switch (this.getStorageStatus(volume)) {
            case available: {
                state = StorageAttachmentStateKind.detached;
                break;
            }
            case in_use: {
                state = StorageAttachmentStateKind.attached;
                break;
            }
            default: {
                state = StorageAttachmentStateKind.detached;
            }
        }
        return state;
    }

    protected static PlatformKind getOSType(String ostype) {
        if (Pattern.compile(CloudnOptionPropertyConstants.cloudn_os_win_pattern.value(), 2).matcher(ostype).matches()) {
            return PlatformKind.windows;
        }
        if (Pattern.compile(CloudnOptionPropertyConstants.cloudn_os_linux_pattern.value(), 2).matcher(ostype).matches()) {
            return PlatformKind.linux;
        }
        return PlatformKind.other;
    }

    protected Cider getCider() {
        if (this.cider == null) {
            try {
                this.cider = new Cider(CloudnOptionPropertyConstants.cloudn_private_cidr.value());
            }
            catch (Exception e) {
                throw new InternalManagerError((Throwable)e);
            }
        }
        return this.cider;
    }

    protected void setupIpAddress(IResourceManagement.Instance instance, VirtualMachine vm) throws CloudManagerFault {
        if (CloudnOptionPropertyConstants.cloudn_node_ip.match("public")) {
            CloudnCompute compute = this.getCloudnEndpoint();
            for (ListPublicIpAddressesResponse.PublicIpAddress a : compute.listPublicIpAddresses().publicipaddresses) {
                if (!vm.id.equals(a.virtualmachineid)) continue;
                instance.setIpAddress(a.ipaddress);
                break;
            }
        } else {
            for (Nic nic : vm.nic) {
                if (!this.getCider().matches(nic.ipaddress)) continue;
                instance.setIpAddress(nic.ipaddress);
                break;
            }
        }
        instance.setHostName(TEMP_HOSTNAME);
    }

    protected DeployVirtualMachineRequest getCreateInstanceRequest(String id, String name, String flavor, String imageId, String zone, String instanceDetail, List<Tag> tags) throws CloudManagerFault, JsonProcessingException, IOException {
        ObjectMapper om = new ObjectMapper();
        ObjectReader or = om.reader(InstanceDetail.class);
        InstanceDetail detail = (InstanceDetail)or.readValue(instanceDetail);
        DeployVirtualMachineRequest deployRequest = new DeployVirtualMachineRequest();
        deployRequest.serviceofferingid = this.getInstanceFlavorInternal((String)flavor).id;
        deployRequest.templateid = (String)CloudnResourceManagement_VPC.parseImageId(imageId).get(0, String.class);
        deployRequest.zoneid = this.getZoneInternal((String)zone).id;
        deployRequest.displayname = id;
        deployRequest.group = detail.group;
        String s = "";
        for (String networkId : detail.networkIds) {
            if (!s.isEmpty()) {
                s = s + ',';
            }
            s = s + networkId;
        }
        deployRequest.networkids = s;
        return deployRequest;
    }

    protected InstanceInfo internalCreateInstance(String id, String name, String flavor, String imageId, String zone, String instanceDetail, List<Tag> tags) throws CloudManagerFault {
        CloudnCompute compute = this.getCloudnEndpoint();
        try {
            DeployVirtualMachineRequest deployRequest = this.getCreateInstanceRequest(id, name, flavor, imageId, zone, instanceDetail, tags);
            DeployVirtualMachineResponse resoponse = compute.deployVirtualMachine(deployRequest);
            ListVirtualMachinesResponse vmlist = compute.listVirtualMachines(new ListVirtualMachinesRequest().withId(resoponse.id));
            if (vmlist.virtualMachines.isEmpty()) {
                throw ErrorCode.VM_NOT_FONUD.cloudManagerFault(resoponse.id);
            }
            final VirtualMachine vm = vmlist.virtualMachines.get(0);
            SessionService.current().addRollbackAction(new SessionService.RolebackAction(){

                public void rollback() throws TransactionException {
                    try {
                        CloudnCompute compute = CloudnResourceManagement_VPC.this.getCloudnEndpoint();
                        compute.destroyVirtualMachine(vm.id);
                    }
                    catch (CloudManagerFault e) {
                        throw new TransactionException((Throwable)e);
                    }
                }
            });
            ArrayList<RTag> cloudnTags = new ArrayList<RTag>();
            for (Tag t : tags) {
                cloudnTags.add(new RTag().withKey(t.getKey()).withValue(t.getValue()));
            }
            CloudnUtil.addTags(compute, resoponse.id, "userVM", cloudnTags);
            IResourceManagement.Instance instance = new IResourceManagement.Instance();
            instance.setResourceType(RT_Instance);
            instance.setInstanceId(vm.id);
            instance.setName(name);
            instance.setFlavor(flavor);
            instance.setZone(vm.zonename);
            instance.setImageId(vm.templateid);
            ListOSTypesResponse ostypesList = compute.listOsTypes(new ListOsTypesRequest().withId(vm.guestosid));
            if (ostypesList.ostypes.isEmpty()) {
                throw new InternalManagerError("not found ostype of vm created. vm=" + vm.id);
            }
            instance.setPlatform(CloudnResourceManagement_VPC.getOSType(ostypesList.ostypes.get((int)0).description));
            instance.setState(this.instanceStateKind(vm.state));
            if (vm.nic.isEmpty()) {
                throw new InternalManagerError("expect vm has one nic at least. vm=" + vm.id);
            }
            this.setupIpAddress(instance, vm);
            ListVolumesResponse volumelist = compute.listVolumes(new ListVolumesRequest().withVirtualMachineId(resoponse.id));
            ArrayList<IResourceManagement.Instance.BlockDeviceMapping> blockDeviceMappings = new ArrayList<IResourceManagement.Instance.BlockDeviceMapping>();
            for (Volume v : volumelist.volumes) {
                blockDeviceMappings.add(new IResourceManagement.Instance.BlockDeviceMapping(v.id, "", v.state));
            }
            instance.setBlockDeviceMappings(blockDeviceMappings);
            ArrayList<Tag> cloudTags = new ArrayList<Tag>();
            for (RTag tag : cloudnTags) {
                cloudTags.add(new Tag(tag.key, tag.value));
            }
            if (vm.passwordenabled) {
                CloudnAsynchJobTrackingOperator.registJobId(Tuple.build((Object[])new Object[]{"getPassword", instance.getInstanceId(), this.getAccountResourceId()}), resoponse.jobid);
            }
            instance.setTags(cloudTags);
            instance.setActualResource((Object)vm);
            return new InstanceInfo(instance, vm, resoponse);
        }
        catch (RestfulApplicationException e) {
            throw new CloudManagerFault(e.getMessageWithoutErrorCode(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            throw new InternalManagerError((Throwable)e);
        }
    }

    public IResourceManagement.Instance createInstance(String id, String name, String flavor, String imageId, String zone, String instanceDetail, List<Tag> tags) throws CloudManagerFault {
        return this.internalCreateInstance((String)id, (String)name, (String)flavor, (String)imageId, (String)zone, (String)instanceDetail, tags).instance;
    }

    public void deleteInstance(String instanceId) throws CloudManagerFault {
        try {
            CloudnCompute compute = this.getCloudnEndpoint();
            DestroyVirtualMachineResponse response = compute.destroyVirtualMachine(instanceId);
            CloudnAsynchJobTrackingOperator.registJobId(Tuple.build((Object[])new Object[]{"getDeleteInstanceResult", instanceId, this.getAccountResourceId()}), response.jobid);
        }
        catch (RestfulApplicationException e) {
            throw new CloudManagerFault(e.getMessageWithoutErrorCode(), e.getErrorCode(), (Throwable)e);
        }
    }

    protected IResourceManagement.Instance convertInstance(VirtualMachine vm) throws CloudManagerFault {
        IResourceManagement.Instance instance = new IResourceManagement.Instance();
        instance.setResourceType(RT_Instance);
        instance.setInstanceId(vm.id);
        instance.setName(vm.displayname);
        instance.setFlavor(vm.serviceofferingname);
        instance.setZone(vm.zonename);
        instance.setImageId(vm.templatename);
        ListOSTypesResponse ostypesList = this.getCloudnEndpoint().listOsTypes(new ListOsTypesRequest().withId(vm.guestosid));
        if (ostypesList.ostypes.isEmpty()) {
            throw new InternalManagerError("not found ostype of vm created. vm=" + vm.id);
        }
        instance.setPlatform(CloudnResourceManagement_VPC.getOSType(ostypesList.ostypes.get((int)0).description));
        instance.setState(this.instanceStateKind(vm.state));
        if (vm.nic.isEmpty()) {
            throw new InternalManagerError("expect vm has one nic at least. vm=" + vm.id);
        }
        this.setupIpAddress(instance, vm);
        ListVolumesResponse volumelist = this.getCloudnEndpoint().listVolumes(new ListVolumesRequest().withVirtualMachineId(vm.id));
        ArrayList<IResourceManagement.Instance.BlockDeviceMapping> blockDeviceMappings = new ArrayList<IResourceManagement.Instance.BlockDeviceMapping>();
        for (Volume v : volumelist.volumes) {
            blockDeviceMappings.add(new IResourceManagement.Instance.BlockDeviceMapping(v.id, "", v.state));
        }
        instance.setBlockDeviceMappings(blockDeviceMappings);
        ArrayList<Tag> cloudTags = new ArrayList<Tag>();
        for (com.clustercontrol.cloud.cloudn.rest.Tag tag : vm.tags) {
            cloudTags.add(new Tag(tag.key, tag.value));
        }
        instance.setTags(cloudTags);
        instance.setActualResource((Object)vm);
        return instance;
    }

    public IResourceManagement.Instance getInstance(String instanceId) throws CloudManagerFault {
        try {
            CloudnCompute compute = this.getCloudnEndpoint();
            VirtualMachine vm = compute.listVirtualMachines((ListVirtualMachinesRequest)new ListVirtualMachinesRequest().withId((String)instanceId)).virtualMachines.get(0);
            if (!this.isCorrectedInstance(vm).booleanValue()) {
                throw IResourceManagement.ErrorCode.Resource_InvalidInstanceID_NotFound.cloudManagerFault(new Object[]{instanceId});
            }
            return this.convertInstance(vm);
        }
        catch (RestfulApplicationException e) {
            throw IResourceManagement.ErrorCode.Resource_InvalidInstanceID_NotFound.cloudManagerFault(new Object[]{instanceId});
        }
    }

    public List<IResourceManagement.Instance> getInstances(String ... instanceIds) throws CloudManagerFault {
        return this.getInstances(Arrays.asList(instanceIds));
    }

    public List<IResourceManagement.Instance> getInstances(List<String> instanceIds) throws CloudManagerFault {
        try {
            CloudnCompute compute = this.getCloudnEndpoint();
            ListVirtualMachinesResponse result = compute.listVirtualMachines();
            ArrayList<IResourceManagement.Instance> instances = new ArrayList<IResourceManagement.Instance>();
            if (instanceIds.isEmpty()) {
                for (VirtualMachine vm : result.virtualMachines) {
                    if (!this.isCorrectedInstance(vm).booleanValue()) continue;
                    instances.add(this.convertInstance(vm));
                }
            } else {
                block3: for (VirtualMachine vm : result.virtualMachines) {
                    for (String instanceId : instanceIds) {
                        if (!instanceId.equals(vm.id) || this.instanceStateKind(vm.state).equals((Object)InstanceStateKind.stopping) && !this.isRegisteredInstance(vm.id).booleanValue()) continue;
                        instances.add(this.convertInstance(vm));
                        instanceIds.remove(instanceId);
                        continue block3;
                    }
                }
            }
            return instances;
        }
        catch (RestfulApplicationException e) {
            throw new CloudManagerFault(e.getMessageWithoutErrorCode(), e.getErrorCode(), (Throwable)e);
        }
    }

    public InstanceStateChange startInstance(String instanceId) throws CloudManagerFault {
        try {
            CloudnCompute compute = this.getCloudnEndpoint();
            compute.startVirtualMachine(instanceId);
            InstanceStateChange change = new InstanceStateChange();
            change.setInstanceId(instanceId);
            change.setCurrentState(InstanceStateKind.pending);
            change.setPreviousState(InstanceStateKind.pending);
            return change;
        }
        catch (RestfulApplicationException e) {
            throw new CloudManagerFault(e.getMessageWithoutErrorCode(), e.getErrorCode(), (Throwable)e);
        }
    }

    public InstanceStateChange stopInstance(String instanceId) throws CloudManagerFault {
        try {
            CloudnCompute compute = this.getCloudnEndpoint();
            compute.stopVirtualMachine(instanceId);
            InstanceStateChange change = new InstanceStateChange();
            change.setInstanceId(instanceId);
            change.setCurrentState(InstanceStateKind.stopping);
            change.setPreviousState(InstanceStateKind.stopping);
            return change;
        }
        catch (RestfulApplicationException e) {
            throw new CloudManagerFault(e.getMessageWithoutErrorCode(), e.getErrorCode(), (Throwable)e);
        }
    }

    public List<String> getInstanceFlavors() throws CloudManagerFault {
        ArrayList<String> l = new ArrayList<String>();
        Map<String, ListServiceOfferingsResponse.ServiceOffering> map = this.getInstanceFlavorsInternal();
        for (ListServiceOfferingsResponse.ServiceOffering value : map.values()) {
            l.add(value.name);
        }
        return l;
    }

    public List<Zone> getZones() throws CloudManagerFault {
        ArrayList<Zone> zones = new ArrayList<Zone>();
        Map<String, com.clustercontrol.cloud.cloudn.rest.Zone> map = this.getZonesInternal();
        for (com.clustercontrol.cloud.cloudn.rest.Zone value : map.values()) {
            Zone zone = new Zone();
            zone.setName(value.name);
            zones.add(zone);
        }
        return zones;
    }

    public void attachStorage(String instanceId, String storageId, String deviceName) throws CloudManagerFault {
        try {
            CloudnCompute compute = this.getCloudnEndpoint();
            int retryCount = 0;
            Volume volume = compute.listVolumes((ListVolumesRequest)new ListVolumesRequest().withId((String)storageId)).volumes.get(0);
            if (volume.vmstate != null && volume.vmstate.equals("Destroyed")) {
                compute.detachVolume(new DetachVolumeRequest().withId(storageId));
                retryCount = 3;
            }
            while (true) {
                try {
                    AttachVolumeResponse response = compute.attachVolume(storageId, instanceId);
                    CloudnAsynchJobTrackingOperator.registJobId(Tuple.build((Object[])new Object[]{"getAttachStorageResult", storageId, instanceId, this.getAccountResourceId()}), response.jobid);
                }
                catch (RestfulApplicationException e) {
                    if (retryCount <= 0) {
                        throw e;
                    }
                    --retryCount;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {}
                    continue;
                }
                break;
            }
        }
        catch (RestfulApplicationException e) {
            try {
                throw new CloudManagerFault(e.getMessageWithoutErrorCode(), e.getErrorCode(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SessionService.current().addRollbackAction(new SessionService.RolebackAction(storageId){
                    final /* synthetic */ String val$storageId;
                    {
                        this.val$storageId = string;
                    }

                    public void rollback() throws TransactionException {
                        try {
                            CloudnCompute compute = CloudnResourceManagement_VPC.this.getCloudnEndpoint();
                            DetachVolumeRequest request = new DetachVolumeRequest();
                            request.id = this.val$storageId;
                            compute.detachVolume(request);
                        }
                        catch (CloudManagerFault e) {
                            throw new TransactionException((Throwable)e);
                        }
                    }
                });
                throw throwable;
            }
        }
        SessionService.current().addRollbackAction(new /* invalid duplicate definition of identical inner class */);
    }

    public void detachStorage(String instanceId, String storageId) throws CloudManagerFault {
        try {
            CloudnCompute compute = this.getCloudnEndpoint();
            DetachVolumeRequest request = new DetachVolumeRequest();
            request.id = storageId;
            compute.detachVolume(request);
        }
        catch (RestfulApplicationException e) {
            throw new CloudManagerFault(e.getMessageWithoutErrorCode(), e.getErrorCode(), (Throwable)e);
        }
    }

    public IResourceManagement.Storage createStorage(String name, String flavor, int size, String snapshotId, String zone, String storageDetail) throws CloudManagerFault {
        IResourceManagement.Storage storage;
        block9: {
            CreateVolumeResponse response = null;
            try {
                CloudnCompute compute = this.getCloudnEndpoint();
                CreateVolumeRequest request = new CreateVolumeRequest();
                request.name = name;
                if (flavor != null && !flavor.isEmpty()) {
                    request.diskofferingid = this.getStorageFlavorInternal((String)flavor).id;
                } else if (snapshotId != null && !snapshotId.isEmpty()) {
                    List<Snapshot> snapshots = compute.listSnapshots((ListSnapshotsRequest)new ListSnapshotsRequest().withId((String)snapshotId)).snapshots;
                    if (snapshots.size() > 0 && snapshots.get((int)0).volumetype.equals("ROOT")) {
                        throw ErrorCode.STORAGE_CANNOT_CREATE_FROM_SNAPSHOT_OF_ROOT_VOLUME.cloudManagerFault(snapshotId);
                    }
                    request.snapshotid = snapshotId;
                }
                request.zoneid = this.getZoneInternal((String)zone).id;
                response = compute.createVolume(request);
                storage = this.getStorage(response.id);
                if (response == null) break block9;
            }
            catch (RestfulApplicationException e) {
                try {
                    throw new CloudManagerFault(e.getMessageWithoutErrorCode(), e.getErrorCode(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        String id = response.id;
                        SessionService.current().addRollbackAction(new SessionService.RolebackAction(id){
                            final /* synthetic */ String val$id;
                            {
                                this.val$id = string;
                            }

                            public void rollback() throws TransactionException {
                                try {
                                    CloudnCompute compute = CloudnResourceManagement_VPC.this.getCloudnEndpoint();
                                    compute.deleteVolume(this.val$id);
                                }
                                catch (CloudManagerFault e) {
                                    throw new TransactionException((Throwable)e);
                                }
                            }
                        });
                    }
                    throw throwable;
                }
            }
            String id = response.id;
            SessionService.current().addRollbackAction(new /* invalid duplicate definition of identical inner class */);
        }
        return storage;
    }

    public void deleteStorage(String storageId) throws CloudManagerFault {
        try {
            CloudnCompute compute = this.getCloudnEndpoint();
            int retryCount = 0;
            Volume volume = compute.listVolumes((ListVolumesRequest)new ListVolumesRequest().withId((String)storageId)).volumes.get(0);
            if (volume.vmstate != null && volume.vmstate.equals("Destroyed")) {
                compute.detachVolume(new DetachVolumeRequest().withId(storageId));
                retryCount = 3;
            }
            while (true) {
                try {
                    compute.deleteVolume(storageId);
                }
                catch (RestfulApplicationException e) {
                    if (retryCount <= 0) {
                        throw e;
                    }
                    --retryCount;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {}
                    continue;
                }
                break;
            }
        }
        catch (RestfulApplicationException e) {
            throw new CloudManagerFault(e.getMessageWithoutErrorCode(), e.getErrorCode(), (Throwable)e);
        }
    }

    public IResourceManagement.Storage getStorage(String storageId) throws CloudManagerFault {
        List<IResourceManagement.Storage> storages = this.getStorages(storageId);
        if (storages.size() < 1) {
            throw ErrorCode.STORAGE_NOT_FONUD.cloudManagerFault(storageId);
        }
        return storages.get(0);
    }

    @Nullable
    public Date convertDate(@NonNull String source) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").parse(source);
        }
        catch (ParseException e) {
            Logger logger = Logger.getLogger(this.getClass());
            logger.info((Object)source);
            return null;
        }
    }

    public List<IResourceManagement.Storage> getStorages(String ... storageIds) throws CloudManagerFault {
        return this.getStorages(Arrays.asList(storageIds));
    }

    public List<IResourceManagement.Storage> getStorages(List<String> storageIds) throws CloudManagerFault {
        try {
            CloudnCompute compute = this.getCloudnEndpoint();
            ListVolumesResponse response = compute.listVolumes();
            ArrayList<IResourceManagement.Storage> storages = new ArrayList<IResourceManagement.Storage>();
            if (storageIds.isEmpty()) {
                for (Volume v : response.volumes) {
                    if (!this.isCorrectedStorage(v).booleanValue()) continue;
                    storages.add(this.createStorage(v));
                }
            } else {
                block4: for (Volume v : response.volumes) {
                    for (String id : storageIds) {
                        if (!id.equals(v.id) || !this.isCorrectedStorage(v).booleanValue()) continue;
                        storages.add(this.createStorage(v));
                        continue block4;
                    }
                }
            }
            ICloudContext context = (ICloudContext)SessionService.current().get(ICloudContext.class);
            EntityManagerEx em = SessionService.current().getEntityManagerEx();
            Query query = em.createQuery("SELECT s FROM CloudStorageDao s JOIN CloudAccountResourceDao a ON s.accountResourceId = a.accountResourceId JOIN CloudRegionDao r ON a.cloudServiceId = r.cloudServiceId WHERE a.accountResourceId = :accountResourceId AND r.region = :region");
            query.setParameter("accountResourceId", (Object)context.getAccessDestionation().getCloudAccountResource().getAccountResourceId());
            query.setParameter("region", (Object)context.getCurrentRegion().getRegion());
            ArrayList difdaos = new ArrayList(query.getResultList());
            ArrayList<Volume> difvolumes = new ArrayList<Volume>(response.volumes);
            ArrayList<Tuple> expunged = new ArrayList<Tuple>();
            Iterator daoIter = difdaos.iterator();
            block6: while (daoIter.hasNext()) {
                CloudStorageDao d = (CloudStorageDao)daoIter.next();
                Iterator volumeIter = difvolumes.iterator();
                while (volumeIter.hasNext()) {
                    Volume v = (Volume)volumeIter.next();
                    if (!v.id.equals(d.getStorageId())) continue;
                    daoIter.remove();
                    volumeIter.remove();
                    if (!"Expunged".equals(v.state) && !"Expunging".equals(v.state)) continue block6;
                    expunged.add(Tuple.build((Object[])new Object[]{d, v}));
                    continue block6;
                }
            }
            MigrationProcesser.StorageMigrationHolder migrated = new MigrationProcesser.StorageMigrationHolder();
            block8: for (CloudStorageDao d : difdaos) {
                for (Volume v : response.volumes) {
                    if (d.getStorageId().equals(v.id) || !d.getStorageName().equals(v.name)) continue;
                    migrated.add(new MigrationProcesser.StorageMigration().from(d).to(this.createStorage(v)));
                    continue block8;
                }
            }
            block10: for (Tuple t : expunged) {
                CloudStorageDao d = (CloudStorageDao)t.get(0, CloudStorageDao.class);
                for (Volume v : response.volumes) {
                    if (d.getStorageId().equals(v.id) || !d.getStorageName().equals(v.name)) continue;
                    migrated.add(new MigrationProcesser.StorageMigration().from(d).to(this.createStorage(v)));
                    continue block10;
                }
            }
            if (!migrated.isEmpty()) {
                SessionService.current().set(MigrationProcesser.StorageMigrationHolder.class, (Object)migrated);
            }
            return storages;
        }
        catch (RestfulApplicationException e) {
            throw new CloudManagerFault(e.getMessageWithoutErrorCode(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            throw new InternalManagerError((Throwable)e);
        }
    }

    protected IResourceManagement.Storage createStorage(Volume volume) {
        IResourceManagement.Storage storage = new IResourceManagement.Storage();
        storage.setResourceType(RT_Storage);
        storage.setStorageId(volume.id);
        storage.setName(volume.name);
        storage.setSize(this.stringToVolumeSize(volume.size));
        storage.setZone(volume.zonename);
        storage.setFlavor(volume.diskofferingname);
        storage.setState(this.getStorageStatus(volume));
        if (!((volume.attached == null || volume.attached.isEmpty()) && !volume.type.equals("ROOT") || volume.vmstate != null && volume.vmstate.equals("Destroyed"))) {
            IResourceManagement.Storage.StorageAttachment sa = new IResourceManagement.Storage.StorageAttachment();
            sa.setInstanceId(volume.virtualmachineid);
            sa.setDevice(volume.deviceid.toString());
            sa.setState(this.getAttachStatus(volume));
            if (volume.type.equals("ROOT")) {
                sa.setAttachTime(this.convertDate(volume.created));
            } else {
                sa.setAttachTime(this.convertDate(volume.attached));
            }
            storage.setStorageAttachment(sa);
        }
        storage.setCreateTime(this.convertDate(volume.created));
        storage.setActualResource((Object)volume);
        return storage;
    }

    protected int stringToVolumeSize(String size) {
        long quote = new Long(size);
        return (int)(quote / 1024L / 1024L / 1024L);
    }

    public List<String> getStorageFlavors() throws CloudManagerFault {
        ArrayList<String> flavors = new ArrayList<String>();
        for (ListDiskOfferingsResponse.DiskOffering offering : this.getStorageFlavorsInternal().values()) {
            flavors.add(offering.name);
        }
        return flavors;
    }

    /*
     * Exception decompiling
     */
    public IResourceManagement.StorageBackup createStorageBackup(String storageId, String name, String description, String backupOption) throws CloudManagerFault {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void deleteStorageBackup(String storageBackupId) throws CloudManagerFault {
        try {
            CloudnCompute compute = this.getCloudnEndpoint();
            compute.deleteSnapshot(storageBackupId, null);
        }
        catch (RestfulApplicationException e) {
            throw new CloudManagerFault(e.getMessageWithoutErrorCode(), e.getErrorCode(), (Throwable)e);
        }
        try {
            this.getStore().remove(RT_StorageBackup, storageBackupId);
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(this.getClass());
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public List<com.clustercontrol.cloud.bean.Snapshot> getSnapshots(String ... snapshotIds) throws CloudManagerFault {
        return this.getSnapshotsWithFilter(new Filter("snapshot-id", snapshotIds));
    }

    public List<com.clustercontrol.cloud.bean.Snapshot> getSnapshots(List<String> snapshotIds) throws CloudManagerFault {
        return this.getSnapshotsWithFilter(new Filter("snapshot-id", snapshotIds));
    }

    public List<com.clustercontrol.cloud.bean.Snapshot> getSnapshotsWithFilter(Filter ... filters) throws CloudManagerFault {
        return this.getSnapshotsWithFilter(Arrays.asList(filters));
    }

    public List<com.clustercontrol.cloud.bean.Snapshot> getSnapshotsWithFilter(List<Filter> filters) throws CloudManagerFault {
        CloudnCompute compute = this.getCloudnEndpoint();
        ListSnapshotsRequest request = new ListSnapshotsRequest();
        List snapshotIds = null;
        for (Filter filter : filters) {
            if (filter.getName().equals("zone")) {
                request.zoneid = this.getZoneInternal((String)((String)filter.getValues().get((int)0))).id;
            }
            if (!filter.getName().equals("snapshot-id")) continue;
            snapshotIds = filter.getValues();
        }
        ArrayList<com.clustercontrol.cloud.bean.Snapshot> snapshots = new ArrayList<com.clustercontrol.cloud.bean.Snapshot>();
        try {
            List<Snapshot> orgSnapshots = compute.listSnapshots((ListSnapshotsRequest)request).snapshots;
            if (orgSnapshots != null) {
                if (snapshotIds != null) {
                    List<Snapshot> tmpSnapshots = orgSnapshots;
                    orgSnapshots = new ArrayList<Snapshot>();
                    block3: for (String id : snapshotIds) {
                        for (Snapshot snapshot : tmpSnapshots) {
                            if (!id.equals(snapshot.id)) continue;
                            orgSnapshots.add(snapshot);
                            continue block3;
                        }
                    }
                }
                for (Snapshot restSnapshot : orgSnapshots) {
                    if (restSnapshot.volumetype.equals("ROOT")) continue;
                    com.clustercontrol.cloud.bean.Snapshot snapshot = new com.clustercontrol.cloud.bean.Snapshot();
                    snapshot.setResourceType(RT_Snapshot);
                    snapshot.setSnapshotId(restSnapshot.id);
                    snapshot.setDescription(restSnapshot.name);
                    snapshots.add(snapshot);
                }
            }
        }
        catch (RestfulApplicationException e) {
            throw new CloudManagerFault(e.getMessageWithoutErrorCode(), e.getErrorCode(), (Throwable)e);
        }
        return snapshots;
    }

    public List<Image> getImages(String ... imageIds) throws CloudManagerFault {
        return this.getImagesWithFilter(new Filter("image-id", imageIds));
    }

    public List<Image> getImages(List<String> imageIds) throws CloudManagerFault {
        return this.getImagesWithFilter(new Filter("image-id", imageIds));
    }

    public List<Image> getImagesWithFilter(Filter ... filters) throws CloudManagerFault {
        return this.getImagesWithFilter(Arrays.asList(filters));
    }

    public List<Image> getImagesWithFilter(List<Filter> filters) throws CloudManagerFault {
        List<ImageBucket> ibs = this.internalGetImagesWithFilter(filters);
        ArrayList<Image> images = new ArrayList<Image>();
        for (ImageBucket ib : ibs) {
            images.add(ib.cloudImgae);
        }
        return images;
    }

    @Nullable
    protected static Tuple parseImageId(String imageId) throws CloudManagerFault {
        Matcher m = imageIdPattern.matcher(imageId);
        if (!m.matches()) {
            throw ErrorCode.IMAGE_INVALID_ID.cloudManagerFault(imageId);
        }
        String templateId = m.group(1);
        String zoneName = m.group(2);
        return Tuple.build((Object[])new Object[]{templateId, zoneName});
    }

    @Nullable
    protected static String createImageId(String imageId, String zoneId) throws CloudManagerFault {
        return imageId + "+" + zoneId;
    }

    protected List<ImageBucket> internalGetImagesWithFilter(Filter ... filters) throws CloudManagerFault {
        return this.internalGetImagesWithFilter(Arrays.asList(filters));
    }

    protected List<ImageBucket> internalGetImagesWithFilter(List<Filter> filters) throws CloudManagerFault {
        CloudnCompute compute = this.getCloudnEndpoint();
        ListTemplateRequest request = new ListTemplateRequest().withTemplatefilter("executable");
        ArrayList<Tuple> ts = new ArrayList<Tuple>();
        for (Filter f : filters) {
            block7 : switch (f.getName()) {
                case "category": {
                    if (f.getValues().isEmpty()) break;
                    switch ((String)f.getValues().get(0)) {
                        case "official": 
                        case "featured": {
                            request.withTemplatefilter("featured");
                            break block7;
                        }
                        case "my": 
                        case "self": {
                            request.withTemplatefilter("self");
                            break block7;
                        }
                        case "all": 
                        case "executable": {
                            request.withTemplatefilter("executable");
                            break block7;
                        }
                    }
                    break;
                }
                case "zone": {
                    request.withZoneId(this.getZonesInternal().get(f.getValues().get((int)0)).id);
                    break;
                }
                case "image-id": {
                    if (f.getValues().size() == 1) {
                        try {
                            Tuple t = CloudnResourceManagement_VPC.parseImageId((String)f.getValues().get(0));
                            request.withId((String)t.get(0, String.class));
                            break;
                        }
                        catch (Exception e) {
                            throw ErrorCode.FILTER_INVALID.cloudManagerFault(f.getName(), f.getValues().get(0));
                        }
                    }
                    for (Object value : f.getValues()) {
                        try {
                            Tuple t = CloudnResourceManagement_VPC.parseImageId(value.toString());
                            ts.add(t);
                        }
                        catch (Exception e) {
                            Logger.getLogger(this.getClass()).warn((Object)ErrorCode.FILTER_INVALID.cloudManagerFault(f.getName(), f.getValues().get(0)).getMessage());
                        }
                    }
                    if (f.getValues().isEmpty() || !ts.isEmpty()) break;
                    throw ErrorCode.FILTER_INVALID.cloudManagerFault(f.getName(), f.getValues().get(0));
                }
            }
        }
        ListTemplatesResponse response = compute.listTemplates(request);
        ArrayList<ImageBucket> bs = new ArrayList<ImageBucket>();
        for (Template template : response.template) {
            if (ts.size() > 1) {
                boolean match = false;
                for (Tuple t : ts) {
                    if (!template.id.equals(t.get(0)) || !template.zonename.equals(t.get(1))) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
            }
            Image image = new Image();
            image.setResourceType(RT_Image);
            image.setName(template.name);
            image.setImageId(template.id + "+" + template.zonename);
            image.setDescription(template.displaytext);
            image.setActualResource((Object)template);
            bs.add(new ImageBucket(image, template));
        }
        return bs;
    }

    public com.clustercontrol.cloud.bean.Snapshot getSnapshot(String snapshotId) throws CloudManagerFault {
        List<com.clustercontrol.cloud.bean.Snapshot> snapshots = this.getSnapshots(snapshotId);
        if (snapshots.isEmpty()) {
            throw IResourceManagement.ErrorCode.Resource_InvalidSnapshot_NotFound.cloudManagerFault(new Object[]{snapshotId});
        }
        return snapshots.get(0);
    }

    public Image getImage(String imageId) throws CloudManagerFault {
        List<Image> images = this.getImages(imageId);
        if (images.isEmpty()) {
            throw IResourceManagement.ErrorCode.Resource_InvalidImageID_NotFound.cloudManagerFault(new Object[]{imageId});
        }
        return images.get(0);
    }

    protected RestoreInfo internalRestoreInstance(String facilityId, String instanceBackupId, String name, String flavor, String zone, String instanceDetail, List<Tag> tags) throws CloudManagerFault, JsonProcessingException, IOException {
        String value = this.getStore().get(RT_InstanceBackup, instanceBackupId);
        ObjectMapper om = new ObjectMapper();
        BackupedInstanceDetail backuped = (BackupedInstanceDetail)om.reader(BackupedInstanceDetail.class).readValue(value);
        backuped.name = name != null ? name : backuped.name;
        String string = backuped.flavor = flavor != null ? flavor : backuped.flavor;
        if (instanceDetail != null) {
            InstanceDetail override = (InstanceDetail)om.reader(InstanceDetail.class).readValue(instanceDetail);
            if (backuped.instanceDetail == null) {
                backuped.instanceDetail = override;
            } else {
                backuped.instanceDetail.group = override.group != null ? override.group : backuped.instanceDetail.group;
                backuped.instanceDetail.networkIds = override.networkIds != null ? override.networkIds : backuped.instanceDetail.networkIds;
                backuped.instanceDetail.attachingDisk = override.attachingDisk != null ? override.attachingDisk : backuped.instanceDetail.attachingDisk;
            }
        }
        ArrayList<Tag> tagsTemp = new ArrayList<Tag>(tags);
        block0: for (Tag t : backuped.tags) {
            if (tagsTemp.isEmpty()) break;
            Iterator iter = tagsTemp.iterator();
            while (iter.hasNext()) {
                Tag override = (Tag)iter.next();
                if (!t.getKey().equals(override.getKey())) continue;
                t.setValue(override.getValue());
                iter.remove();
                continue block0;
            }
        }
        for (Tag t : tagsTemp) {
            backuped.tags.add(t);
        }
        String backupedDetail = om.writerWithType(InstanceDetail.class).writeValueAsString((Object)backuped.instanceDetail);
        return new RestoreInfo(this.internalCreateInstance(facilityId, backuped.name, backuped.flavor, instanceBackupId, backuped.zone, backupedDetail, backuped.tags), backuped.attachedStorages, backuped.instanceDetail.attachingDisk);
    }

    public IResourceManagement.Instance restoreInstance(String facilityId, String instanceBackupId, String name, String flavor, String zone, String instanceDetail, List<Tag> tags) throws CloudManagerFault {
        try {
            RestoreInfo restoreInfo = this.internalRestoreInstance(facilityId, instanceBackupId, name, flavor, zone, instanceDetail, tags);
            final InstanceInfo instanceInfo = restoreInfo.instanceInfo;
            SessionService.current().addRollbackAction(new SessionService.RolebackAction(){

                public void rollback() throws TransactionException {
                    try {
                        try {
                            CloudnCompute compute = CloudnResourceManagement_VPC.this.getCloudnEndpoint();
                            compute.destroyVirtualMachine(instanceInfo.instance.getInstanceId());
                        }
                        catch (CloudManagerFault e) {
                            throw new TransactionException((Throwable)e);
                        }
                    }
                    catch (RestfulApplicationException e) {
                        throw new TransactionException((Throwable)e);
                    }
                }
            });
            final ArrayList<String> createdStorages = new ArrayList<String>();
            CloudnCompute compute = this.getCloudnEndpoint();
            for (AttachedStorage backupedStorage : restoreInfo.getAttachStorages()) {
                final CreateVolumeResponse response = compute.createVolume(new CreateVolumeRequest().withName(backupedStorage.name).withSnapshotid(backupedStorage.snapshotId));
                SessionService.current().addRollbackAction(new SessionService.RolebackAction(){

                    public void rollback() throws TransactionException {
                        try {
                            try {
                                CloudnCompute compute = CloudnResourceManagement_VPC.this.getCloudnEndpoint();
                                compute.deleteVolume(response.id);
                            }
                            catch (CloudManagerFault e) {
                                throw new TransactionException((Throwable)e);
                            }
                        }
                        catch (RestfulApplicationException e) {
                            throw new TransactionException((Throwable)e);
                        }
                    }
                });
                CloudnUtil.addTags(compute, response.id, "Volume", new RTag("ownerInstanceId", instanceInfo.instance.getInstanceId()), new RTag("originalStorageId", backupedStorage.storageId), new RTag("sourceBackupId", backupedStorage.snapshotId));
                createdStorages.add(response.id);
            }
            if (restoreInfo.isAttachingDisk() != null && restoreInfo.isAttachingDisk().booleanValue() && !createdStorages.isEmpty()) {
                SessionService.scheduleWithFixedDelay((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        QueryAsyncJobResultResponse response;
                        CloudnCompute compute;
                        ICloudContext context = (ICloudContext)SessionService.current().get(ICloudContext.class);
                        try {
                            compute = CloudnResourceManagement_VPC.this.getCloudnEndpoint();
                            response = compute.queryAsyncJobResult(instanceInfo.responce.jobid);
                        }
                        catch (CloudManagerFault | RestfulApplicationException e) {
                            CloudnUtil.notify_Cloudn_Instance_Exception(context.getAccessDestionation().getCloudAccountResource().getAccountResourceId(), instanceInfo.instance.getInstanceId(), Messages.messages().getString("message.validation.cloudn.instance.fail_to_get_status_of_instance_on_tracking", instanceInfo.instance.getInstanceId()), (Exception)e);
                            throw new InternalManagerError(e);
                        }
                        switch (response.jobstatus) {
                            case "0": {
                                break;
                            }
                            case "1": {
                                for (String storageId : createdStorages) {
                                    try {
                                        compute.attachVolume(storageId, instanceInfo.instance.getInstanceId());
                                    }
                                    catch (Exception e) {
                                        CloudnUtil.notify_Cloudn_Instance_Exception(context.getAccessDestionation().getCloudAccountResource().getAccountResourceId(), instanceInfo.instance.getInstanceId(), Messages.messages().getString("message.validation.cloudn.instance.fail_to_attach_storage_on_restoring", new Object[]{instanceInfo.instance.getInstanceId(), storageId}), e);
                                    }
                                }
                                throw new RuntimeException();
                            }
                            case "2": {
                                String errorMessage = "errorcode=" + response.jobresult.errorcode + ",errortext=" + response.jobresult.errortext;
                                CloudnUtil.notify_Cloudn_Instance_ErrorMessage(context.getAccessDestionation().getCloudAccountResource().getAccountResourceId(), instanceInfo.instance.getInstanceId(), Messages.messages().getString("message.validation.cloudn.instance.fail_to_get_status_of_instance_on_tracking", instanceInfo.instance.getInstanceId()), errorMessage);
                                throw new InternalManagerError(errorMessage);
                            }
                            default: {
                                throw new InternalManagerError("got unexpected status number. status=" + response.jobstatus);
                            }
                        }
                    }
                }, (long)0L, (long)10000L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            return instanceInfo.instance;
        }
        catch (Exception e) {
            throw new InternalManagerError((Throwable)e);
        }
    }

    public IResourceManagement.Storage restoreStorage(String storageBackupId, String name, String flavor, Integer size, String zone, String storageDetail) throws CloudManagerFault {
        try {
            String value = this.getStore().get(RT_StorageBackup, storageBackupId);
            ObjectMapper om = new ObjectMapper();
            ObjectReader or = om.reader(BackupedStorageDetail.class);
            BackupedStorageDetail backuped = (BackupedStorageDetail)or.readValue(value);
            backuped.name = name != null ? name : backuped.name;
            backuped.flavor = flavor != null ? flavor : backuped.flavor;
            backuped.zone = zone != null ? zone : backuped.zone;
            backuped.size = size != null ? size : backuped.size;
            return this.createStorage(backuped.name, backuped.flavor, backuped.size, storageBackupId, backuped.zone, null);
        }
        catch (Exception e) {
            throw new InternalManagerError((Throwable)e);
        }
    }

    protected IResourceManagement.StorageBackup createStorageBackup(Snapshot snapshot) {
        try {
            ObjectMapper om = new ObjectMapper();
            ObjectReader or = om.reader(BackupedStorageDetail.class);
            ObjectWriter ow = om.writerWithType(StorageDetail.class);
            String backupDetail = this.getStore().get(RT_StorageBackup, snapshot.id);
            BackupedStorageDetail backuped = (BackupedStorageDetail)or.readValue(backupDetail);
            IResourceManagement.StorageBackup storageBackup = new IResourceManagement.StorageBackup();
            storageBackup.setResourceType(RT_StorageBackup);
            storageBackup.setStorageBackupId(snapshot.id);
            storageBackup.setName(backuped.name);
            storageBackup.setStorageId(backuped.storageId);
            storageBackup.setDescription(backuped.description);
            storageBackup.setCreateTime(backuped.createTime);
            storageBackup.setBackupedData(new IResourceManagement.StorageBackup.BackupedData());
            storageBackup.getBackupedData().setName(backuped.name);
            storageBackup.getBackupedData().setFlavor(backuped.flavor);
            storageBackup.getBackupedData().setZone(backuped.zone);
            storageBackup.getBackupedData().setStorageDetail(ow.writeValueAsString((Object)backuped.storageDetail));
            storageBackup.setActualResource((Object)snapshot);
            return storageBackup;
        }
        catch (Exception e) {
            throw new InternalManagerError((Throwable)e);
        }
    }

    public IResourceManagement.StorageBackup getStorageBackup(String storageBackupId) throws CloudManagerFault {
        try {
            CloudnCompute compute = this.getCloudnEndpoint();
            ListSnapshotsResponse response = compute.listSnapshots(new ListSnapshotsRequest().withId(storageBackupId));
            Snapshot snapshot = response.snapshots.get(0);
            if (response.snapshots.get((int)0).state.equals("Error")) {
                return null;
            }
            return this.createStorageBackup(snapshot);
        }
        catch (RestfulApplicationException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            throw new InternalManagerError((Throwable)e);
        }
    }

    public List<IResourceManagement.StorageBackup> getStorageBackups(String ... storageBackupId) throws CloudManagerFault {
        return this.getStorageBackups(Arrays.asList(storageBackupId));
    }

    public List<IResourceManagement.StorageBackup> getStorageBackups(List<String> storageBackupIds) throws CloudManagerFault {
        ArrayList<IResourceManagement.StorageBackup> storageBackups = new ArrayList<IResourceManagement.StorageBackup>();
        try {
            CloudnCompute compute = this.getCloudnEndpoint();
            ListSnapshotsResponse response = compute.listSnapshots();
            ArrayList filterdList = new ArrayList(this.getStore().getIds(RT_StorageBackup));
            if (!storageBackupIds.isEmpty()) {
                ArrayList<String> tempfilterdList = new ArrayList<String>();
                block5: for (String storageBackupId1 : storageBackupIds) {
                    for (String storageBackupId2 : filterdList) {
                        if (!storageBackupId1.equals(storageBackupId2)) continue;
                        tempfilterdList.add(storageBackupId1);
                        continue block5;
                    }
                }
                filterdList = tempfilterdList.isEmpty() ? filterdList : tempfilterdList;
            }
            Iterator iter = filterdList.iterator();
            block7: while (iter.hasNext()) {
                String storageBackupId = (String)iter.next();
                for (Snapshot snapshot : response.snapshots) {
                    if (!storageBackupId.equals(snapshot.id) || snapshot.state.equals("Error")) continue;
                    storageBackups.add(this.createStorageBackup(snapshot));
                    iter.remove();
                    continue block7;
                }
            }
            for (String storageBackupId : filterdList) {
                try {
                    this.getStore().remove(RT_StorageBackup, storageBackupId);
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass()).warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (RestfulApplicationException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            throw new InternalManagerError((Throwable)e);
        }
        return storageBackups;
    }

    public List<IResourceManagement.LoadBalancer> getLoadBalancers() throws CloudManagerFault {
        return Collections.emptyList();
    }

    public void registerInstanceToLoadBalancer(String lbId, String instanceId) throws CloudManagerFault {
    }

    public void unregisterInstanceToLoadBalancer(String lbId, String instanceId) throws CloudManagerFault {
    }

    public IResourceManagement.InstanceBackup createInstanceBackup(String instanceId, String name, String description, Boolean noReboot, String backupOption) throws CloudManagerFault {
        return this.createInstanceBackup(instanceId, name, description, noReboot, null, backupOption);
    }

    public IResourceManagement.InstanceBackup createInstanceBackup(String instanceId, String name, String description, Boolean noReboot, List<String> storageIds, String backupOption) throws CloudManagerFault {
        try {
            CloudnCompute compute = this.getCloudnEndpoint();
            if (noReboot != null && noReboot.booleanValue()) {
                throw ErrorCode.INSTANCE_BACKUP_NEED_VM_TO_BE_STOPPED.cloudManagerFault(instanceId);
            }
            ListVirtualMachinesResponse response = compute.listVirtualMachines(new ListVirtualMachinesRequest().withId(instanceId));
            if (response.virtualMachines.isEmpty()) {
                throw ErrorCode.VM_NOT_FONUD.cloudManagerFault(instanceId);
            }
            VirtualMachine vm = response.virtualMachines.get(0);
            if (!"stopped".equalsIgnoreCase(vm.state)) {
                throw ErrorCode.INSTANCE_BACKUP_NEED_VM_TO_BE_STOPPED.cloudManagerFault(instanceId);
            }
            String backupId = null;
            ArrayList<AttachedStorage> snapshotIds = new ArrayList<AttachedStorage>();
            ListVolumesResponse volumelist = compute.listVolumes(new ListVolumesRequest().withVirtualMachineId(vm.id));
            for (Volume v : volumelist.volumes) {
                CloudnResponse response2;
                if (v.type.equals("ROOT")) {
                    response2 = compute.createTemplate(new CreateTemplateRequest().withName(name).withDisplaytext(description).withOstypeid(vm.guestosid).withVolumeid(v.id));
                    final String templateId = ((CreateTemplateResponse)response2).id;
                    SessionService.current().addRollbackAction(new SessionService.RolebackAction(){

                        public void rollback() throws TransactionException {
                            try {
                                try {
                                    CloudnCompute compute = CloudnResourceManagement_VPC.this.getCloudnEndpoint();
                                    String zonId = null;
                                    compute.deleteTemplate(templateId, zonId);
                                }
                                catch (CloudManagerFault e) {
                                    throw new TransactionException((Throwable)e);
                                }
                            }
                            catch (RestfulApplicationException e) {
                                throw new TransactionException((Throwable)e);
                            }
                        }
                    });
                    backupId = ((CreateTemplateResponse)response2).id;
                    continue;
                }
                if (storageIds != null && !storageIds.contains(v.id)) continue;
                response2 = compute.createSnapshot(new CreateSnapshotRequest().withVolumeid(v.id));
                final String snapshotId = response2.id;
                SessionService.current().addRollbackAction(new SessionService.RolebackAction(){

                    public void rollback() throws TransactionException {
                        try {
                            try {
                                CloudnCompute compute = CloudnResourceManagement_VPC.this.getCloudnEndpoint();
                                String zonId = null;
                                compute.deleteSnapshot(snapshotId, zonId);
                            }
                            catch (CloudManagerFault e) {
                                throw new TransactionException((Throwable)e);
                            }
                        }
                        catch (RestfulApplicationException e) {
                            throw new TransactionException((Throwable)e);
                        }
                    }
                });
                snapshotIds.add(new AttachedStorage(v.name, v.id, response2.id));
            }
            if (backupId == null) {
                throw new InternalManagerError("not create instancebackup. instance=" + instanceId);
            }
            compute.createTags(new CreateTagsRequest().withResourceids(backupId).withResourcetype("Template").withTag(new RTag().withKey("SourceInstanceId").withValue(instanceId)));
            ListTemplatesResponse response3 = compute.listTemplates(new ListTemplateRequest().withId(backupId).withTemplatefilter("self"));
            Template template = null;
            if (response3.template.isEmpty()) {
                template = new Template();
                template.id = backupId;
                template.zonename = vm.zonename;
                template.created = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(new Date());
            } else {
                template = response3.template.get(0);
            }
            this.registStoredInstanceBackupData(vm, template, snapshotIds);
            IResourceManagement.InstanceBackup instanceBackup = this.createInternalInstanceBackup(CloudnResourceManagement_VPC.createImageId(template.id, template.zonename));
            instanceBackup.setName(name);
            instanceBackup.setDescription(description);
            ListOSTypesResponse ostypesList = compute.listOsTypes(new ListOsTypesRequest().withId(vm.guestosid));
            if (ostypesList.ostypes.isEmpty()) {
                throw new InternalManagerError("not found ostype of vm created. vm=" + vm.id);
            }
            instanceBackup.setPlatform(CloudnResourceManagement_VPC.getOSType(ostypesList.ostypes.get((int)0).description));
            instanceBackup.setActualResource((Object)template);
            return instanceBackup;
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (RestfulApplicationException e) {
            throw new CloudManagerFault(e.getMessageWithoutErrorCode(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            throw new InternalManagerError((Throwable)e);
        }
    }

    protected void registStoredInstanceBackupData(VirtualMachine vm, Template template, List<AttachedStorage> snapshotIds) throws JsonProcessingException, CloudManagerFault {
        String backupId = CloudnResourceManagement_VPC.createImageId(template.id, template.zonename);
        BackupedInstanceDetail backupedData = new BackupedInstanceDetail();
        backupedData.instanceId = vm.id;
        backupedData.name = vm.displayname;
        backupedData.flavor = vm.serviceofferingid;
        backupedData.zone = vm.zonename;
        backupedData.createTime = this.convertDate(template.created);
        backupedData.attachedStorages = new ArrayList<AttachedStorage>(snapshotIds);
        backupedData.tags = new ArrayList<Tag>();
        for (com.clustercontrol.cloud.cloudn.rest.Tag t : vm.tags) {
            backupedData.tags.add(new Tag(t.key, t.value));
        }
        backupedData.instanceDetail = new InstanceDetail();
        backupedData.instanceDetail.networkIds = new ArrayList<String>();
        for (Nic nic : vm.nic) {
            backupedData.instanceDetail.networkIds.add(nic.networkid);
        }
        backupedData.instanceDetail.group = vm.group;
        ObjectMapper om = new ObjectMapper();
        ObjectWriter ow = om.writerWithType(BackupedInstanceDetail.class);
        String backupedDetail = ow.writeValueAsString((Object)backupedData);
        this.getStore().put(RT_InstanceBackup, backupId, backupedDetail);
    }

    protected void deleteRelationalSnapshot(String instanceBackupId) throws CloudManagerFault {
        BackupedInstanceDetail detail;
        CloudnCompute compute = this.getCloudnEndpoint();
        String resource = this.getStore().get(RT_InstanceBackup, instanceBackupId);
        ObjectMapper om = new ObjectMapper();
        ObjectReader or = om.reader(BackupedInstanceDetail.class);
        try {
            detail = (BackupedInstanceDetail)or.readValue(resource);
        }
        catch (IOException e1) {
            throw new InternalManagerError((Throwable)e1);
        }
        for (AttachedStorage snapshotId : detail.attachedStorages) {
            try {
                compute.deleteSnapshot(snapshotId.snapshotId, null);
            }
            catch (RestfulApplicationException e) {
                Logger logger = Logger.getLogger(this.getClass());
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected IResourceManagement.InstanceBackup createInternalInstanceBackup(String id) throws CloudManagerFault, JsonProcessingException, IOException {
        ObjectMapper om = new ObjectMapper();
        ObjectReader or = om.reader(BackupedInstanceDetail.class);
        ObjectWriter ow = om.writerWithType(InstanceDetail.class);
        String backupDetail = this.getStore().get(RT_InstanceBackup, id);
        BackupedInstanceDetail backuped = (BackupedInstanceDetail)or.readValue(backupDetail);
        IResourceManagement.InstanceBackup instanceBackup = new IResourceManagement.InstanceBackup();
        instanceBackup.setResourceType(RT_InstanceBackup);
        instanceBackup.setInstanceBackupId(id);
        instanceBackup.setInstanceId(backuped.instanceId);
        instanceBackup.setCreateTime(backuped.createTime);
        instanceBackup.setBackupedData(new IResourceManagement.InstanceBackup.BackupedData());
        instanceBackup.getBackupedData().setName(backuped.name);
        instanceBackup.getBackupedData().setFlavor(backuped.flavor);
        instanceBackup.getBackupedData().setZone(backuped.zone);
        instanceBackup.getBackupedData().setTags(backuped.tags);
        instanceBackup.getBackupedData().setInstanceDetail(ow.writeValueAsString((Object)backuped.instanceDetail));
        return instanceBackup;
    }

    public IResourceManagement.InstanceBackup getInstanceBackup(String instanceBackupId) throws CloudManagerFault {
        List<IResourceManagement.InstanceBackup> l = this.getInstanceBackups(instanceBackupId);
        return l.isEmpty() ? null : l.get(0);
    }

    public List<IResourceManagement.InstanceBackup> getInstanceBackups(String ... instanceBackupIds) throws CloudManagerFault {
        return this.getInstanceBackups(Arrays.asList(instanceBackupIds));
    }

    public List<IResourceManagement.InstanceBackup> getInstanceBackups(List<String> instanceBackupIds) throws CloudManagerFault {
        try {
            List<Filter> filters = Collections.emptyList();
            filters = instanceBackupIds.isEmpty() ? Arrays.asList(new Filter("category", new String[]{"self"})) : Arrays.asList(new Filter("category", new String[]{"self"}), new Filter("image-id", instanceBackupIds));
            List<ImageBucket> response = this.internalGetImagesWithFilter(filters);
            ArrayList filterdList = new ArrayList(this.getStore().getIds(RT_InstanceBackup));
            if (!instanceBackupIds.isEmpty()) {
                ArrayList<String> tempfilterdList = new ArrayList<String>();
                block6: for (String instanceBackupId1 : instanceBackupIds) {
                    for (String instanceBackupId2 : filterdList) {
                        if (!instanceBackupId1.equals(instanceBackupId2)) continue;
                        tempfilterdList.add(instanceBackupId1);
                        continue block6;
                    }
                }
                filterdList = tempfilterdList.isEmpty() ? filterdList : tempfilterdList;
            }
            ArrayList<IResourceManagement.InstanceBackup> instanceBackups = new ArrayList<IResourceManagement.InstanceBackup>();
            Iterator iter = filterdList.iterator();
            block8: while (iter.hasNext()) {
                String instanceBackupId = (String)iter.next();
                for (ImageBucket ib : response) {
                    if (!instanceBackupId.equals(ib.cloudImgae.getImageId())) continue;
                    IResourceManagement.InstanceBackup instanceBackup = this.createInternalInstanceBackup(instanceBackupId);
                    instanceBackup.setName(ib.cloudImgae.getName());
                    instanceBackup.setDescription(ib.cloudImgae.getDescription());
                    instanceBackup.setPlatform(CloudnResourceManagement_VPC.getOSType(ib.cloudnImgae.ostypename));
                    instanceBackup.setActualResource((Object)ib);
                    instanceBackups.add(instanceBackup);
                    iter.remove();
                    continue block8;
                }
            }
            for (String instanceBackupId : filterdList) {
                try {
                    if (this.isInstanceBackupCreating(instanceBackupId)) {
                        IResourceManagement.InstanceBackup instanceBackup = this.createInternalInstanceBackup(instanceBackupId);
                        instanceBackup.setName("");
                        instanceBackup.setDescription("");
                        instanceBackup.setPlatform(null);
                        instanceBackup.setActualResource(null);
                        instanceBackups.add(instanceBackup);
                        continue;
                    }
                    this.getStore().remove(RT_InstanceBackup, instanceBackupId);
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass()).warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            return instanceBackups;
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (RestfulApplicationException e) {
            throw new CloudManagerFault(e.getMessageWithoutErrorCode(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            throw new InternalManagerError((Throwable)e);
        }
    }

    protected boolean isInstanceBackupCreating(String instanceBackupId) throws CloudManagerFault, JsonProcessingException, IOException {
        ObjectMapper om = new ObjectMapper();
        ObjectReader or = om.reader(BackupedInstanceDetail.class);
        BackupedInstanceDetail detail = (BackupedInstanceDetail)or.readValue(this.getStore().get(RT_InstanceBackup, instanceBackupId));
        return new Date().getTime() - detail.createTime.getTime() < Long.parseLong(CloudnOptionPropertyConstants.cloudn_flat_until_template_created.value());
    }

    public void deleteInstanceBackup(String instanceBackupId) throws CloudManagerFault {
        Logger logger;
        CloudnCompute compute = this.getCloudnEndpoint();
        ImageBucket t = null;
        try {
            List<ImageBucket> response = this.internalGetImagesWithFilter(new Filter("image-id", new String[]{instanceBackupId}), new Filter("category", new String[]{"self"}));
            if (!response.isEmpty()) {
                t = response.get(0);
                compute.deleteTemplate(t.cloudnImgae.id, null);
            }
        }
        catch (RestfulApplicationException e) {
            logger = Logger.getLogger(this.getClass());
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (t != null) {
            this.deleteRelationalSnapshot(instanceBackupId);
        }
        try {
            this.getStore().remove(RT_InstanceBackup, instanceBackupId);
        }
        catch (Exception e) {
            logger = Logger.getLogger(this.getClass());
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected String getComputeId() {
        return "compute";
    }

    @Override
    protected String getServiceId() {
        return "cloudn_vpc";
    }

    @Override
    protected String getDefaultRegion() {
        return "jp-e1";
    }

    protected Boolean isCorrectedInstance(VirtualMachine virtualMachine) {
        return !this.instanceStateKind(virtualMachine.state).equals((Object)InstanceStateKind.stopping) || this.isRegisteredInstance(virtualMachine.id) != false;
    }

    protected Boolean isCorrectedInstance(String instanceId) throws RestfulApplicationException, CloudManagerFault {
        List<VirtualMachine> virtualMachines = this.getCloudnEndpoint().listVirtualMachines((ListVirtualMachinesRequest)new ListVirtualMachinesRequest().withId((String)instanceId)).virtualMachines;
        if (virtualMachines.size() < 1) {
            return false;
        }
        return this.isCorrectedInstance(virtualMachines.get(0));
    }

    protected Boolean isCorrectedStorage(Volume volume) throws RestfulApplicationException, CloudManagerFault {
        return (volume.virtualmachineid == null || !volume.type.equals("ROOT") || (volume.vmstate == null || !volume.vmstate.equals("Destroyed")) && this.isCorrectedInstance(volume.virtualmachineid) != false) && !volume.state.equalsIgnoreCase("expunged") && !volume.state.equalsIgnoreCase("expunging");
    }

    protected Boolean isRegisteredInstance(String instanceId) {
        ICloudContext context;
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudInstanceDao instance = (CloudInstanceDao)em.find(CloudInstanceDao.class, (Object)new CloudInstanceDao.CloudInstancePK(instanceId, (context = (ICloudContext)SessionService.current().get(ICloudContext.class)).getCurrentRegion().getRegion(), context.getAccessDestionation().getCloudAccountResource().getAccountResourceId()));
        return instance != null;
    }

    protected String getAccountResourceId() {
        return ((ICloudContext)SessionService.current().get(ICloudContext.class)).getAccessDestionation().getCloudAccountResource().getAccountResourceId();
    }

    protected static class RestoreInfo {
        private InstanceInfo instanceInfo;
        private List<AttachedStorage> attachStorages;
        private Boolean attachingDisk;

        public RestoreInfo(InstanceInfo instanceInfo, List<AttachedStorage> attachStorages, Boolean attachingDisk) {
            this.instanceInfo = instanceInfo;
            this.attachStorages = attachStorages;
            this.attachingDisk = attachingDisk;
        }

        public InstanceInfo getInstanceInfo() {
            return this.instanceInfo;
        }

        public List<AttachedStorage> getAttachStorages() {
            return this.attachStorages;
        }

        public Boolean isAttachingDisk() {
            return this.attachingDisk;
        }
    }

    protected static class ImageBucket {
        public Image cloudImgae;
        public Template cloudnImgae;

        public ImageBucket(Image cloudImgae, Template cloudnImgae) {
            this.cloudImgae = cloudImgae;
            this.cloudnImgae = cloudnImgae;
        }

        public ImageBucket withCloudImgae(Image cloudImgae) {
            this.cloudImgae = cloudImgae;
            return this;
        }

        public ImageBucket withCloudnImgae(Template cloudnImgae) {
            this.cloudnImgae = cloudnImgae;
            return this;
        }
    }

    protected static class InstanceInfo {
        public final IResourceManagement.Instance instance;
        public final DeployVirtualMachineResponse responce;

        public InstanceInfo(IResourceManagement.Instance instance, VirtualMachine vm, DeployVirtualMachineResponse responce) {
            this.instance = instance;
            this.responce = responce;
        }
    }

    public static class InstanceDetail {
        public List<String> networkIds = new ArrayList<String>();
        public String group = "";
        public Boolean attachingDisk;
    }

    public static class StorageDetail {
        public String volumeName;
    }

    public static class BackupedStorageDetail {
        public String storageId;
        public String name;
        public String flavor;
        public String zone;
        public Integer size;
        public Date createTime;
        public String description;
        public StorageDetail storageDetail;
    }

    public static class BackupedInstanceDetail {
        public String instanceId;
        public String name;
        public String flavor;
        public String zone;
        public List<AttachedStorage> attachedStorages;
        public List<Tag> tags;
        public Date createTime;
        public InstanceDetail instanceDetail;
    }

    public static class AttachedStorage {
        public String name;
        public String storageId;
        public String snapshotId;

        public AttachedStorage() {
        }

        public AttachedStorage(String name, String storageId, String snapshotId) {
            this.name = name;
            this.storageId = storageId;
            this.snapshotId = snapshotId;
        }
    }
}

