/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.cloudn.util.AuthorizingUtilEx;
import com.clustercontrol.cloud.cloudn.util.CloudnConstants;
import com.clustercontrol.cloud.dao.CloudUserDao;
import com.clustercontrol.cloud.factory.ICloudServiceOperator;
import com.clustercontrol.cloud.factory.ICloudUserOperator;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.util.CloudCredential;
import com.clustercontrol.cloud.util.ResourceRegion;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value=false)
public abstract class CloudnResourceManagementBase
implements IResourceManagement,
CloudnConstants {
    private IResourceManagement.IRegion region;
    private IResourceManagement.ICredential credential;
    private IResourceManagement.IStore store;

    public void setAccessDestination(IResourceManagement.ICredential credential, IResourceManagement.IRegion region) {
        this.region = region;
        this.credential = credential;
    }

    protected abstract String getComputeId();

    protected abstract String getServiceId();

    protected abstract String getDefaultRegion();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public IResourceManagement.ICredential getCledential() {
        if (this.credential != null) return (IResourceManagement.ICredential)Preconditions.checkNotNull((Object)this.credential);
        if (SessionService.current().getHinemosCredential().getUserId() == null) throw new InternalManagerError();
        List<Object> users = Collections.emptyList();
        try {
            users = AuthorizingUtilEx.getCloudUsersByCloudService(SessionService.current().getHinemosCredential().getUserId(), this.getServiceId());
        }
        catch (CloudManagerFault e) {
            throw new InternalManagerError(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (users.isEmpty()) throw new InternalManagerError();
        try {
            this.credential = new CloudCredential(((ICloudUserOperator)ObjectRegistryService.registry().get(ICloudUserOperator.class)).findCloudUser(((CloudUserDao)users.get(0)).getId()));
            return (IResourceManagement.ICredential)Preconditions.checkNotNull((Object)this.credential);
        }
        catch (CloudManagerFault e) {
            throw new InternalManagerError(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    @NonNull
    public IResourceManagement.IRegion getRegion() {
        if (this.region == null) {
            try {
                this.region = new ResourceRegion(((ICloudServiceOperator)ObjectRegistryService.registry().get(ICloudServiceOperator.class)).findCloudRegion(this.getServiceId(), this.getDefaultRegion()));
            }
            catch (CloudManagerFault e) {
                throw new InternalManagerError(e.getMessage(), e.getErrorCode(), (Throwable)e);
            }
        }
        return (IResourceManagement.IRegion)Preconditions.checkNotNull((Object)this.region);
    }

    public void setStore(IResourceManagement.IStore store) {
        this.store = store;
    }

    @NonNull
    public IResourceManagement.IStore getStore() {
        return (IResourceManagement.IStore)Preconditions.checkNotNull((Object)this.store);
    }

    public void disconnect() {
    }
}

