/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.persistence;

import com.clustercontrol.cloud.persistence.ProcessedBy;
import com.clustercontrol.cloud.persistence.Processor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.apache.log4j.Logger;

public class DaoExtension {
    private static Map<Class<?>, EntityContext> contextMap = Collections.synchronizedMap(new HashMap());
    private static Map<Class<?>, List<Processor<?>>> processorsMap = new HashMap();

    private static EntityContext getEntityContext(Class<?> type) {
        EntityContext context = contextMap.get(type);
        if (context == null) {
            Logger logger = Logger.getLogger(DaoExtension.class);
            logger.debug((Object)("checking : " + type.getName()));
            context = new EntityContext();
            contextMap.put(type, context);
            HashMap<String, Property> bufMap = new HashMap<String, Property>();
            for (Class<?> clazz = type; clazz != Object.class; clazz = clazz.getSuperclass()) {
                for (Method m : clazz.getMethods()) {
                    logger.debug((Object)("methodName : " + m.getName()));
                    boolean isGet = false;
                    for (Annotation anno : m.getAnnotations()) {
                        Property buf;
                        logger.debug((Object)("annotation : " + anno.annotationType().getName()));
                        ProcessedBy pb = anno.annotationType().getAnnotation(ProcessedBy.class);
                        if (pb == null) continue;
                        String propName = null;
                        Class<?> returnType = null;
                        if (!isGet) {
                            if (Modifier.isStatic(m.getModifiers())) {
                                throw new IllegalStateException();
                            }
                            if (m.isSynthetic()) {
                                throw new IllegalStateException();
                            }
                            if (m.getParameterTypes().length != 0) {
                                throw new IllegalStateException();
                            }
                            if (!m.getName().startsWith("get")) {
                                throw new IllegalStateException();
                            }
                            returnType = m.getReturnType();
                            if (Void.class.isAssignableFrom(returnType) || Void.TYPE.isAssignableFrom(returnType)) {
                                throw new IllegalStateException();
                            }
                            propName = m.getName().substring("get".length());
                            propName = Character.toLowerCase(propName.charAt(0)) + propName.substring(1);
                            logger.debug((Object)("found GetMethod : " + m.getName()));
                            isGet = true;
                        }
                        if ((buf = (Property)bufMap.get(propName)) == null) {
                            buf = new Property();
                            buf.propType = returnType;
                            bufMap.put(propName, buf);
                        } else if (!buf.propType.equals(returnType)) {
                            throw new IllegalStateException();
                        }
                        buf.getMetthod = m;
                        buf.annotations.add(anno);
                    }
                    if (isGet || !m.getName().startsWith("set")) continue;
                    logger.debug((Object)("found SetMethod : " + m.getName()));
                    if (Modifier.isStatic(m.getModifiers()) || m.getParameterTypes().length != 1) continue;
                    String propName = m.getName().substring("set".length());
                    propName = Character.toLowerCase(propName.charAt(0)) + propName.substring(1);
                    Class<?> paramType = m.getParameterTypes()[0];
                    Property buf = (Property)bufMap.get(propName);
                    if (buf == null) {
                        buf = new Property();
                        buf.propType = paramType;
                        bufMap.put(propName, buf);
                    } else if (!buf.propType.equals(paramType)) continue;
                    buf.setMetthod = m;
                }
            }
            for (Map.Entry e : bufMap.entrySet()) {
                if (((Property)e.getValue()).getMetthod == null) continue;
                if (((Property)e.getValue()).setMetthod == null) {
                    throw new IllegalStateException();
                }
                context.processors.put((String)e.getKey(), (Property)e.getValue());
            }
        }
        return context;
    }

    private static synchronized List<Processor<?>> getProcessores(Class<?> type) {
        List<Processor<?>> processors = processorsMap.get(type);
        if (processors == null) {
            Method initMethod = null;
            try {
                initMethod = Processor.class.getMethod("init", Annotation.class, Method.class, Method.class);
            }
            catch (NoSuchMethodException | SecurityException e2) {
                throw new IllegalStateException(e2);
            }
            processors = new ArrayList();
            EntityContext context = DaoExtension.getEntityContext(type);
            for (Map.Entry<String, Property> e : context.processors.entrySet()) {
                for (Annotation a : e.getValue().annotations) {
                    ProcessedBy pb = a.annotationType().getAnnotation(ProcessedBy.class);
                    try {
                        Processor<?> p = pb.value().newInstance();
                        initMethod.invoke(p, a, e.getValue().getMetthod, e.getValue().setMetthod);
                        processors.add(p);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e1) {
                        throw new IllegalStateException(e1);
                    }
                }
            }
            processorsMap.put(type, processors);
        }
        return processors;
    }

    @PrePersist
    public void prePersist(Object entity) {
        List<Processor<?>> processors = DaoExtension.getProcessores(entity.getClass());
        for (Processor<?> p : processors) {
            try {
                p.prePersist(entity);
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @PostPersist
    public void postPersist(Object entity) {
        List<Processor<?>> processors = DaoExtension.getProcessores(entity.getClass());
        for (Processor<?> p : processors) {
            try {
                p.postPersist(entity);
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @PreUpdate
    public void preUpdate(Object entity) {
        List<Processor<?>> processors = DaoExtension.getProcessores(entity.getClass());
        for (Processor<?> p : processors) {
            try {
                p.preUpdate(entity);
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @PostUpdate
    public void postUpdate(Object entity) {
        List<Processor<?>> processors = DaoExtension.getProcessores(entity.getClass());
        for (Processor<?> p : processors) {
            try {
                p.postUpdate(entity);
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @PostLoad
    public void postLoad(Object entity) throws Exception {
        List<Processor<?>> processors = DaoExtension.getProcessores(entity.getClass());
        for (Processor<?> p : processors) {
            try {
                p.postLoad(entity);
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static class Property {
        public Class<?> propType;
        public Method getMetthod;
        public Method setMetthod;
        public List<Annotation> annotations = new ArrayList<Annotation>();

        private Property() {
        }
    }

    private static class EntityContext {
        public Map<String, Property> processors = new HashMap<String, Property>();

        private EntityContext() {
        }
    }
}

