/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

import com.clustercontrol.cloud.commons.util.AccountControlUtil;
import com.clustercontrol.cloud.commons.util.AccountControlUtil.NotFoundAccountResourceException;
import com.clustercontrol.cloud.presenter.IFacility;

public class ChangeActiveCloudUserAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.ChangeActiveCloudUserAction";

	@Override
	protected void invoke(IAction action) throws InvocationException {
		try {
			AccountControlUtil.selectActiveUser(viewPart);
		}
		catch (NotFoundAccountResourceException e) {
			throw new InvocationException(e);
		}
	}

	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		super.selectionChanged(action, selection);
		if(action.isEnabled()){
			IFacility facility = (IFacility)((IStructuredSelection)selection).getFirstElement();
			if(
				facility != null &&
				facility.getAccountResourceId() != null &&
				!facility.getAccountResourceId().isEmpty()
			){
				try {
					if(!AccountControlUtil.isInitializedActiveUser(facility.getAccountResourceId())){
						AccountControlUtil.selectActiveUser(viewPart);
					}
					if(AccountControlUtil.getAvailableCloudUsers(facility.getAccountResourceId()).size() > 1){
						action.setEnabled(true);
					} else {
						action.setEnabled(false);
					}
				} catch (NotFoundAccountResourceException e) {
					action.setEnabled(false);
				}
			} else {
				action.setEnabled(false);
			}
		}
	}
}
