/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.base.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.cloudn.base.resources.Snapshot;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.ValidateException;
import com.clustercontrol.cloud.commons.util.annotation.RelationalRequiredSelect;
import com.clustercontrol.cloud.commons.util.annotation.RequiredInput;
import com.clustercontrol.cloud.commons.util.annotation.RequiredSelect;
import com.clustercontrol.util.Messages;
import org.eclipse.swt.widgets.Button;

public class CreateStorageDialog extends Dialog {	
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String strSeparator = messages.getString("caption.title_separator");
	private String strStorageName = messages.getString("word.storage_name");
//	private String strStorage = messages.getString("word.storage");
//	private String strSnapshot = messages.getString("word.snapshot");
	private String strCreateEmptyStorage = messages.getString("caption.create_empty_storage");
	private String strCreateStorageWithSnapshot = messages.getString("caption.create_storage_with_snapshot");
	private String strCreateStorageDialog = messages.getString("caption.create_storage_dialog");
	private String strZone = messages.getString("word.zone");
	
	@RequiredInput("strStorageName")
	private Text txtVolumeName;
	@RequiredSelect("strZone")
	private Combo cmbZone;
	@RelationalRequiredSelect(name = "strCreateStorageWithSnapshot", value = "btnSnapshot")
	private Combo cmbSnapshot;
	@RelationalRequiredSelect(name = "strCreateEmptyStorage", value = "btnStorage")
	private Combo cmbStorage;
	private Button btnStorage;
	private Button btnSnapshot;

	@SuppressWarnings("unused")
	private CloudResourceProvider provider;

	private IDialogBehavior behavior;
	
	private DialogData output;
	
	public static class DialogData{
		private String name;
		private String zone;
		private String storage;
		private String snapshot;
		public String getName() {
			return name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public String getZone() {
			return zone;
		}
		public void setZone(String zone) {
			this.zone = zone;
		}
		public String getStorage() {
			return storage;
		}
		public void setStorage(String storage) {
			this.storage = storage;
		}
		public String getSnapshot() {
			return snapshot;
		}
		public void setSnapshot(String snapshot) {
			this.snapshot = snapshot;
		}
	}
	
	public interface IDialogBehavior{
		void setup(DialogControlContainer container);
	}
	
	public static class DialogBehavior implements IDialogBehavior{
		@Override
		public void setup(DialogControlContainer container) {}
	}
	
	public static class DialogControlContainer{
		private Text txtVolumeName;
		private Combo cmbZone;
		private Combo cmbSnapshot;
		private Combo cmbStorage;
		private Button btnStorage;
		private Button btnSnapshot;
		public DialogControlContainer(Text txtVolumeName, Combo cmbZone, Combo cmbSnapshot, Combo cmbStorage, Button btnStorage, Button btnSnapshot){
			this.txtVolumeName = txtVolumeName;
			this.cmbZone = cmbZone;
			this.cmbStorage = cmbStorage;
			this.cmbSnapshot = cmbSnapshot;
			this.btnStorage = btnStorage;
			this.btnSnapshot = btnSnapshot;
		}
		public Text getTxtVolumeName() {
			return txtVolumeName;
		}
		public Combo getCmbZone() {
			return cmbZone;
		}
		public Combo getCmbSnapshot() {
			return cmbSnapshot;
		}
		public Combo getCmbStorage() {
			return cmbStorage;
		}
		public Button getBtnStorage() {
			return btnStorage;
		}
		public Button getBtnSnapshot() {
			return btnSnapshot;
		}
	}
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public CreateStorageDialog(Shell parentShell) {
		super(parentShell);
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(4, false);
		gl_container.horizontalSpacing = 15;
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);
		
		Label lblVolumeName = new Label(container, SWT.NONE);
		lblVolumeName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblVolumeName.setText(strStorageName + strSeparator);
		
		txtVolumeName = new Text(container, SWT.BORDER);
		txtVolumeName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));
		
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		Label lblAvailabilityzone = new Label(container, SWT.NONE);
		lblAvailabilityzone.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblAvailabilityzone.setText(strZone + strSeparator);
		
		cmbZone = new Combo(container, SWT.READ_ONLY);
		cmbZone.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));
		
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		btnStorage = new Button(container, SWT.RADIO);
		btnStorage.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 4, 1));
		btnStorage.setText(strCreateEmptyStorage);
		new Label(container, SWT.NONE);
		
		cmbStorage = new Combo(container, SWT.READ_ONLY);
		cmbStorage.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));
		
		btnSnapshot = new Button(container, SWT.RADIO);
		btnSnapshot.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 4, 1));
		btnSnapshot.setText(strCreateStorageWithSnapshot);
		new Label(container, SWT.NONE);
		
		cmbSnapshot = new Combo(container, SWT.READ_ONLY);
		GridData gd_snapshot = new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1);
		gd_snapshot.widthHint = 570;
		cmbSnapshot.setLayoutData(gd_snapshot);

		{
			behavior.setup(new DialogControlContainer(txtVolumeName, cmbZone, cmbSnapshot, cmbStorage, btnStorage, btnSnapshot));
		}
		
		ControlUtil.setRequired(new Control[]{txtVolumeName});

		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 300);
	}

	@Override
	protected void okPressed() {
		try{
			ControlUtil.validate(this);
		} catch(ValidateException e){
			MessageDialog.openError(null, Messages.getString("failed"), e.getMessage());
			return;
		} catch(Exception e){
			throw new RuntimeException(e);
		}

		output = new DialogData();
		output.setName(txtVolumeName.getText());
		output.setZone(cmbZone.getText());
//		output.setSnapshot((String)cmbSnapshot.getData(cmbSnapshot.getText()));
//		output.setStorage((String)cmbStorage.getData(cmbStorage.getText()));
		if(btnSnapshot.getSelection()){
			output.setSnapshot(((Snapshot)cmbSnapshot.getData(cmbSnapshot.getText())).getId());
		} else if(btnStorage.getSelection()){
			output.setStorage(cmbStorage.getText());
		}

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strCreateStorageDialog);
	}

	public CreateStorageDialog.DialogData getOutput() {
		return output;
	}

	public void setCloudInfoProvider(CloudResourceProvider provider) {
		this.provider = provider;
	}

	public void setBehavior(IDialogBehavior behavior) {
		this.behavior = behavior;
	}
}
