/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.base.resources;

import java.util.ArrayList;
import java.util.List;

import com.clustercontrol.cloud.cloudn.base.Activator;
import com.clustercontrol.cloud.commons.util.AccountControlUtil;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudRegion;
import com.clustercontrol.ws.cloudn.CloudnOptionEndpoint;
//import com.clustercontrol.ws.cloudn.Tag;
import com.clustercontrol.cloud.resources.Tag;

public class CloudResourceProviderImpl implements CloudResourceProvider {
	private CloudEndpoint cloudEndpoint;
	private CloudnOptionEndpoint cloudnOptionEndpoint;
	private String serviceId;
	private String roleId;

	public CloudResourceProviderImpl(String accountResourceId) {
		this.cloudEndpoint = Activator.getEndpointManager().getEndpoint(CloudEndpoint.class);
		this.cloudnOptionEndpoint = Activator.getEndpointManager().getEndpoint(CloudnOptionEndpoint.class);

		this.serviceId = com.clustercontrol.cloud.Activator.getDefault().getCloudResourceManager().getAccountResourceManager().getAccountResource(accountResourceId).getCloudServiceId();

//		try {
//			for(CloudService cloudService: cloudEndpoint.getAllCloudServices()){
//				if(cloudService.getCloudServiceId().equals("cloudn_vpc")){
//					this.serviceId = cloudService.getCloudServiceId();
//				}
//			}
//		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
//			throw new CloudModelException(e);
//		}
		
		this.roleId = AccountControlUtil.getRoleId(accountResourceId);
	}
	
	@Override
	public List<String> getAllRegion() {
		try {
			List<String> regions = new ArrayList<String>();
			for (CloudRegion r: cloudEndpoint.getCloudRegionsByService(serviceId)) {
				regions.add(r.getRegion());
			}
			return regions;
		}
		catch (Exception e) {
			throw new IllegalStateException(e);
		}
	}

	@Override
	public List<Zone> getZones(String region) {
		try {
			List<Zone> azs = new ArrayList<Zone>();
			for (com.clustercontrol.ws.cloud.Zone wsAZ: cloudEndpoint.getZones(roleId, region)) {
				Zone az = new Zone();
				az.setName(wsAZ.getName());
				azs.add(az);
			}
			return azs;
		}
		catch (Exception e) {
			throw new IllegalStateException(e);
		}
	}

	@Override
	public List<Template> getTemplates(String region, List<Filter> filters) {
		try {
			List<com.clustercontrol.ws.cloud.Filter> wsFilters = new ArrayList<com.clustercontrol.ws.cloud.Filter>();
			for (Filter filter: filters) {
				com.clustercontrol.ws.cloud.Filter wsFilter = new com.clustercontrol.ws.cloud.Filter();
				wsFilter.setName(filter.getName());
				wsFilter.getValues().addAll(filter.getValues());
				wsFilters.add(wsFilter);
			}

			List<Template> templates = new ArrayList<Template>();
			for (com.clustercontrol.ws.cloud.Image wsImage: cloudEndpoint.getImagesWithFilter(roleId, region, wsFilters)) {
				Template template = new Template(wsImage.getImageId(), wsImage.getName(), wsImage.getDescription());
				templates.add(template);
			}
			return templates;
		}
		catch (Exception e) {
			throw new IllegalStateException(e);
		}
	}

	@Override
	public List<Network> getNetworksByRegion(String regionName) {
		try {
			List<com.clustercontrol.ws.cloudn.Network> ns= cloudnOptionEndpoint.getNetworks(roleId, regionName);
			List<Network> networks = new ArrayList<>();
			for (com.clustercontrol.ws.cloudn.Network n: ns) {
				Network network = new Network();
				network.setNetworkId(n.getNetworkId());
				network.setName(n.getName());
				network.setZone(n.getAvailabilityZone());
				network.setCidrBlock(n.getCidrBlock());
				network.setVpcId(n.getVpcId());
				networks.add(network);
			}
			return networks;
		} catch (com.clustercontrol.ws.cloudn.CloudManagerFault_Exception
				| com.clustercontrol.ws.cloudn.InvalidRole_Exception
				| com.clustercontrol.ws.cloudn.InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}
	
	@Override
	public List<ServiceOffering> getServiceOfferings() {
		try {
			List<String> flavors = cloudEndpoint.getInstanceFlavorsByService(serviceId);
			List<ServiceOffering> offerings = new ArrayList<ServiceOffering>();
			
			for(String flavor: flavors){
				ServiceOffering offering = new ServiceOffering();
				offering.setName(flavor);
				offerings.add(offering);
			}
			
			return offerings;
		}
		catch (Exception e) {
			throw new IllegalStateException(e);
		}
	}

	@Override
	public List<Snapshot> getSnapshots(String region, List<Filter> filters) {
		try {
			List<com.clustercontrol.ws.cloud.Filter> wsFilters = new ArrayList<com.clustercontrol.ws.cloud.Filter>();
			if(filters != null){
				for (Filter filter: filters) {
					com.clustercontrol.ws.cloud.Filter wsFilter = new com.clustercontrol.ws.cloud.Filter();
					wsFilter.setName(filter.getName());
					wsFilter.getValues().addAll(filter.getValues());
					wsFilters.add(wsFilter);
				}
			}

			List<Snapshot> snapshots = new ArrayList<Snapshot>();
			for (com.clustercontrol.ws.cloud.Snapshot ws: cloudEndpoint.getSnapshotsWithFilter(roleId, region, wsFilters)) {
				Snapshot s = new Snapshot();
				s.setId(ws.getSnapshotId());
				s.setName(ws.getDescription());
				snapshots.add(s);
			}
			return snapshots;
		}
		catch (Exception e) {
			throw new IllegalStateException(e);
		}
	}

	@Override
	public List<DiskOffering> getDiskOfferings() {
		try {
			List<DiskOffering> offerings = new ArrayList<DiskOffering>();
			for (String flavor: cloudEndpoint.getStorageFlavorsByService(serviceId)) {
				DiskOffering offering = new DiskOffering();
				offering.setName(flavor);
				offerings.add(offering);
			}
			return offerings;
		}
		catch (Exception e) {
			throw new IllegalStateException(e);
		}
	}

	@Override
	public List<SecurityGroup> getSecurityGroups(String regionName) {
		try {
			List<SecurityGroup> securityGroups = new ArrayList<>();
			for (com.clustercontrol.ws.cloudn.SecurityGroup wsSecurityGroup: cloudnOptionEndpoint.getSecurityGroups(roleId, regionName)) {
				SecurityGroup securityGroup = new SecurityGroup();
				securityGroup.setId(wsSecurityGroup.getId());
				securityGroup.setName(wsSecurityGroup.getName());
				securityGroup.setDescription(wsSecurityGroup.getDescription());
				if(wsSecurityGroup.getTags() != null && !wsSecurityGroup.getTags().isEmpty()){
					securityGroup.setTags(new ArrayList<Tag>());
					for(com.clustercontrol.ws.cloudn.Tag tag: wsSecurityGroup.getTags()){
						securityGroup.getTags().add(new Tag(tag.getKey(), tag.getValue()));
					}
				}
				securityGroups.add(securityGroup);
			}
			return securityGroups;
		} catch (com.clustercontrol.ws.cloudn.CloudManagerFault_Exception
				| com.clustercontrol.ws.cloudn.InvalidRole_Exception
				| com.clustercontrol.ws.cloudn.InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}
}