/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.dialogs;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.ValidateException;
import com.clustercontrol.cloud.commons.util.annotation.RequiredInput;
import com.clustercontrol.cloud.commons.util.annotation.RequiredSelect;
import com.clustercontrol.cloud.presenter.ICloudService;
import com.clustercontrol.cloud.presenter.ICloudServiceManager;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class EditAccountResourceDialog
extends Dialog {
    private DialogOutput output = new DialogOutput();
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private String strSeparator = this.bundle_messages.getString("caption.title_separator");
    private String strAccountResourceId = this.bundle_messages.getString("word.account_resource_id");
    private String strAccountResourceName = this.bundle_messages.getString("word.account_resource_name");
    private String strAccountResourceDescription = this.bundle_messages.getString("word.account_resource_description");
    private String strCloudServiceId = this.bundle_messages.getString("word.cloud_service_id");
    private String strAccountResource = this.bundle_messages.getString("word.account_resource");
    private String strCloudService = this.bundle_messages.getString("word.cloud_service");
    private Text txtAccountResourceId;
    @RequiredInput(value="strAccountResourceId")
    private Text txtAccountResourceName;
    private Text txtAccountResourceDescription;
    @RequiredSelect(value="strCloudServiceId")
    private Combo cmbCloudServiceId;
    private IDialogBehavior behavior = new DialogBehavior();

    public EditAccountResourceDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 4);
        container.setBackground(SWTResourceManager.getColor(22));
        GridLayout gl_container = new GridLayout(1, false);
        gl_container.verticalSpacing = 15;
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(4, 4, true, false);
        gd_container.verticalAlignment = 4;
        gd_container.horizontalAlignment = 4;
        container.setLayoutData((Object)gd_container);
        Group grpAccountResource = new Group(container, 0);
        GridLayout gl_accountResource = new GridLayout(2, false);
        gl_accountResource.verticalSpacing = 15;
        grpAccountResource.setLayout((Layout)gl_accountResource);
        grpAccountResource.setLayoutData((Object)new GridData(4, 4, true, false));
        grpAccountResource.setText(this.strAccountResource);
        Label lblAccountResourceId = new Label((Composite)grpAccountResource, 131072);
        lblAccountResourceId.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblAccountResourceId.setText(this.strAccountResourceId + this.strSeparator);
        this.txtAccountResourceId = new Text((Composite)grpAccountResource, 2048);
        this.txtAccountResourceId.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblAccountResourceName = new Label((Composite)grpAccountResource, 131072);
        lblAccountResourceName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblAccountResourceName.setText(this.strAccountResourceName + this.strSeparator);
        this.txtAccountResourceName = new Text((Composite)grpAccountResource, 2048);
        this.txtAccountResourceName.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblDescription = new Label((Composite)grpAccountResource, 131072);
        lblDescription.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblDescription.setText(this.strAccountResourceDescription + this.strSeparator);
        this.txtAccountResourceDescription = new Text((Composite)grpAccountResource, 2048);
        this.txtAccountResourceDescription.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Group grpCloudService = new Group(container, 0);
        GridLayout gl_cloudService = new GridLayout(2, false);
        gl_cloudService.verticalSpacing = 15;
        grpCloudService.setLayout((Layout)gl_cloudService);
        grpCloudService.setLayoutData((Object)new GridData(4, 4, true, false));
        grpCloudService.setText(this.strCloudService);
        Label lblCloudServiceId = new Label((Composite)grpCloudService, 131072);
        lblCloudServiceId.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblCloudServiceId.setText(this.strCloudServiceId + this.strSeparator);
        this.cmbCloudServiceId = new Combo((Composite)grpCloudService, 8);
        GridData gd_cloudServiceId = new GridData(4, 4, true, true, 1, 1);
        gd_cloudServiceId.widthHint = 100;
        this.cmbCloudServiceId.setLayoutData((Object)gd_cloudServiceId);
        this.behavior.setupAccountResourceId(this.txtAccountResourceId);
        this.behavior.setupAccountResourceName(this.txtAccountResourceName);
        this.behavior.setupAccountResourceDescription(this.txtAccountResourceDescription);
        this.behavior.setupCloudServiceId(this.cmbCloudServiceId);
        ControlUtil.setRequired(new Control[]{this.txtAccountResourceName});
        container.layout();
        Control[] labels = new Control[]{lblAccountResourceId, lblAccountResourceName, lblDescription, lblCloudServiceId};
        int maxWidth = 0;
        for (Control l : labels) {
            Point p = l.getSize();
            maxWidth = Math.max(maxWidth, p.x);
        }
        for (Control l : labels) {
            ((GridData)l.getLayoutData()).widthHint = maxWidth;
        }
        grpAccountResource.layout(true);
        grpCloudService.layout(true);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 320);
    }

    protected void okPressed() {
        try {
            ControlUtil.validate(this);
        }
        catch (ValidateException e) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)e.getMessage());
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.output.setAccountResourceId(this.txtAccountResourceId.getText());
        this.output.setAccountResourceName(this.txtAccountResourceName.getText());
        this.output.setAccountResourceDescription(this.txtAccountResourceDescription.getText());
        this.output.setCloudServiceId((String)this.cmbCloudServiceId.getData(this.cmbCloudServiceId.getText()));
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.bundle_messages.getString("caption.create_account_resource_dialog"));
    }

    public DialogOutput getOutput() {
        return this.output;
    }

    public void setBehavior(IDialogBehavior behavior) {
        this.behavior = behavior;
    }

    public static class DialogOutput {
        private String accountResourceId;
        private String accountResourceName;
        private String accountResourceDescription;
        private String cloudServiceId;

        public String getAccountResourceId() {
            return this.accountResourceId;
        }

        public void setAccountResourceId(String accountResourceId) {
            this.accountResourceId = accountResourceId;
        }

        public String getAccountResourceName() {
            return this.accountResourceName;
        }

        public void setAccountResourceName(String accountResourceName) {
            this.accountResourceName = accountResourceName;
        }

        public String getAccountResourceDescription() {
            return this.accountResourceDescription;
        }

        public void setAccountResourceDescription(String accountResourceDescription) {
            this.accountResourceDescription = accountResourceDescription;
        }

        public String getCloudServiceId() {
            return this.cloudServiceId;
        }

        public void setCloudServiceId(String cloudServiceId) {
            this.cloudServiceId = cloudServiceId;
        }
    }

    public static class DialogBehavior
    implements IDialogBehavior {
        private ICloudServiceManager cloudServiceManager = Activator.getDefault().getCloudResourceManager().getCloudServiceManager();

        @Override
        public void setupAccountResourceId(Text txtAccountResourceId) {
        }

        @Override
        public void setupAccountResourceName(Text txtAccountResourceName) {
        }

        @Override
        public void setupAccountResourceDescription(Text txtAccountResourceDescription) {
        }

        @Override
        public void setupCloudServiceId(Combo cmbCloudServiceId) {
            for (ICloudService cloudService : this.cloudServiceManager.getCloudServices()) {
                cmbCloudServiceId.add(cloudService.getCloudServiceName());
                cmbCloudServiceId.setData(cloudService.getCloudServiceName(), (Object)cloudService.getCloudServiceId());
            }
            if (cmbCloudServiceId.getItemCount() > 0) {
                cmbCloudServiceId.select(0);
            }
        }
    }

    public static interface IDialogBehavior {
        public void setupAccountResourceId(Text var1);

        public void setupAccountResourceName(Text var1);

        public void setupAccountResourceDescription(Text var1);

        public void setupCloudServiceId(Combo var1);
    }
}

