/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.base.ui.views.actions;

import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.cloudn.base.resources.Zone;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.RestoreStorageDialog;
import com.clustercontrol.cloud.presenter.CreateStorageRequest;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.presenter.ICloudStorageBackup;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class RestoreStorageAction
extends SingleSelectionActionEx {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String msgRestoreStorageConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"word.storage", "word.restore"});
    private String msgRestoreStorageResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.storage", "word.restore"});

    protected void invoke(IAction action) throws InvocationException {
        final ICloudStorageBackup backup = (ICloudStorageBackup)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        IAccountResource.IRegion region = backup.getCloudStorageBackupManager().getRegion();
        final String regionName = region.getRegion();
        final CloudResourceProviderImpl provider = new CloudResourceProviderImpl(region.getAccountResource().getAccountResourceId());
        RestoreStorageDialog dialog = new RestoreStorageDialog(this.viewPart.getSite().getShell());
        dialog.setCloudInfoProvider(provider);
        dialog.setBehavior(new RestoreStorageDialog.IDialogBehavior(){

            @Override
            public void setProvider(CloudResourceProvider provider2) {
            }

            @Override
            public void setupVolumeName(Text txtVolumeName) {
                ObjectMapper om = new ObjectMapper();
                ObjectReader or = om.reader(StorageDetail.class);
                StorageDetail storageDetail = null;
                try {
                    storageDetail = (StorageDetail)or.readValue(backup.getBackupedData().getStorageDetail());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (storageDetail != null && storageDetail.volumeName != null) {
                    txtVolumeName.setText(storageDetail.volumeName);
                }
            }

            @Override
            public void setupZone(Combo cmbZone) {
                cmbZone.setEnabled(false);
                for (Zone zone : provider.getZones(regionName)) {
                    cmbZone.add(zone.getName());
                    cmbZone.setData(zone.getName(), (Object)zone);
                }
                if (cmbZone.getItemCount() > 0) {
                    cmbZone.select(cmbZone.indexOf(backup.getBackupedData().getZone()));
                }
            }

            @Override
            public void setupSnapshotDetail(Text txtSnapshotId, Text txtSnapshotName, Text txtDescription) {
                txtSnapshotId.setText(backup.getStorageBackupId());
                if (backup.getSnapshotName() != null) {
                    txtSnapshotName.setText(backup.getSnapshotName());
                }
                if (backup.getDescription() != null) {
                    txtDescription.setText(backup.getDescription());
                }
            }
        });
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgRestoreStorageConfirm)) {
                RestoreStorageDialog.DialogData output = dialog.getOutput();
                CreateStorageRequest request = new CreateStorageRequest();
                request.setZone(backup.getBackupedData().getZone());
                request.setStorageName(output.getName());
                request.setSnapshotId(backup.getStorageBackupId());
                request.setStorageSize(Integer.valueOf(0));
                request.setStorageDetail("");
                ((ICloudComputeService)region.getCloudService(ICloudComputeService.class)).getStorageManager().createCloudStorage(request);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgRestoreStorageResult);
            } else {
                return;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        ICloudStorageBackup backup = (ICloudStorageBackup)((IStructuredSelection)selection).getFirstElement();
        if (backup == null || backup.getRestoreStatus() == null || backup.getRestoreStatus().equals(ICloudStorageBackup.RestoreStatus.unavailable.name())) {
            action.setEnabled(false);
        }
    }

    private static class StorageDetail {
        public String volumeName;

        private StorageDetail() {
        }
    }
}

