/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.base.commons.util;

import com.clustercontrol.cloud.commons.util.MessageManager;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageManagerExt {
    private static final Map<String, MessageManagerExt> managers = new HashMap<String, MessageManagerExt>();
    private MessageManager messages = null;
    private String fileName;
    private ResourceBundle bundle;

    private MessageManagerExt(String fileName) {
        this.fileName = fileName;
        this.bundle = ResourceBundle.getBundle(fileName);
        try {
            this.messages = MessageManager.getInstance((String)fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageManagerExt getInstance(String fileName) {
        MessageManagerExt manager = null;
        Map<String, MessageManagerExt> map = managers;
        synchronized (map) {
            if (managers.containsKey(fileName)) {
                manager = managers.get(fileName);
            } else {
                manager = new MessageManagerExt(fileName);
                managers.put(fileName, manager);
            }
        }
        return manager;
    }

    public String getString(String key, Object[] args) {
        LinkedList<String> objs = new LinkedList<String>();
        for (Object obj : args) {
            objs.add(this.getString((String)obj));
        }
        MessageFormat messageFormat = new MessageFormat(this.getString(key));
        return messageFormat.format(objs.toArray());
    }

    public String getString(String key) {
        try {
            return this.bundle.getString(key);
        }
        catch (MissingResourceException e) {
            if (this.messages != null) {
                return this.messages.getString(key);
            }
            return key;
        }
    }

    public String getString(String key, String def) {
        try {
            return this.bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return def;
        }
    }

    public String getString(String key, Object[] args, Locale locale) {
        MessageFormat messageFormat = new MessageFormat(this.getString(key, locale));
        return messageFormat.format(args);
    }

    public String getString(String key, Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(this.fileName, locale);
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public String getString(String key, String def, Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(this.fileName, locale);
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return def;
        }
    }
}

