
package com.clustercontrol.ws.cloud;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>restoreStatusのJavaクラス。
 * 
 * <p>次のスキーマ・フラグメントは、このクラス内に含まれる予期されるコンテンツを指定します。
 * <p>
 * <pre>
 * &lt;simpleType name="restoreStatus">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="available"/>
 *     &lt;enumeration value="unavailable"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "restoreStatus")
@XmlEnum
public enum RestoreStatus {

    @XmlEnumValue("available")
    AVAILABLE("available"),
    @XmlEnumValue("unavailable")
    UNAVAILABLE("unavailable");
    private final String value;

    RestoreStatus(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static RestoreStatus fromValue(String v) {
        for (RestoreStatus c: RestoreStatus.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
