/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.presenter.AccountResource;
import com.clustercontrol.cloud.presenter.CloudComputeService;
import com.clustercontrol.cloud.presenter.CloudInstanceBackup;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.CreateInstanceBackupRequest;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.presenter.ICloudInstanceBackupManager;
import com.clustercontrol.cloud.presenter.InternalContainer;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import java.util.List;

public class CloudInstanceBackupManager
extends InternalContainer<CloudInstanceBackup, com.clustercontrol.ws.cloud.CloudInstanceBackup>
implements ICloudInstanceBackupManager {
    private AccountResource.Region region;
    private CloudComputeService cloudComputeService;

    public CloudInstanceBackupManager(CloudComputeService cloudComputeService) {
        this.cloudComputeService = cloudComputeService;
        this.region = cloudComputeService.getRegion();
    }

    @Override
    public AccountResource.Region getRegion() {
        return this.region;
    }

    public CloudInstanceBackup getCloudInstanceBackup(String cloudInstanceBackupId) {
        for (CloudInstanceBackup cloudInstanceBackup : this.getComponents()) {
            if (!cloudInstanceBackup.getInstanceBackupId().equals(cloudInstanceBackupId)) continue;
            return cloudInstanceBackup;
        }
        return null;
    }

    public CloudInstanceBackup[] getCloudInstanceBackups() {
        return this.getComponents().toArray(new CloudInstanceBackup[0]);
    }

    @Override
    public CloudInstanceBackup backupCloudInstance(CreateInstanceBackupRequest createInstanceBackupRequest) {
        com.clustercontrol.ws.cloud.CreateInstanceBackupRequest wsCreateCloudInstanceBackupRequest = new com.clustercontrol.ws.cloud.CreateInstanceBackupRequest();
        ControlUtil.exportObject(createInstanceBackupRequest, wsCreateCloudInstanceBackupRequest);
        try {
            com.clustercontrol.ws.cloud.CloudInstanceBackup reWsCloudInstanceBackup = this.getEndpoint().addInstanceBackup(this.getRoleId(), this.region.getRegion(), wsCreateCloudInstanceBackupRequest);
            CloudInstanceBackup cloudInstanceBackup = CloudInstanceBackup.createCloudInstanceBackup(this, reWsCloudInstanceBackup);
            this.getComponents().add(cloudInstanceBackup);
            this.fireComponentAdded(cloudInstanceBackup);
            return cloudInstanceBackup;
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void removeCloudInstanceBackup(String instanceBackupId) {
        try {
            this.getEndpoint().removeInstanceBackup(this.getRoleId(), this.getRegion().getRegion(), instanceBackupId);
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
        CloudInstanceBackup cloudInstanceBackup = this.getCloudInstanceBackup(instanceBackupId);
        this.getComponents().remove(cloudInstanceBackup);
        this.fireComponentRemoved(cloudInstanceBackup);
    }

    @Override
    protected List<com.clustercontrol.ws.cloud.CloudInstanceBackup> getSources() throws CloudModelException {
        try {
            return this.getEndpoint().getInstanceBackupsByRegion(this.getRoleId(), this.region.getRegion());
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    protected CloudInstanceBackup createComponent(com.clustercontrol.ws.cloud.CloudInstanceBackup source) throws CloudModelException {
        CloudInstanceBackup cloudInstanceBackup = new CloudInstanceBackup(this);
        cloudInstanceBackup.overwrite(source);
        return cloudInstanceBackup;
    }

    @Override
    protected void fireComponentAdded(CloudInstanceBackup addedValue) {
        this.fireElementAdded(ICloudInstanceBackupManager.p2.cloudInstanceBackups, addedValue);
    }

    @Override
    protected void fireComponentRemoved(CloudInstanceBackup removedValue) {
        this.fireElementRemoved(ICloudInstanceBackupManager.p2.cloudInstanceBackups, removedValue);
    }

    private CloudEndpoint getEndpoint() {
        return this.getRegion().getAccountResource().getAccountResourceManager().getCloudResourceManager().getEndpoint(CloudEndpoint.class);
    }

    private String getRoleId() {
        return this.getRegion().getAccountResource().getActiveUser().getRoleId();
    }

    @Override
    public ICloudComputeService getCloudComputeService() {
        return this.cloudComputeService;
    }
}

