/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.presenter;

import java.util.List;

import com.clustercontrol.cloud.resources.Tag;


public interface ICloudInstanceBackup extends IElement {
	public static class BackupedData {
		private final String facilityId;
		private final String facilityName;
		private final String instanceId;
		private final String nodeName;
		private final String flavor;
		private final String instanceDetail;
		private final List<Tag> tags;
		private final String zone;

		public BackupedData(String facilityId, String facilityName,
				String instanceId, String nodeName, String flavor,
				String instanceDetail, List<Tag> tags, String zone) {
			super();
			this.facilityId = facilityId;
			this.facilityName = facilityName;
			this.instanceId = instanceId;
			this.nodeName = nodeName;
			this.flavor = flavor;
			this.instanceDetail = instanceDetail;
			this.tags = tags;
			this.zone = zone;
		}

		public String getFacilityId() {
			return facilityId;
		}
		public String getFacilityName() {
			return facilityName;
		}
		public String getInstanceId() {
			return instanceId;
		}
		public String getNodeName() {
			return nodeName;
		}
		public String getFlavor() {
			return flavor;
		}
		public String getInstanceDetail() {
			return instanceDetail;
		}
		public List<Tag> getTags() {
			return tags;
		}
		public String getZone() {
			return zone;
		}

		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result
					+ ((facilityId == null) ? 0 : facilityId.hashCode());
			result = prime * result
					+ ((facilityName == null) ? 0 : facilityName.hashCode());
			result = prime * result
					+ ((flavor == null) ? 0 : flavor.hashCode());
			result = prime
					* result
					+ ((instanceDetail == null) ? 0 : instanceDetail.hashCode());
			result = prime * result
					+ ((instanceId == null) ? 0 : instanceId.hashCode());
			result = prime * result
					+ ((nodeName == null) ? 0 : nodeName.hashCode());
			result = prime * result + ((tags == null) ? 0 : tags.hashCode());
			result = prime * result + ((zone == null) ? 0 : zone.hashCode());
			return result;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			BackupedData other = (BackupedData) obj;
			if (facilityId == null) {
				if (other.facilityId != null)
					return false;
			} else if (!facilityId.equals(other.facilityId))
				return false;
			if (facilityName == null) {
				if (other.facilityName != null)
					return false;
			} else if (!facilityName.equals(other.facilityName))
				return false;
			if (flavor == null) {
				if (other.flavor != null)
					return false;
			} else if (!flavor.equals(other.flavor))
				return false;
			if (instanceDetail == null) {
				if (other.instanceDetail != null)
					return false;
			} else if (!instanceDetail.equals(other.instanceDetail))
				return false;
			if (instanceId == null) {
				if (other.instanceId != null)
					return false;
			} else if (!instanceId.equals(other.instanceId))
				return false;
			if (nodeName == null) {
				if (other.nodeName != null)
					return false;
			} else if (!nodeName.equals(other.nodeName))
				return false;
			if (tags == null) {
				if (other.tags != null)
					return false;
			} else if (!tags.equals(other.tags))
				return false;
			if (zone == null) {
				if (other.zone != null)
					return false;
			} else if (!zone.equals(other.zone))
				return false;
			return true;
		}
	}

	public interface p2 {
		static final PropertyId2<ValueObserver2<String>> accountResourceId = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> cloudUserId = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> description = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> instanceBackupId = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> name = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> platform = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> region = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> restoreStatus = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<Long>> regDate = new PropertyId2<ValueObserver2<Long>>();
		static final PropertyId2<ValueObserver2<String>> regUser = new PropertyId2<ValueObserver2<String>>();
		//		static final PropertyId2<ValueObserver2<String>> facilityId = new PropertyId2<ValueObserver2<String>>();
		//		static final PropertyId2<ValueObserver2<String>> facilityName = new PropertyId2<ValueObserver2<String>>();
		//		static final PropertyId2<ValueObserver2<String>> facilityDescription = new PropertyId2<ValueObserver2<String>>();
		//		static final PropertyId2<ValueObserver2<String>> instanceId = new PropertyId2<ValueObserver2<String>>();
		//		static final PropertyId2<ValueObserver2<String>> nodeName = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> cloudTypeId = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<BackupedData>> backupedData = new PropertyId2<ValueObserver2<BackupedData>>();
	}

	String getAccountResourceId();
	String getCloudUserId();
	String getDescription();
	String getInstanceBackupId();
	String getName();
	String getPlatform();
	Long getRegDate();
	String getRegUser();
	String getRegion();
	String getRestoreStatus();
	BackupedData getBackupedData();

	//    String getFacilityDescription();
	//    String getFacilityId();
	//    String getFacilityName();
	//    String getInstanceId();
	//    String getNodeName();

	String getCloudTypeId();

	ICloudInstanceBackupManager getCloudInstanceBackupManager();

	public enum RestoreStatus{
		available,
		unavailable,
		;
	}
}