/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.base.ui.views.actions;

import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.cloudn.base.resources.DiskOffering;
import com.clustercontrol.cloud.cloudn.base.resources.Filter;
import com.clustercontrol.cloud.cloudn.base.resources.Snapshot;
import com.clustercontrol.cloud.cloudn.base.resources.Zone;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.CreateStorageDialog;
import com.clustercontrol.cloud.presenter.CreateStorageRequest;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.ui.views.StoragesView;
import com.clustercontrol.cloud.ui.views.actions.AbstractViewAction;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.util.Messages;
import java.util.Arrays;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

public class CreateStorageAction
extends AbstractViewAction {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String msgCreateStorageConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"word.storage", "word.create"});
    private String msgCreateStorageResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.storage", "word.create"});

    public void invoke(IAction action) throws InvocationException {
        StoragesView view = (StoragesView)this.viewPart;
        IAccountResource.IRegion region = view.getActiveRegion();
        if (region == null) {
            assert (view.getCurrentAccountResource().getRegions().length > 0);
            region = view.getCurrentAccountResource().getRegions()[0];
        }
        final String regionName = region.getRegion();
        final CloudResourceProviderImpl provider = new CloudResourceProviderImpl(region.getAccountResource().getAccountResourceId());
        CreateStorageDialog dialog = new CreateStorageDialog(this.viewPart.getSite().getShell());
        dialog.setCloudInfoProvider(provider);
        dialog.setBehavior(new CreateStorageDialog.IDialogBehavior(){

            @Override
            public void setup(final CreateStorageDialog.DialogControlContainer container) {
                for (Zone zone : provider.getZones(regionName)) {
                    container.getCmbZone().add(zone.getName());
                    container.getCmbZone().setData(zone.getName(), (Object)zone);
                }
                if (container.getCmbZone().getItemCount() > 0) {
                    container.getCmbZone().select(0);
                }
                container.getCmbZone().addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.setupSnapshotList(container);
                    }
                });
                container.getBtnStorage().setSelection(true);
                container.getBtnSnapshot().setSelection(false);
                container.getCmbStorage().setEnabled(true);
                container.getCmbSnapshot().setEnabled(false);
                for (DiskOffering offering : provider.getDiskOfferings()) {
                    container.getCmbStorage().add(offering.getName());
                    container.getCmbStorage().setData(offering.getName(), (Object)offering);
                }
                if (container.getCmbStorage().getItemCount() > 0) {
                    container.getCmbStorage().select(0);
                }
                this.setupSnapshotList(container);
                container.getBtnStorage().addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        container.getCmbStorage().setEnabled(true);
                        container.getCmbSnapshot().setEnabled(false);
                    }
                });
                container.getBtnSnapshot().addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        container.getCmbStorage().setEnabled(false);
                        container.getCmbSnapshot().setEnabled(true);
                    }
                });
            }

            private void setupSnapshotList(CreateStorageDialog.DialogControlContainer container) {
                container.getCmbSnapshot().removeAll();
                Filter filter = new Filter();
                filter.setName("zone");
                filter.setValues(Arrays.asList(container.getCmbZone().getText()));
                for (Snapshot snapshot : provider.getSnapshots(regionName, Arrays.asList(filter))) {
                    container.getCmbSnapshot().add(snapshot.getName());
                    container.getCmbSnapshot().setData(snapshot.getName(), (Object)snapshot);
                }
                if (container.getCmbSnapshot().getItemCount() > 0) {
                    container.getCmbSnapshot().select(0);
                }
            }
        });
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgCreateStorageConfirm)) {
                CreateStorageDialog.DialogData output = dialog.getOutput();
                CreateStorageRequest request = new CreateStorageRequest();
                request.setZone(output.getZone());
                request.setFlavor(output.getStorage());
                request.setStorageName(output.getName());
                request.setSnapshotId(output.getSnapshot());
                request.setStorageSize(Integer.valueOf(0));
                request.setStorageDetail("");
                ((ICloudComputeService)region.getCloudService(ICloudComputeService.class)).getStorageManager().createCloudStorage(request);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgCreateStorageResult);
            } else {
                return;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(true);
    }
}

