/*

Copyright (C) 2010 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.selfcheck.monitor;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.plugin.impl.WebServiceCorePlugin;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * WebServiceの処理待ちリクエスト数を確認する処理の実装クラス
 */
public class WebServiceQueueMonitor extends SelfCheckMonitorBase {

	private static Log m_log = LogFactory.getLog( WebServiceQueueMonitor.class );

	private final int threshold;

	private String monitorId = "SYS_WS";
	public final String subKey = "";
	private String application = "SELFCHECK (Web Service)";

	/**
	 * コンストラクタ
	 * @param validationQuery 動作確認クエリ
	 */
	public WebServiceQueueMonitor(int threshold) {
		this.threshold = threshold;
	}

	/**
	 * セルフチェック処理名
	 */
	@Override
	public String toString() {
		return "monitoring web service";
	}

	/**
	 * 監視項目ID
	 */
	@Override
	public String getMonitorId() {
		return monitorId;
	}

	/**
	 * 監視項目subKey
	 */
	@Override
	public String getSubKey() {
		return subKey;
	}

	/**
	 * データソースへの疎通確認
	 * @return 通知情報（アプリケーション名は未格納）
	 */
	@Override
	public void execute() {
		/** ローカル変数 */
		int queueSize = 0;
		boolean warn = true;

		/** メイン処理 */
		queueSize = WebServiceCorePlugin.getQueueSize();
		if (queueSize <= threshold) {
			m_log.debug("web service queue is normal. (queueSize = " + queueSize + ")");
			warn = false;
		}

		if (warn) {
			m_log.info("web service queue is too large. (queueSize = " + queueSize + ")");
		}
		if (!isNotify(warn)) {
			return;
		}
		AplLogger aplLogger = new AplLogger(PLUGIN_ID, APL_ID);
		String[] msgAttr1 = { Integer.toString(queueSize), Integer.toString(threshold) };
		aplLogger.put(MESSAGE_ID, "008", msgAttr1,
				"too many request to Hinemos Manager (tcp:8080). (queued request " +
						queueSize +
						" > threshold " +
						threshold +
				")");

		return;
	}

}
