package com.clustercontrol.notify.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.persistence.*;

import com.clustercontrol.commons.util.JpaTransactionManager;
import com.clustercontrol.notify.mail.model.MailTemplateInfoEntity;



/**
 * The persistent class for the cc_notify_mail_info database table.
 * 
 */
@Entity
@Table(name="cc_notify_mail_info")
@Cacheable(true)
public class NotifyMailInfoEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	private NotifyMailInfoEntityPK id;
	private String mailAddress;
	private Integer mailFlg;
	private MailTemplateInfoEntity mailTemplateInfoEntity;
	private NotifyInfoEntity notifyInfoEntity;

	@Deprecated
	public NotifyMailInfoEntity() {
	}

	public NotifyMailInfoEntity(NotifyMailInfoEntityPK pk,
			MailTemplateInfoEntity mailTemplateInfoEntity, NotifyInfoEntity notifyInfoEntity) {
		this.setId(pk);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
		this.relateToMailTemplateInfoEntity(mailTemplateInfoEntity);
		this.relateToNotifyInfoEntity(notifyInfoEntity);
	}

	public NotifyMailInfoEntity(String notifyId, Integer priority,
			MailTemplateInfoEntity mailTemplateInfoEntity, NotifyInfoEntity notifyInfoEntity) {
		this(new NotifyMailInfoEntityPK(notifyId, priority), mailTemplateInfoEntity, notifyInfoEntity);
	}


	@EmbeddedId
	public NotifyMailInfoEntityPK getId() {
		return this.id;
	}

	public void setId(NotifyMailInfoEntityPK id) {
		this.id = id;
	}


	@Column(name="mail_address")
	public String getMailAddress() {
		return this.mailAddress;
	}

	public void setMailAddress(String mailAddress) {
		this.mailAddress = mailAddress;
	}


	@Column(name="mail_flg")
	public Integer getMailFlg() {
		return this.mailFlg;
	}

	public void setMailFlg(Integer mailFlg) {
		this.mailFlg = mailFlg;
	}


	//bi-directional many-to-one association to MailTemplateInfoEntity
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="mail_template_id")
	public MailTemplateInfoEntity getMailTemplateInfoEntity() {
		return this.mailTemplateInfoEntity;
	}

	@Deprecated
	public void setMailTemplateInfoEntity(MailTemplateInfoEntity mailTemplateInfoEntity) {
		this.mailTemplateInfoEntity = mailTemplateInfoEntity;
	}

	/**
	 * MailTemplateInfoEntityオブジェクト参照設定<BR>
	 * 
	 * MailTemplateInfoEntity設定時はSetterに代わりこちらを使用すること。
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void relateToMailTemplateInfoEntity(MailTemplateInfoEntity mailTemplateInfoEntity) {
		this.setMailTemplateInfoEntity(mailTemplateInfoEntity);
		if (mailTemplateInfoEntity != null) {
			List<NotifyMailInfoEntity> list = mailTemplateInfoEntity.getNotifyMailInfoEntities();
			if (list == null) {
				list = new ArrayList<NotifyMailInfoEntity>();
			} else {
				for(NotifyMailInfoEntity entity : list){
					if (entity.getId().equals(this.getId())) {
						return;
					}
				}
			}
			list.add(this);
			mailTemplateInfoEntity.setNotifyMailInfoEntities(list);
		}
	}


	//bi-directional many-to-one association to NotifyInfoEntity
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="notify_id", insertable=false, updatable=false)
	public NotifyInfoEntity getNotifyInfoEntity() {
		return this.notifyInfoEntity;
	}

	@Deprecated
	public void setNotifyInfoEntity(NotifyInfoEntity notifyInfoEntity) {
		this.notifyInfoEntity = notifyInfoEntity;
	}

	/**
	 * NotifyInfoEntityオブジェクト参照設定<BR>
	 * 
	 * NotifyInfoEntity設定時はSetterに代わりこちらを使用すること。
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void relateToNotifyInfoEntity(NotifyInfoEntity notifyInfoEntity) {
		this.setNotifyInfoEntity(notifyInfoEntity);
		if (notifyInfoEntity != null) {
			List<NotifyMailInfoEntity> list = notifyInfoEntity.getNotifyMailInfoEntities();
			if (list == null) {
				list = new ArrayList<NotifyMailInfoEntity>();
			} else {
				for(NotifyMailInfoEntity entity : list){
					if (entity.getId().equals(this.getId())) {
						return;
					}
				}
			}
			list.add(this);
			notifyInfoEntity.setNotifyMailInfoEntities(list);
		}
	}

	/**
	 * 削除前処理<BR>
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void unchain() {

		// NotifyInfoEntity
		if (this.notifyInfoEntity != null) {
			List<NotifyMailInfoEntity> list = this.notifyInfoEntity.getNotifyMailInfoEntities();
			if (list != null) {
				Iterator<NotifyMailInfoEntity> iter = list.iterator();
				while(iter.hasNext()) {
					NotifyMailInfoEntity entity = iter.next();
					if (entity.getId().equals(this.getId())){
						iter.remove();
						break;
					}
				}
			}
		}

		// MailTemplateInfoEntity
		if (this.mailTemplateInfoEntity != null) {
			List<NotifyMailInfoEntity> list = this.mailTemplateInfoEntity.getNotifyMailInfoEntities();
			if (list != null) {
				Iterator<NotifyMailInfoEntity> iter = list.iterator();
				while(iter.hasNext()) {
					NotifyMailInfoEntity entity = iter.next();
					if (entity.getId().equals(this.getId())){
						iter.remove();
						break;
					}
				}
			}
		}
	}

}