/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlType;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ジョブの終了状態に関する情報を保持するクラス<BR>
 * 
 * @version 2.0.0
 * @since 1.0.0
 */
@XmlType(namespace = "http://jobmanagement.ws.clustercontrol.com")
public class JobEndStatusInfo implements Serializable, Comparable<JobEndStatusInfo> {
	/** シリアライズ可能クラスに定義するUID */
	private static final long serialVersionUID = 5256607875379422805L;

	/** ログ出力のインスタンス<BR> */
	private static Log m_log = LogFactory.getLog( JobEndStatusInfo.class );

	/** 終了状態の種別 */
	private Integer m_type = new Integer(0);

	/** 終了状態の終了値 */
	private Integer m_value = new Integer(0);

	/** 終了値範囲(開始) */
	private Integer m_startRangeValue = new Integer(0);

	/** 終了値範囲(終了) */
	private Integer m_endRangeValue = new Integer(0);

	/**
	 * 終了値範囲(終了)を返す
	 * @return 終了値範囲(終了)
	 */
	public Integer getEndRangeValue() {
		return m_endRangeValue;
	}

	/**
	 * 終了値範囲(終了)を設定する。<BR>
	 * @param endRangeValue 終了値範囲(終了)
	 */
	public void setEndRangeValue(Integer endRangeValue) {
		this.m_endRangeValue = endRangeValue;
	}

	/**
	 * 終了値範囲(開始)を返す。<BR>
	 * @return 終了値範囲(開始)
	 */
	public Integer getStartRangeValue() {
		return m_startRangeValue;
	}

	/**
	 * 終了値範囲(開始)を設定する。<BR>
	 * @param startRangeValue 終了値範囲(開始)
	 */
	public void setStartRangeValue(Integer startRangeValue) {
		this.m_startRangeValue = startRangeValue;
	}

	/**
	 * 終了状態の種別を返す。<BR>
	 * @return 終了状態の種別
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public Integer getType() {
		return m_type;
	}

	/**
	 * 終了状態の種別を設定する。<BR>
	 * @param type 終了状態の種別
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public void setType(Integer type) {
		this.m_type = type;
	}

	/**
	 * 終了状態の終了値を返す。<BR>
	 * @return 終了状態の終了値
	 */
	public Integer getValue() {
		return m_value;
	}

	/**
	 * 終了状態の終了値を設定する。<BR>
	 * @param value 終了状態の終了値
	 */
	public void setValue(Integer value) {
		this.m_value = value;
	}

	@Override
	public boolean equals(Object o) {
		if (!(o instanceof JobEndStatusInfo)) {
			return false;
		}
		JobEndStatusInfo o1 = this;
		JobEndStatusInfo o2 = (JobEndStatusInfo)o;

		boolean ret = false;
		ret = 	equalsSub(o1.getType(), o2.getType()) &&
				equalsSub(o1.getValue(), o2.getValue()) &&
				equalsSub(o1.getStartRangeValue(), o2.getStartRangeValue()) &&
				equalsSub(o1.getEndRangeValue(), o2.getEndRangeValue());

		if (!ret) {
			m_log.debug("type = " + equalsSub(o1.getType(), o2.getType()));
			m_log.debug("value = " + equalsSub(o1.getValue(), o2.getValue()));
			m_log.debug("startRange = " + equalsSub(o1.getStartRangeValue(), o2.getStartRangeValue()));
			m_log.debug("endRange = " + equalsSub(o1.getEndRangeValue(), o2.getEndRangeValue()));
		}
		return ret;
	}

	private boolean equalsSub(Object o1, Object o2) {
		if (o1 == null && o2 == null) {
			return true;
		}
		if (o1 != null && o2 == null) {
			return false;
		}
		if (o1 == null && o2 != null) {
			return false;
		}
		boolean ret = o1.equals(o2);
		return ret;
	}

	@Override
	public int compareTo(JobEndStatusInfo o) {
		return this.getType() - o.getType();
	}

	/**
	 * 単体テスト用
	 * @param args
	 */
	public static void main (String args[]) {
		testEquals();
	}
	/**
	 * 単体テスト
	 */
	public static void testEquals(){

		System.out.println("=== JobEndStatusInfo の単体テスト ===");

		System.out.println("*** 全部一致 ***");
		JobEndStatusInfo info1 = new JobEndStatusInfo();
		info1.setType(0);
		info1.setValue(0);
		info1.setStartRangeValue(0);
		info1.setEndRangeValue(0);

		JobEndStatusInfo info2 = new JobEndStatusInfo();
		info2.setType(0);
		info2.setValue(0);
		info2.setStartRangeValue(0);
		info2.setEndRangeValue(0);

		judge(true,info1.equals(info2));

		System.out.println("*** 「終了状態の種別」のみ違う ***");
		info2 = new JobEndStatusInfo();
		info2.setType(1);
		info2.setValue(0);
		info2.setStartRangeValue(0);
		info2.setEndRangeValue(0);

		judge(false,info1.equals(info2));

		System.out.println("*** 「終了状態の終了値」のみ違う ***");
		info2 = new JobEndStatusInfo();
		info2.setType(0);
		info2.setValue(1);
		info2.setStartRangeValue(0);
		info2.setEndRangeValue(0);

		judge(false,info1.equals(info2));

		System.out.println("*** 「終了値範囲(開始)」のみ違う ***");
		info2 = new JobEndStatusInfo();
		info2.setType(0);
		info2.setValue(0);
		info2.setStartRangeValue(1);
		info2.setEndRangeValue(0);

		judge(false,info1.equals(info2));

		System.out.println("*** 「終了値範囲(終了)」のみ違う ***");
		info2 = new JobEndStatusInfo();
		info2.setType(0);
		info2.setValue(0);
		info2.setStartRangeValue(0);
		info2.setEndRangeValue(1);

		judge(false,info1.equals(info2));
	}

	public static JobEndStatusInfo createSampleInfo() {
		JobEndStatusInfo info = new JobEndStatusInfo();
		info.setType(0);
		info.setValue(0);
		info.setStartRangeValue(0);
		info.setEndRangeValue(0);
		return info;
	}
	/**
	 * 単体テストの結果が正しいものか判断する
	 * @param judge
	 * @param result
	 */
	private static void judge(boolean judge, boolean result){

		System.out.println("expect : " + judge);
		System.out.print("result : " + result);
		String ret = "NG";
		if (judge == result) {
			ret = "OK";
		}
		System.out.println("    is ...  " + ret);
	}
}