package com.clustercontrol.performance.view.action;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.jfree.chart.ChartUtilities;

import com.clustercontrol.performance.view.PerformanceGraphView;
import com.clustercontrol.util.Messages;

public class WriteChartAction implements IViewActionDelegate {

	public static final String ID = "com.clustercontrol.performance.view.action.WriteChartAction";


	@Override
	public void run(IAction action) {

		IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();

		// 同じクラスのViewを複数作るため、IDで特定不可
		// アクティブなviewを取得する
		String viewTitle = page.getActivePart().getTitle();
		IViewReference[] refs = page.getViewReferences();
		for (IViewReference ref : refs) {

			if (ref.getView(false) instanceof PerformanceGraphView) {
				PerformanceGraphView view = (PerformanceGraphView) ref.getView(false);
				if (view.getTitle().equals(viewTitle)) {

					// シェルを取得
					Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();

					// ファイルダイアログを開く
					FileDialog dialog = new FileDialog(shell, SWT.SAVE);
					String[] extensions = {".png"};
					dialog.setFilterExtensions(extensions);
					String filePath = dialog.open();
					if(filePath != null && !"".equals(filePath)){
						FileOutputStream out = null;
						try {
							out = new FileOutputStream(filePath);
							ChartUtilities.writeChartAsPNG(out, view.getChart(), 640, 480);
							MessageDialog.openInformation(
									null,
									Messages.getString("successful"),
									com.clustercontrol.performance.util.Messages.getString("MSG_WRITE_CHART_SUCCESS"));

						} catch (FileNotFoundException e) {
							MessageDialog.openError(
									null,
									Messages.getString("failed"),
									com.clustercontrol.performance.util.Messages.getString("MSG_WRITE_CHART_FAILED"));

						} catch (IOException e) {
							MessageDialog.openError(
									null,
									Messages.getString("failed"),
									com.clustercontrol.performance.util.Messages.getString("MSG_WRITE_CHART_FAILED"));

						} finally {
							if (out != null) {
								try {
									out.close();
								} catch (IOException e) {
									MessageDialog.openError(
											null,
											Messages.getString("failed"),
											com.clustercontrol.performance.util.Messages.getString("MSG_WRITE_CHART_FAILED"));
								}
							}
						}
					}

				}
			}
		}

	}

	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		// TODO Auto-generated method stub

	}

	@Override
	public void init(IViewPart view) {
		// TODO Auto-generated method stub

	}

}
