/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.notify.mail.view.action;

import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.PropertyDefineConstant;
import com.clustercontrol.notify.mail.composite.MailTemplateListComposite;
import com.clustercontrol.notify.mail.action.GetMailTemplateListTableDefine;
import com.clustercontrol.notify.mail.dialog.MailTemplateCreateDialog;
import com.clustercontrol.notify.mail.view.MailTemplateListView;
import com.clustercontrol.util.Messages;

/**
 * メールテンプレート[一覧]ビューの編集アクションクラス<BR>
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class MailTemplateModifyAction implements IViewActionDelegate {

	/** アクションID */
	public static final String ID = "com.clustercontrol.notify.mail.view.action.MailTemplateModifyAction";

	/** ビュー */
	private IViewPart viewPart;

	@Override
	public void run(IAction action) {
		// 選択アイテムの取得
		MailTemplateListView view = (MailTemplateListView) this.viewPart.getAdapter(MailTemplateListView.class);

		MailTemplateListComposite composite = (MailTemplateListComposite) view.getListComposite();
		StructuredSelection selection = (StructuredSelection) composite.getTableViewer().getSelection();

		List list = (List) selection.getFirstElement();
		String mailTemplateId = null;
		if(list != null && list.size() > 0){
			mailTemplateId = (String) list.get(GetMailTemplateListTableDefine.MAIL_TEMPLATE_ID);
		}

		Table table = composite.getTableViewer().getTable();

		// 選択アイテムがある場合に、編集ダイアログを表示する
		if(mailTemplateId != null){
			MailTemplateCreateDialog dialog = new MailTemplateCreateDialog(view.getListComposite().getShell(), mailTemplateId, PropertyDefineConstant.MODE_MODIFY);
			if (dialog.open() == IDialogConstants.OK_ID) {
				int selectIndex = table.getSelectionIndex();
				composite.update();
				table.setSelection(selectIndex);
			}
		}
		else{
			MessageDialog.openWarning(
					null,
					Messages.getString("warning"),
					Messages.getString("message.notify.mail.8"));
		}
	}

	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		// TODO Auto-generated method stub

	}

	@Override
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}

}
