/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.view;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import com.clustercontrol.collectiverun.composite.DetailComposite;
import com.clustercontrol.view.CommonViewPart;

/**
 * 一括制御[詳細]ビュークラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 * 
 */
public class DetailView extends CommonViewPart {
	public static final String ID = "com.clustercontrol.collectiverun.view.DetailView";

	// ----- instance フィールド ----- //

	/** 詳細コンポジット */
	private DetailComposite detailComposite = null;

	/**
	 * コンストラクタ
	 * 
	 */
	public DetailView() {
		super();
	}

	/**
	 * ViewPartへのコントロール作成処理
	 * 
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void createPartControl(Composite parent) {
		GridLayout layout = new GridLayout(1, true);
		parent.setLayout(layout);
		layout.marginHeight = 0;
		layout.marginWidth = 0;

		//詳細作成
		detailComposite = new DetailComposite(parent, SWT.NONE);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		detailComposite.setLayoutData(gridData);

		update(null);

	}

	/**
	 * 更新処理
	 * 
	 */
	public void update(String sessionId) {
		detailComposite.update(sessionId);
	}

	/**
	 * アダプターとして要求された場合、自身のインスタンスを渡します。
	 * 
	 * @param cls
	 *            クラスのインスタンス
	 * @return 自身のインスタンス
	 */
	@Override
	public Object getAdapter(Class cls) {
		if (cls.isInstance(this)) {
			return this;
		} else {
			return super.getAdapter(cls);
		}
	}
}