/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyDefineConstant;
import com.clustercontrol.collectiverun.bean.HistoryFilterPropertyConstant;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.ws.collectiverun.HistoryFilterInfo;
import com.clustercontrol.ws.collectiverun.InvalidRole_Exception;

/**
 * 一括制御履歴フィルタ情報のDTOとプロパティを相互変換するためのユーティリティクラスです。
 * @since 0.1
 */
public class HistoryFilterPropertyUtil {

	// ログ
	private static Log m_log = LogFactory.getLog( HistoryFilterPropertyUtil.class );

	/**
	 * プロパティを一括制御履歴フィルタ情報DTOに変換するメソッドです。
	 * 
	 * @param property
	 * @return 一括制御履歴フィルタ情報
	 */
	public static HistoryFilterInfo property2dto(Property property){
		HistoryFilterInfo filter = new HistoryFilterInfo();

		ArrayList values = null;
		//開始・再実行日時（自）取得
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.START_FROM_DATE);
		Date startFromDate = null;
		if(values.get(0) != null && values.get(0) instanceof Date){
			startFromDate = (Date)values.get(0);
			filter.setStartFromDate(startFromDate.getTime());
		}
		//開始・再実行日時（至）取得
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.START_TO_DATE);
		Date startToDate = null;
		if(values.get(0) != null && values.get(0) instanceof Date){
			startToDate = (Date)values.get(0);
			filter.setStartToDate(startToDate.getTime());
		}
		//終了・中断日時（自）取得
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.END_FROM_DATE);
		Date endFromDate = null;
		if(values.get(0) != null && values.get(0) instanceof Date){
			endFromDate = (Date)values.get(0);
			filter.setEndFromDate(endFromDate.getTime());
		}
		//終了・中断日時（至）取得
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.END_TO_DATE);
		Date endToDate = null;
		if(values.get(0) != null && values.get(0) instanceof Date){
			endToDate = (Date)values.get(0);
			filter.setEndToDate(endToDate.getTime());
		}
		//管理種別取得
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.TYPE);
		String type = null;
		if(values.get(0) instanceof String && ((String)values.get(0)).length() > 0){
			type = (String)values.get(0);
		}
		filter.setType(type);
		//状態取得
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.STATUS);
		String status = null;
		if(values.get(0) instanceof String){
			status = (String)values.get(0);
		}
		filter.setStatus(status);
		return filter;
	}

	/**
	 * 履歴フィルタ用プロパティを返します。
	 * 
	 * @param local
	 * @return 履歴フィルタ用プロパティ
	 * @throws FinderException
	 * @throws NamingException
	 * @throws HinemosUnknown
	 */
	public static Property getProperty(Locale locale) throws HinemosUnknown {

		//開始日時（自）
		Property m_startFromDate =
				new Property(HistoryFilterPropertyConstant.START_FROM_DATE, Messages.getString("start", locale), PropertyDefineConstant.EDITOR_DATETIME);
		//開始日時（至）
		Property m_startToDate =
				new Property(HistoryFilterPropertyConstant.START_TO_DATE, Messages.getString("end", locale), PropertyDefineConstant.EDITOR_DATETIME);
		//終了日時（自）
		Property m_endFromDate =
				new Property(HistoryFilterPropertyConstant.END_FROM_DATE, Messages.getString("start", locale), PropertyDefineConstant.EDITOR_DATETIME);
		//終了日時（至）
		Property m_endToDate =
				new Property(HistoryFilterPropertyConstant.END_TO_DATE, Messages.getString("end", locale), PropertyDefineConstant.EDITOR_DATETIME);
		//管理種別
		Property m_type =
				new Property(HistoryFilterPropertyConstant.TYPE, Messages.getString("type", locale), PropertyDefineConstant.EDITOR_SELECT);
		//状態
		Property m_status =
				new Property(HistoryFilterPropertyConstant.STATUS, Messages.getString("run.status", locale), PropertyDefineConstant.EDITOR_SELECT);

		//開始日時
		Property m_startDate =
				new Property(HistoryFilterPropertyConstant.START_DATE, Messages.getString("start.time", locale), PropertyDefineConstant.EDITOR_TEXT);
		//終了日時
		Property m_endDate =
				new Property(HistoryFilterPropertyConstant.END_DATE, Messages.getString("end.time", locale), PropertyDefineConstant.EDITOR_TEXT);

		//値を初期化
		Object statusValues[][] = {
				{ "", StatusConstant.STRING_RUNNING, StatusConstant.STRING_END },
				{ "", StatusConstant.STRING_RUNNING, StatusConstant.STRING_END }};

		m_status.setSelectValues(statusValues);
		m_status.setValue("");

		List<String> typeStringList = null;

		try {
			typeStringList = CollectiveRunEndpointWrapper.getTypeStringList();
		} catch (InvalidRole_Exception e) {
			MessageDialog.openInformation(null, Messages.getString("message"),
					Messages.getString("message.accesscontrol.16"));
		} catch (Exception e) {
			m_log.warn("getProperty(), " + e.getMessage(), e);
			MessageDialog.openError(
					null,
					Messages.getString("failed"),
					Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());
		}

		typeStringList.add(0, "");

		Object typeValues[][] = {
				new Object[typeStringList.size()],
				new Object[typeStringList.size()]};

		for(int i = 0; i < typeStringList.size(); i++){
			typeValues[PropertyDefineConstant.SELECT_VALUE][i] = typeStringList.get(i);
			typeValues[PropertyDefineConstant.SELECT_DISP_TEXT][i] = typeStringList.get(i);
		}

		m_type.setSelectValues(typeValues);
		m_type.setValue("");

		m_startFromDate.setValue("");
		m_startToDate.setValue("");
		m_endFromDate.setValue("");
		m_endToDate.setValue("");

		m_startDate.setValue("");
		m_endDate.setValue("");

		//変更の可/不可を設定
		m_startFromDate.setModify(PropertyDefineConstant.MODIFY_OK);
		m_startToDate.setModify(PropertyDefineConstant.MODIFY_OK);
		m_endFromDate.setModify(PropertyDefineConstant.MODIFY_OK);
		m_endToDate.setModify(PropertyDefineConstant.MODIFY_OK);
		m_type.setModify(PropertyDefineConstant.MODIFY_OK);
		m_status.setModify(PropertyDefineConstant.MODIFY_OK);

		m_startDate.setModify(PropertyDefineConstant.MODIFY_NG);
		m_endDate.setModify(PropertyDefineConstant.MODIFY_NG);

		Property property = new Property(null, null, "");

		// 初期表示ツリーを構成。
		property.removeChildren();
		property.addChildren(m_startDate);
		property.addChildren(m_endDate);
		property.addChildren(m_type);
		property.addChildren(m_status);

		// 開始・再実行日時
		m_startDate.removeChildren();
		m_startDate.addChildren(m_startFromDate);
		m_startDate.addChildren(m_startToDate);

		// 終了・中断日時
		m_endDate.removeChildren();
		m_endDate.addChildren(m_endFromDate);
		m_endDate.addChildren(m_endToDate);

		return property;
	}
}
