/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.composite.action;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.collectiverun.action.GetHistoryTableDefine;
import com.clustercontrol.collectiverun.composite.HistoryComposite;
import com.clustercontrol.collectiverun.composite.ParameterViewComposite;
import com.clustercontrol.collectiverun.view.DetailView;
import com.clustercontrol.collectiverun.view.ParameterView;

/**
 * 履歴テーブルのSelectionChangedListenerクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class HistorySelectionChangedListener implements
ISelectionChangedListener {
	private HistoryComposite m_composite;

	/**
	 * コンストラクタ
	 * 
	 * @param composite
	 * @since 1.0.0
	 */
	public HistorySelectionChangedListener(HistoryComposite composite) {
		m_composite = composite;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
	 */
	@Override
	public void selectionChanged(SelectionChangedEvent event) {
		String sessionId = null;

		//セッションIDを取得
		if (((StructuredSelection) event.getSelection()).getFirstElement() != null) {
			ArrayList info = (ArrayList) ((StructuredSelection) event
					.getSelection()).getFirstElement();
			sessionId = (String) info.get(GetHistoryTableDefine.SESSION_ID);
			//セッションIDを設定
			m_composite.setSessionId(sessionId);
		}

		//アクティブページを手に入れる
		IWorkbenchPage page = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage();

		//詳細ビューを表示する
		IViewPart viewPart = page.findView(DetailView.ID);
		if (viewPart != null) {
			DetailView view = (DetailView) viewPart
					.getAdapter(DetailView.class);
			view.update(sessionId);
		}

		//パラメータビューを表示する
		viewPart = page.findView(ParameterView.ID);
		if (viewPart != null) {
			ParameterView view = (ParameterView) viewPart
					.getAdapter(ParameterView.class);
			ParameterViewComposite composite = view.getComposite();
			composite.update(sessionId);
		}
	}
}

