/*

Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;

import com.clustercontrol.jobmanagement.util.JobEditStateUtil;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.JobInfo;

/**
 * IApplication実装クラス<BR>
 * 
 * RCP起動時のエントリポイントとなるクラス
 * クライアントの表示に利用します。
 * 
 * @version 4.1.0
 * @since 1.0.0
 */
public class ClusterControl implements IApplication {

	private static Log m_log = LogFactory.getLog( ClusterControl.class );

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.IPlatformRunnable#run(java.lang.Object)
	 */
	@Override
	public Object start(IApplicationContext context) throws Exception {
		m_log.debug("run()");

		WorkbenchAdvisor advisor = new ClusterControlWorkbenchAdvisor();
		Display display = PlatformUI.createDisplay();
		try {
			int ret = PlatformUI.createAndRunWorkbench(display, advisor);
			if (ret == PlatformUI.RETURN_RESTART) {
				return IApplication.EXIT_RESTART;
			} else {
				return IApplication.EXIT_OK;
			}
		} finally {

			if (JobEditStateUtil.getLockedJobunitList().size() > 0) {
				// ロックしているジョブユニットがある場合
				for (JobInfo jobunit : JobEditStateUtil.getLockedJobunitList()) {
					try {
						JobEndpointWrapper.releaseEditLock(JobEditStateUtil.getEditSession(jobunit));
						JobEditStateUtil.removeLockedJobunit(jobunit);
					} catch (Exception e) {
						m_log.warn("dispose() : " + e.getMessage());
					}
				}
			}
			JobEditStateUtil.clearEditStateAll();
			display.dispose();
		}
	}

	@Override
	public void stop() {
		// TODO Auto-generated method stub

	}
}