/*

Copyright (C) 2012 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.systemlog;

import java.nio.charset.Charset;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.HinemosProperties;
import com.clustercontrol.notify.util.LogNotifier;
import com.clustercontrol.systemlog.service.SyslogReceiver.Mode;

public class SyslogReceiverConfig {

	private final static Log _log = LogFactory.getLog(SyslogReceiverConfig.class);

	private volatile String receiverId = System.getProperty("hinemos.manager.nodename");

	private volatile String listenAddress = "0.0.0.0";

	private volatile int listenPort = 24514;

	private volatile Charset charset = Charset.forName("UTF-8");

	private volatile Mode queueMode = Mode.POOLED_MULTI_THREAD;

	private volatile int threadPoolSize = 1;

	private volatile int filterTaskQueueSize = 15 * 60 * 30;	// 15[min] * 30[msg/sec] (about 27mbyte)

	private volatile LogNotifier logNotifier;
	private volatile String logNotifierClass;

	public SyslogReceiverConfig() {
		try {
			if (HinemosProperties.isHaOption()) {
				logNotifierClass = "com.clustercontrol.ha.notify.LogSuppressiveNotifier";
			} else {
				logNotifierClass = "com.clustercontrol.notify.util.LogDirectNotifier";
			}
			Class<LogNotifier> clazz = (Class<LogNotifier>)Class.forName(logNotifierClass);
			logNotifier = clazz.newInstance();
		} catch (Exception e) {
			_log.warn("LogNotifierClass is not initialized.", e);
		}
	}

	public synchronized void setReceiverId(String id) {
		this.receiverId = id;
	}

	public String getReceiverId() {
		return receiverId;
	}

	public synchronized void setListenAddress(String addr) {
		this.listenAddress = addr;
	}

	public String getListenAddress() {
		return listenAddress;
	}

	public synchronized void setLisntenPort(int port) {
		this.listenPort = port;
	}

	public int getListenPort() {
		return listenPort;
	}

	public synchronized void setCharset(Charset charset) {
		this.charset = charset;
	}

	public Charset getCharset() {
		return charset;
	}

	public synchronized void setQueueMode(Mode mode) {
		this.queueMode = mode;
	}

	public Mode getQueueMode() {
		return queueMode;
	}

	public synchronized void setThreadPoolSize(int size) {
		this.threadPoolSize = size;
	}

	public int getThreadPoolSize() {
		return threadPoolSize;
	}

	public synchronized void setFilterTaskQueueSize(int size) {
		this.filterTaskQueueSize = size;
	}

	public int getFilterTaskQueueSize() {
		return filterTaskQueueSize;
	}

	public synchronized void setLogNotifierClass(String className) {

		try {
			if (className != null) {
				Class<LogNotifier> clazz = (Class<LogNotifier>)Class.forName(className);
				logNotifier = clazz.newInstance();
				logNotifierClass = className;
			}
		} catch (Exception e) {
			_log.warn("LogNotifierClass is not initialized.", e);
		}
	}

	public String getLogNotifierClass() {
		return logNotifierClass;
	}

	public LogNotifier getLogNotifier() {
		return logNotifier;
	}

	@Override
	public String toString() {
		return this.getClass().getSimpleName() + " [receiverId = " + getReceiverId()
		+ ", listenAddress = " + getListenAddress()
		+ ", listenPort = " + getListenPort()
		+ ", charset = " + getCharset()
		+ ", queueMode = " + getQueueMode()
		+ ", threadPoolSize = " + getThreadPoolSize()
		+ ", logNotifier = " + getLogNotifierClass() + "]";
	}

}
