package com.clustercontrol.snmptrap.util;

import com.clustercontrol.commons.util.HinemosProperties;
import com.clustercontrol.snmptrap.bean.SnmpTrapV1;

public abstract class AbstractSnmpTrapNotifier implements SnmpTrapNotifier {

	public static final String MESSAGE_ID_INFO = "001";
	public static final String MESSAGE_ID_WARNING = "002";
	public static final String MESSAGE_ID_CRITICAL = "003";
	public static final String MESSAGE_ID_UNKNOWN = "004";

	public static final int _messageMaxLength = 255;

	public static String replaceUnsafeCharacter(String str) {

		String charList = HinemosProperties.getProperty("common.notify.replace.before", "0");
		char newChar = HinemosProperties.getProperty("common.notify.replace.after", "?").charAt(0);

		for (String oldCharByte : charList.split(",")) {
			int oldCharInt = Integer.parseInt(oldCharByte);
			Character oldChar = (char)oldCharInt;
			if (str != null) {
				str = str.replace(oldChar, newChar);
			}
		}

		return str;
	}

	@Override
	public abstract void put(SnmpTrapV1 snmptrap, String monitorId, String notifyGroupId, int priority,
			String facilityId, String facilityPath, String application, String msg, String msgOrig);

	@Override
	public abstract void shutdown();

}
