/*

Copyright (C) 2008 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.factory;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.MonitorNotFound;
import com.clustercontrol.fault.NotifyNotFound;
import com.clustercontrol.commons.scheduler.TriggerScheduler;
import com.clustercontrol.commons.scheduler.TriggerSchedulerException;
import com.clustercontrol.monitor.run.factory.ModifyMonitorTrapValueType;
import com.clustercontrol.snmptrap.bean.TrapCheckInfo;
import com.clustercontrol.snmptrap.ejb.entity.MonitorTrapInfoLocal;
import com.clustercontrol.snmptrap.ejb.entity.MonitorTrapInfoUtil;
import com.clustercontrol.snmptrap.util.CharsetUtil;

/**
 * SNMPTRAP監視情報を変更するクラス<BR>
 *
 * @version 4.0.0
 * @since 4.0.0
 */
public class ModifyMonitorTrap extends ModifyMonitorTrapValueType {

	private static Log m_log = LogFactory.getLog( ModifyMonitorTrap.class );

	/**
	 * SNMPトラップ監視設定の変更(変更時に文字コードをチェック)
	 */
	@Override
	protected boolean modifyMonitorInfo(String user) throws CreateException,
	RemoveException, NamingException, NotifyNotFound,
	HinemosUnknown, MonitorNotFound,
	TriggerSchedulerException {
		CharsetUtil.checkCharset(m_monitorInfo);

		return super.modifyMonitorInfo(user);
	}

	@Override
	protected boolean modifyCheckInfo() throws CreateException, FinderException,
	NamingException {

		m_log.debug("modifyCheckInfo() : start");

		// SNMPTRAP監視情報を取得
		MonitorTrapInfoLocal trapLocal = MonitorTrapInfoUtil.getLocalHome().findByPrimaryKey(m_monitorInfo.getMonitorId());

		TrapCheckInfo trap = m_monitorInfo.getTrapCheckInfo();
		if(m_log.isDebugEnabled()){
			m_log.debug("modifyCheckInfo() : " +
					" MonitorId = " + trap.getMonitorId() +
					",CommunityName = " + trap.getCommunityName() +
					",CheckMode = " + trap.getCheckMode() +
					",CommunityCheck = " + trap.getCommunityCheck() +
					",CharsetConvert = " + trap.getCharsetConvert() +
					",CharsetName = " + trap.getCharsetName());
		}
		trapLocal.setCommunityName(trap.getCommunityName());
		trapLocal.setCheckMode(trap.getCheckMode());
		trapLocal.setCommunityCheck(trap.getCommunityCheck());
		trapLocal.setCharsetConvert(trap.getCharsetConvert());
		trapLocal.setCharsetName(trap.getCharsetName());

		m_log.debug("modifyCheckInfo() : end");
		return true;
	}

	/**
	 * スケジュール実行の遅延時間を返します。
	 */
	@Override
	protected int getDelayTime() {
		return 0;
	}

	/**
	 * スケジュール実行種別を返します。
	 */
	@Override
	protected String getTriggerType() {
		return TriggerScheduler.TRIGGER_TYPE_NONE;
	}
}
