/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmp.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * SNMP監視プロパティ情報を取得するクラス<BR>
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class SnmpProperties {
	private static Log m_log = LogFactory.getLog( SnmpProperties.class );

	private static final String VALID_SECOND = "15";
	private static final String VALID_SECOND_KEY = "monitor.snmp.valid.second";

	private static SnmpProperties m_instance = null;

	/** SNMP 取得許容時間（秒） */
	private int m_validSecond;

	/**
	 * このオブジェクトを取得します。
	 * 
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @return ConnectionManager コネクションマネージャ
	 */
	public static SnmpProperties getProperties() {
		if (m_instance==null) {
			m_instance = new SnmpProperties();
		}
		return m_instance;
	}

	/**
	 * コンストラクタ
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 */
	private SnmpProperties() {
		this.setValue();
	}

	/**
	 * SNMP監視情報をプロパティファイルから取得
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 */
	private void setValue() {

		Properties properties = new Properties();

		try {
			String etcdir = System.getProperty("hinemos.manager.etc.dir");
			String propertyFile = etcdir + File.separator + "hinemos.properties";

			// プロパティファイルからキーと値のリストを読み込みます
			properties.load(new FileInputStream(propertyFile));

			String validSecond = properties.getProperty(VALID_SECOND_KEY, VALID_SECOND);
			m_validSecond = new Integer(validSecond).intValue();

		} catch (Exception e) {
			m_log.error("setValue(): " + e.getMessage());
		}
	}

	/**
	 * @return m_validSecond を戻します。
	 */
	public int getValidSecond() {
		return m_validSecond;
	}
}
