/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmp.factory;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import com.clustercontrol.monitor.run.factory.DeleteMonitor;
import com.clustercontrol.snmp.util.ControlSnmpInfo;

/**
 * SNMP監視 数値監視設定を削除するファクトリークラス<BR>
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class DeleteMonitorSnmp extends DeleteMonitor{

	/* (非 Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.DeleteMonitor#deleteCheckInfo()
	 */
	@Override
	protected boolean deleteCheckInfo() throws FinderException, RemoveException, NamingException {

		// SNMP監視情報を削除
		ControlSnmpInfo snmp = new ControlSnmpInfo(m_monitorId, m_monitorTypeId);
		return snmp.delete();
	}
}
