package com.clustercontrol.performance.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryCollectMstData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryCollectMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryCollectMstUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCalcMethodMstData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCalcMethodMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCalcMethodMstUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCodeMstData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCodeMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCodeMstUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorPollingMstData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorPollingMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorPollingMstUtil;

/**
 * 性能収集時のマスターデータのキャッシュ
 *
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class CollectorMasterCache {
	private static Log m_log = LogFactory.getLog( CollectorMasterCache.class );

	// ポーリングデータのキャッシュ
	private static Collection<CollectorCategoryCollectMstData> categoryCollectMstDataListCache = null;
	private static Collection<CollectorItemCodeMstData> itemCodeMstDataListCache = null;
	private static Collection<CollectorItemCalcMethodMstData> itemCalcMethodMstDataListCache = null;
	private static Collection<CollectorPollingMstData> pollingMstDataListCache = null;

	/*
	 * 
	 * Utility
	 * 
	 */

	/**
	 * 指定した収集項目IDのマスタ情報を返却する
	 * 
	 * @param itemCode
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public static CollectorItemCodeMstData getCategoryCodeMst(String itemCode) throws FinderException, NamingException{
		for(CollectorItemCodeMstData data : getItemCodeMstDataListCache()){
			if(data.getItemCode().equals(itemCode)){
				return data;
			}
		}
		return null;
	}


	/**
	 * ポーリング対象の文字列(OIDなど)のリストを取得する
	 * 
	 * @param itemCodeListe
	 * @param collectMethod
	 * @param platformId
	 * @param subPlatformId
	 * @return
	 * @throws NamingException
	 * @throws FinderException
	 */
	protected static ArrayList<String> getPollingTarget(ArrayList<String> itemCodeListe, String collectMethod, String platformId, String subPlatformId) throws NamingException, FinderException{
		Set<String> pollingTargetSet = new HashSet<String>();

		for(String itemCode : itemCodeListe){
			for(CollectorPollingMstData data : getPollingMstDataListCache()){
				if(data.getItemCode().equals(itemCode) &&
						data.getCollectMethod().equals(collectMethod) &&
						data.getPlatformId().equals(platformId) &&
						data.getSubPlatformId().equals(subPlatformId)){
					pollingTargetSet.add(data.getPollingTarget());
				}
			}
		}
		ArrayList<String> pollingTarget = new ArrayList<String>(pollingTargetSet);
		if(m_log.isDebugEnabled()){
			for(String target : pollingTargetSet){
				m_log.debug("getPollingTarget() target = " + target);
			}
		}
		return pollingTarget;
	}

	/**
	 * 指定した収集項目IDの内訳の収集項目IDのリストを返却する
	 * 
	 * @param itemCode
	 * @param collectMethod
	 * @param platformId
	 * @param subPlatformId
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected static ArrayList<String> getBreakdownItemCodeList(String itemCode, String collectMethod, String platformId, String subPlatformId) throws FinderException, NamingException{
		ArrayList<String> breakdownTmpItemCodeList = new ArrayList<String>();

		for(CollectorItemCodeMstData itemCodeMstData : getItemCodeMstDataListCache()){
			if(itemCodeMstData.getParentItemCode() != null &&
					itemCodeMstData.getParentItemCode().equals(itemCode)){
				breakdownTmpItemCodeList.add(itemCodeMstData.getItemCode());
			}
		}
		if(m_log.isDebugEnabled()){
			for(String code : breakdownTmpItemCodeList){
				m_log.debug("getBreakdownItemCodeList() itemCode(tmp) = " + code);
			}
		}

		Set<String> breakdownItemCodeSet = new HashSet<String>();
		for(String tmpItemCode : breakdownTmpItemCodeList){
			for(CollectorItemCalcMethodMstData calcMethod : getItemCalcMethodMstDataListCache()){
				if(calcMethod.getCollectMethod().equals(collectMethod) &&
						calcMethod.getPlatformId().equals(platformId) &&
						calcMethod.getSubPlatformId().equals(subPlatformId) &&
						calcMethod.getItemCode().equals(tmpItemCode)){

					breakdownItemCodeSet.add(tmpItemCode);
					break;
				}

			}
		}
		ArrayList<String> breakdownItemCodeList = new ArrayList<String>(breakdownItemCodeSet);
		if(m_log.isDebugEnabled()){
			for(String code : breakdownItemCodeList){
				m_log.debug("getBreakdownItemCodeList() itemCode = " + code);
			}
		}
		return breakdownItemCodeList;
	}

	/**
	 * 指定したカテゴリの収集方法(SNMP/WBEMなど)を取得する
	 * 
	 * @param platformId
	 * @param subPlatformId
	 * @param categoryCode
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public static String getCollectMethod(String platformId, String subPlatformId, String categoryCode) throws FinderException, NamingException {
		for(CollectorCategoryCollectMstData data : getCategoryCollectMstDataListCache()){
			if(data.getPlatformId().equals(platformId) &&
					data.getSubPlatformId().equals(subPlatformId) &&
					data.getCategoryCode().equals(categoryCode)){
				return data.getCollectMethod();
			}
		}
		return "";
	}

	/**
	 * itemCodeに対応するデバイスタイプを返却
	 * 
	 * @param itemCode
	 * @return
	 * @throws NamingException
	 * @throws FinderException
	 */
	public static String getDeviceType(String itemCode) throws NamingException, FinderException{
		String devicetype = null;
		for(CollectorItemCodeMstData itemCodeMstData : getItemCodeMstDataListCache()){
			if(itemCodeMstData.getItemCode() != null && itemCodeMstData.getItemCode().equals(itemCode)){
				devicetype = itemCodeMstData.getDeviceType();
				break;
			}
		}

		return devicetype;
	}

	/*
	 * 
	 * キャッシュの取得
	 * 
	 */

	/**
	 * CollectorItemCodeMstのキャッシュ
	 * 
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	private static synchronized Collection<CollectorItemCodeMstData> getItemCodeMstDataListCache() throws FinderException, NamingException{
		if(itemCodeMstDataListCache == null){
			itemCodeMstDataListCache = new ArrayList<CollectorItemCodeMstData>();

			Collection<CollectorItemCodeMstLocal> itemCodeMstLocalList =
				CollectorItemCodeMstUtil.getLocalHome().findAll();
			CollectorItemCodeMstData data;
			for(CollectorItemCodeMstLocal local : itemCodeMstLocalList){
				data = new CollectorItemCodeMstData(
						local.getItemCode(),
						local.getCategoryCode(),
						local.getParentItemCode(),
						local.getItemName(),
						local.getMeasure(),
						local.getDeviceSupport(),
						local.getDeviceType(),
						local.getGraphRange());
				itemCodeMstDataListCache.add(data);
			}
		}

		return itemCodeMstDataListCache;
	}

	/**
	 * CollectorItemCalcMethodMstのキャッシュ
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	private static synchronized Collection<CollectorItemCalcMethodMstData> getItemCalcMethodMstDataListCache() throws FinderException, NamingException{
		if(itemCalcMethodMstDataListCache == null){
			itemCalcMethodMstDataListCache = new ArrayList<CollectorItemCalcMethodMstData>();

			Collection<CollectorItemCalcMethodMstLocal> itemCalcMethodMstLocalList =
				CollectorItemCalcMethodMstUtil.getLocalHome().findAll();
			CollectorItemCalcMethodMstData data;
			for(CollectorItemCalcMethodMstLocal local : itemCalcMethodMstLocalList){
				data = new CollectorItemCalcMethodMstData(
						local.getCollectMethod(),
						local.getPlatformId(),
						local.getSubPlatformId(),
						local.getItemCode(),
						local.getCalcMethod());
				itemCalcMethodMstDataListCache.add(data);
			}
		}

		return itemCalcMethodMstDataListCache;
	}

	/**
	 * CollectorPollingMstのキャッシュ
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	private static synchronized Collection<CollectorPollingMstData> getPollingMstDataListCache() throws FinderException, NamingException{
		if(pollingMstDataListCache == null){
			pollingMstDataListCache = new ArrayList<CollectorPollingMstData>();

			Collection<CollectorPollingMstLocal> pollingMstLocalList =
				CollectorPollingMstUtil.getLocalHome().findAll();
			CollectorPollingMstData data ;
			for(CollectorPollingMstLocal local : pollingMstLocalList){
				data = new CollectorPollingMstData(
						local.getCollectMethod(),
						local.getPlatformId(),
						local.getSubPlatformId(),
						local.getItemCode(),
						local.getVariableId(),
						local.getEntryKey(),
						local.getValueType(),
						local.getPollingTarget(),
						local.getFailureValue());
				pollingMstDataListCache.add(data);
			}
		}
		return pollingMstDataListCache;
	}

	/**
	 * CollectorCategoryCollectMstのキャッシュ
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	private static synchronized Collection<CollectorCategoryCollectMstData> getCategoryCollectMstDataListCache() throws FinderException, NamingException{
		if(categoryCollectMstDataListCache == null){
			categoryCollectMstDataListCache = new ArrayList<CollectorCategoryCollectMstData>();

			Collection<CollectorCategoryCollectMstLocal> collects =
				CollectorCategoryCollectMstUtil.getLocalHome().findAll();
			for(CollectorCategoryCollectMstLocal collect : collects){
				CollectorCategoryCollectMstData data =
					new CollectorCategoryCollectMstData(
							collect.getPlatformId(),
							collect.getSubPlatformId(),
							collect.getCategoryCode(),
							collect.getCollectMethod());

				categoryCollectMstDataListCache.add(data);
			}
		}
		return categoryCollectMstDataListCache;
	}

}
