/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

 */

package com.clustercontrol.performance.monitor.factory;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.NotifyNotFound;

import com.clustercontrol.monitor.run.factory.DeleteMonitor;
import com.clustercontrol.performance.monitor.ejb.entity.MonitorPerfInfoLocal;
import com.clustercontrol.performance.monitor.ejb.entity.MonitorPerfInfoUtil;

/**
 * リソース監視情報削除クラス
 *
 * @version 4.0.0
 * @since 2.0.0
 */
public class DeleteMonitorPerformance extends DeleteMonitor{

	private static Log m_log = LogFactory.getLog( DeleteMonitorPerformance.class );

	/**
	 * リソース監視情報を削除します。
	 * @throws HinemosUnknown
	 * @throws NotifyNotFound
	 * @see com.clustercontrol.monitor.run.factory.DeleteMonitor#deleteCheckInfo()
	 */
	@Override
	protected boolean deleteCheckInfo() throws FinderException, RemoveException, NamingException, NotifyNotFound, HinemosUnknown {
		m_log.debug("deleteCheckInfo()");

		// リソース監視情報を取得
		MonitorPerfInfoLocal perfLocal = MonitorPerfInfoUtil.getLocalHome().findByPrimaryKey(m_monitorId);

		// リソース監視情報を削除
		perfLocal.remove();

		// ポーラを停止
		boolean result = true;
		ModifyPollingSchedule poller = new ModifyPollingSchedule();
		result = poller.deleteSchedule(
				m_monitor.getMonitorTypeId(),
				m_monitor.getMonitorId(),
				m_monitor.getFacilityId());

		return result;
	}
}
