/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.bean;

import javax.xml.bind.annotation.XmlType;

import com.clustercontrol.performance.bean.CollectorItemInfo;
import com.clustercontrol.repository.bean.FacilityTreeItem;

/**
 * 実績データグラフ表示用設定情報クラス
 * 
 * @version 4.0.0
 * @since 1.0.0
 * 
 */
@XmlType(namespace = "http://collector.ws.clustercontrol.com")
public class GraphProperty {

	// クラス変数
	private CollectorItemInfo targetItem; // グラフ表示対象項目
	private FacilityTreeItem targetFacility; // グラフ表示対象ファシリティ
	private Integer graphType = new Integer(0); // グラフ表示方法
	private Integer displayType = new Integer(0); // グラフ表示方法

	/**
	 * コンストラクター
	 * 
	 * @param targetFacility
	 *            描画対象ファシリティ
	 * @param targetItem
	 *            描画対象の収集項目
	 * @param graphType
	 *            グラフ種別
	 */
	public GraphProperty(
			FacilityTreeItem targetFacility,
			CollectorItemInfo targetItem,
			Integer graphType,
			Integer displayType) {

		this.targetFacility = targetFacility;
		this.targetItem = targetItem;
		this.graphType = graphType;
		this.displayType = displayType;
	}

	/**
	 * グラフ種別を取得します。
	 * 
	 * @return graphType グラフ種別
	 */
	public Integer getGraphType() {
		return graphType;
	}

	/**
	 * グラフ種別を設定します。
	 * 
	 * @param graphType
	 *            グラフ種別
	 */
	public void setGraphType(Integer graphType) {
		this.graphType = graphType;
	}

	/**
	 * 表示種別を取得します
	 * 
	 * @return displayType 表示種別
	 */
	public Integer getDisplayType() {
		return displayType;
	}

	/**
	 * 表示種別を設定します。
	 * 
	 * @param displayType 表示種別
	 */
	public void setDisplayType(Integer displayType) {
		this.displayType = displayType;
	}

	/**
	 * 描画対象ファシリティを取得します。
	 * 
	 * @return targetFacility 対象ファシリティ
	 */
	public FacilityTreeItem getTargetFacility() {
		return targetFacility;
	}

	/**
	 * 描画対象ファシリティを設定します。
	 * 
	 * @param targetFacility
	 *            対象ファシリティ
	 */
	public void setTargetFacility(FacilityTreeItem targetFacility) {
		this.targetFacility = targetFacility;
	}

	/**
	 * 描画対象収集項目を取得します。
	 * 
	 * @return targetItem 描画対象収集項目
	 */
	public CollectorItemInfo getTargetItem() {
		return targetItem;
	}

	/**
	 * 描画対象収集項目を設定します。
	 * 
	 * @param targetItem
	 *            描画対象収集項目
	 */
	public void setTargetItem(CollectorItemInfo targetItem) {
		this.targetItem = targetItem;
	}
}