/*

Copyright (C) 2008 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.notify.mail.factory;

import java.sql.Timestamp;
import java.util.Date;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.MailTemplateNotFound;
import com.clustercontrol.notify.mail.bean.MailTemplateInfo;
import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoLocal;
import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * メールテンプレート情報を変更するクラス<BR>
 *
 * @version 2.4.0
 * @since 2.4.0
 */
public class ModifyMailTemplate {

	/** ログ出力のインスタンス。 */
	private static Log m_log = LogFactory.getLog( ModifyMailTemplate.class );

	/**
	 * メールテンプレート情報を変更します。
	 * <p>
	 * <ol>
	 *  <li>メールテンプレートIDより、メールテンプレート情報を取得し、
	 *      メールテンプレート情報を変更します。</li>
	 * </ol>
	 * 
	 * @param info 変更対象のメールテンプレート情報
	 * @param name 変更したユーザ名
	 * @return 変更に成功した場合、<code> true </code>
	 * @throws MailTemplateNotFound
	 * @throws HinemosUnknown
	 * @throws InvalidSetting
	 * 
	 * @see com.clustercontrol.notify.ejb.entity.MailTemplateInfoBean
	 */
	public boolean modify(MailTemplateInfo data, String name) throws MailTemplateNotFound, HinemosUnknown {

		try {
			//メールテンプレート情報を取得
			MailTemplateInfoLocal mailTemplateInfo = MailTemplateInfoUtil
			.getLocalHome().findByPrimaryKey(data.getMailTemplateId());

			//メールテンプレート情報を更新
			if (mailTemplateInfo != null) {
				mailTemplateInfo.setDescription(data.getDescription());
				mailTemplateInfo.setSubject(data.getSubject());
				mailTemplateInfo.setBody(data.getBody());
				//	    		mailTemplateInfo.setRegDate(data.getRegDate());
				mailTemplateInfo.setUpdateDate(new Timestamp(new Date().getTime()));
				//	    		mailTemplateInfo.setRegUser(data.getRegUser());
				mailTemplateInfo.setUpdateUser(name);

			}
		} catch (FinderException e) {
			AplLogger apllog = new AplLogger("MAILTEMP", "mail_template");
			String[] args = { data.getMailTemplateId() };
			apllog.put("SYS", "002", args);
			m_log.warn("modify():" + e.getMessage());
			throw new MailTemplateNotFound(e.getMessage(), e);
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("MAILTEMP", "mail_template");
			String[] args = { data.getMailTemplateId() };
			apllog.put("SYS", "002", args);
			m_log.warn("modify():" + e.getMessage());
			throw new HinemosUnknown(e.getMessage(), e);
		}

		return true;
	}

}
