package com.clustercontrol.monitor.run.factory;

import java.util.ArrayList;
import java.util.Collection;

import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.NotifyNotFound;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.bean.MonitorTrapValueInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorTrapValueInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorTrapValueInfoUtil;

/**
 * SNMPTRAP監視の判定情報を変更する抽象クラス<BR>
 * <p>
 * SNMPTRAP監視を行う各監視管理クラスで継承してください。
 * 
 * @version 4.0.0
 * @since 2.1.0
 */
public abstract class ModifyMonitorTrapValueType extends ModifyMonitor {

	/** ログ出力のインスタンス。 */
	private static Log m_log = LogFactory
	.getLog(ModifyMonitorTrapValueType.class);

	@Override
	protected boolean modifyJudgementInfo() throws CreateException,
	RemoveException, NamingException, HinemosUnknown,
	NotifyNotFound {
		m_log.debug("modifyJudgementInfo() : start");

		// SNMPTRAP監視判定情報を削除
		Collection ct = m_monitor.getMonitorTrapValueInfo();
		if (ct != null && ct.size() > 0) {
			Object[] infoArray = ct.toArray();
			for (int j = 0; j < infoArray.length; j++) {
				MonitorTrapValueInfoLocal info = (MonitorTrapValueInfoLocal) infoArray[j];
				if (info != null) {
					// SNMPTRAP監視情報を削除
					info.remove();
				}
			}
		}

		ArrayList<MonitorTrapValueInfo> valueList = m_monitorInfo.getTrapValueInfo();
		ArrayList<MonitorTrapValueInfoLocal> valueLocalList = new ArrayList<MonitorTrapValueInfoLocal>();

		// SNMPTRAP監視判定情報を設定
		if(valueList == null){
			m_log.debug("addJudgementInfo() : MonitorId = " + m_monitorInfo.getMonitorId() + ", MonitorTrapValueInfo List is null");
			return true;
		}

		// SNMPTRAP監視判定情報を設定
		MonitorTrapValueInfo value = null;
		for(int index=0; index<valueList.size(); index++){
			value = valueList.get(index);

			if(value != null){
				MonitorTrapValueInfoLocal local = MonitorTrapValueInfoUtil.getLocalHome().create(
						m_monitorInfo.getMonitorId(),
						value.getMib(),
						value.getTrapOid(),
						value.getGenericId(),
						value.getSpecificId(),
						value.getUei(),
						ValidConstant.booleanToType(value.isValidFlg()),
						value.getPriority(),
						value.getLogmsg(),
						value.getDescr());
				valueLocalList.add(local);

				// for debug
				m_log.debug("addJudgementInfo() : MonitorId = " + m_monitorInfo.getMonitorId() +
						",Mib = " + value.getMib() +
						",TrapOid = " + value.getTrapOid() +
						",GenericId = " + value.getGenericId() +
						",SpecificId = " + value.getSpecificId() +
						",Uei = " + value.getUei() +
						",ValidFlg = " + value.isValidFlg() +
						",Priority = " + value.getPriority() +
						",Logmsg = " + value.getLogmsg() +
						",Descr = " + value.getDescr());
			}
		}

		m_log.debug("modifyJudgementInfo() : end");
		return true;
	}

}
