/*

Copyright (C) 2007 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.maintenance.factory;

import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.MaintenanceNotFound;
import com.clustercontrol.fault.NotifyNotFound;
import com.clustercontrol.commons.bean.Schedule;
import com.clustercontrol.maintenance.bean.MaintenanceInfo;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoLocal;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoUtil;
import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;

/**
 * 
 * メンテナンス情報検索クラスです。
 * 
 * @since	4.0.0
 * @version	2.2.0
 *
 */
public class SelectMaintenanceInfo {
	/** ログ出力のインスタンス。 */
	private static Log m_log = LogFactory.getLog( SelectMaintenanceInfo.class );

	public MaintenanceInfo getMaintenanceInfo(String maintenanceId) throws HinemosUnknown, NotifyNotFound, MaintenanceNotFound {

		MaintenanceInfo info = null;
		try{
			// メンテナンス情報を取得
			MaintenanceInfoLocal infoLocal = MaintenanceInfoUtil.getLocalHome().findByPrimaryKey(maintenanceId);

			info = new MaintenanceInfo();
			info.setMaintenanceId(infoLocal.getMaintenance_id());
			info.setDescription(infoLocal.getDescription());
			info.setTypeId(infoLocal.getType_id());
			info.setDataRetentionPeriod(infoLocal.getDataRetentionPeriod());
			info.setCalendarId(infoLocal.getCalendar_id());
			info.setSchedule(new Schedule(infoLocal.getSchedule_type(),
					infoLocal.getMonth(), infoLocal.getDay(), infoLocal.getWeek(),
					infoLocal.getHour(), infoLocal.getMinute()));

			info.setNotifyGroupId(infoLocal.getNotifyGroupId());
			info.setApplication(infoLocal.getApplication());
			info.setValidFlg(infoLocal.getValid_flg());
			info.setRegUser(infoLocal.getRegUser());
			if(infoLocal.getRegDate() == null){
				info.setRegDate(null);
			}
			else{
				info.setRegDate(infoLocal.getRegDate().getTime());
			}
			info.setUpdateUser(infoLocal.getUpdateUser());
			if(infoLocal.getUpdateDate() == null){
				info.setUpdateDate(null);
			}
			else{
				info.setUpdateDate(infoLocal.getUpdateDate().getTime());
			}

			//通知情報の取得
			NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();
			info.setNotifyId(nc.getNotifyRelation(info.getNotifyGroupId()));
		} catch(NamingException e){
			throw new HinemosUnknown(e.getMessage(), e);
		} catch (FinderException e) {
			throw new MaintenanceNotFound(e.getMessage(), e);
		} catch (CreateException e) {
			throw new HinemosUnknown(e.getMessage(), e);
		} catch (NotifyNotFound e) {
			throw e;
		}

		return info;
	}


	/**
	 * 
	 * @return
	 * @throws MaintenanceNotFound
	 * @throws HinemosUnknown
	 */
	public ArrayList<MaintenanceInfo> getMaintenanceList() throws MaintenanceNotFound, HinemosUnknown {
		m_log.debug("getMaintenanceList() : start");
		// メンテナンス情報一覧を取得
		ArrayList<MaintenanceInfo> list = new ArrayList<MaintenanceInfo>();
		try{
			Collection<MaintenanceInfoLocal> ct = MaintenanceInfoUtil.getLocalHome().findAllOrderByMaintenanceId();

			for(MaintenanceInfoLocal info : ct){
				list.add(getMaintenanceInfo(info.getMaintenance_id()));
				// for debug
				if(m_log.isDebugEnabled()){
					m_log.debug("getMaintenanceList() : " +
							"maintenanceId = " + info.getMaintenance_id() +
							", description = " + info.getDescription() +
							", type_id = " + info.getType_id() +
							", dataRetentionPeriod = " + info.getDataRetentionPeriod() +
							", calendar_id = " + info.getCalendar_id() +
							", schedule = " + info.getSchedule_type() +
							", month = " + info.getMonth() +
							", day = " + info.getDay() +
							", week = " + info.getWeek() +
							", hour = " + info.getHour() +
							", minute = " + info.getMinute() +
							", notifyGroupId = " + info.getNotifyGroupId() +
							", application = " + info.getApplication() +
							", valid_flg = " + info.getValid_flg() +
							", regUser = " + info.getRegUser() +
							", regDate = " + info.getRegDate() +
							", updateUser = " + info.getUpdateUser() +
							", updateDate = " + info.getUpdateDate());
				}
			}

		} catch (FinderException e) {
			m_log.warn(e.getMessage(), e);
			throw new MaintenanceNotFound(e.getMessage(), e);
		} catch (NamingException e) {
			m_log.warn(e.getMessage(), e);
			throw new HinemosUnknown(e.getMessage(), e);
		} catch (NotifyNotFound e) {
			m_log.warn(e.getMessage(), e);
			throw new HinemosUnknown(e.getMessage(), e);
		} catch (HinemosUnknown e) {
			m_log.warn(e.getMessage(), e);
			throw new HinemosUnknown(e.getMessage(), e);
		}

		return list;
	}
}
