/*

Copyright (C) 2007 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.maintenance.factory;

import java.sql.Timestamp;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.NotifyNotFound;
import com.clustercontrol.maintenance.bean.MaintenanceInfo;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoLocal;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoUtil;
import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;

/**
 * メンテナンス情報を変更するためのクラスです。
 * 
 * @version 4.0.0
 * @since 2.2.0
 *
 */
public class ModifyMaintenance {

	public boolean modifyMaintenance(MaintenanceInfo info, String name) throws FinderException, NamingException, CreateException, RemoveException, NotifyNotFound, HinemosUnknown {

		//メンテナンス情報を取得
		MaintenanceInfoLocal maintenanceInfo = MaintenanceInfoUtil
		.getLocalHome().findByPrimaryKey(info.getMaintenanceId());

		//メンテナンス情報を更新
		if (maintenanceInfo != null) {
			maintenanceInfo.setDescription(info.getDescription());
			maintenanceInfo.setType_id(info.getTypeId());
			maintenanceInfo.setDataRetentionPeriod(info.getDataRetentionPeriod());
			maintenanceInfo.setCalendar_id(info.getCalendarId());
			maintenanceInfo.setSchedule_type(info.getSchedule().getType());
			maintenanceInfo.setMonth(info.getSchedule().getMonth());
			maintenanceInfo.setDay(info.getSchedule().getDay());
			maintenanceInfo.setWeek(info.getSchedule().getWeek());
			maintenanceInfo.setHour(info.getSchedule().getHour());
			maintenanceInfo.setMinute(info.getSchedule().getMinute());
			maintenanceInfo.setNotifyGroupId(info.getNotifyGroupId());
			maintenanceInfo.setApplication(info.getApplication());
			maintenanceInfo.setValid_flg(info.getValidFlg());
			maintenanceInfo.setRegUser(info.getRegUser());
			maintenanceInfo.setRegDate(new Timestamp(info.getRegDate()));
			maintenanceInfo.setUpdateUser(name);
			maintenanceInfo.setUpdateDate(new Timestamp(new Date().getTime()));
		}


		NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();
		nc.modifyNotifyRelation(info.getNotifyId(), info.getNotifyGroupId());

		return true;
	}

}
