/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.logfile.factory;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import com.clustercontrol.logfile.util.ControlLogfileInfo;
import com.clustercontrol.logfile.util.SendTopic;
import com.clustercontrol.monitor.run.factory.DeleteMonitor;

/**
 * ログファイル監視情報をマネージャから削除するクラス<BR>
 *
 * @version 4.0.0
 * @since 4.0.0
 */
public class DeleteMonitorLogfile extends DeleteMonitor{

	/* (non-Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.DeleteMonitor#deleteCheckInfo()
	 */
	@Override
	protected boolean deleteCheckInfo() throws FinderException, RemoveException, NamingException {

		// ログファイル監視情報を削除
		ControlLogfileInfo logfile = new ControlLogfileInfo(m_monitorId, m_monitorTypeId);

		// Topic送信
		SendTopic sendTopic = new SendTopic();
		/*
		 * TODO
		 * 性能向上のため、facilityIdにはlocal.getExecNodeList(monitorInfo.getFacilityId)を入れると良い。
		 * monitorInfoは変更前、変更後の2つを利用する。
		 * facilityId=nullでは、全エージェントからアクセスが来てしまう。
		 */
		String facilityId = null;
		sendTopic.put(facilityId);

		return logfile.delete();
	}
}
