/*

Copyright (C) 2009 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.commons.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * hinemos.propertiesファイルに設定されているプロパティ値を
 * 取得するためのユーティリティクラス
 */
public class HinemosProperties {
	/** ログ出力のインスタンス。 */
	private static Log m_log = LogFactory.getLog( HinemosProperties.class );

	// VM管理オプション適用環境か判定するためのファイル
	private final static String VmEJB_jar_FILE_NAME;

	// Webサービスが利用可能か環境か判定するためのファイル
	private final static String HinemosWS_war_FILE_NAME;

	private static final Properties properties = new Properties();

	private HinemosProperties(){
	}

	public final static boolean _isHaOption;
	public final static boolean _isVmOption;
	public final static boolean _isWebService;

	static {
		FileInputStream inputStream = null;
		try {
			String etcdir = System.getProperty("hinemos.manager.etc.dir");
			String propertyFile = etcdir + File.separator + "hinemos.properties";

			inputStream = new FileInputStream(propertyFile);

			// プロパティファイルからキーと値のリストを読み込みます
			properties.load(inputStream);
		} catch (FileNotFoundException e) {
			m_log.error(e.getMessage(), e);
		} catch (IOException e) {
			m_log.error(e.getMessage(), e);
		} finally {
			if(inputStream != null){
				try {
					inputStream.close();
				} catch (IOException e) {
					m_log.error(e.getMessage(), e);
				}
			}
		}

		// HAオプションの適用有無をチェック
		if (isHaOption()) {
			m_log.info("HA Option is enable.");
			_isHaOption = true;
			VmEJB_jar_FILE_NAME = System.getProperty("jboss.server.home.dir") + "/deploy-hasingleton/VmEJB.jar";
			HinemosWS_war_FILE_NAME = System.getProperty("jboss.server.home.dir") + "/deploy-hasingleton/HinemosWS.war";

		} else {
			m_log.info("HA Option is disable.");
			_isHaOption = false;
			VmEJB_jar_FILE_NAME = System.getProperty("jboss.server.home.dir") + "/deploy/VmEJB.jar";
			HinemosWS_war_FILE_NAME = System.getProperty("jboss.server.home.dir") + "/deploy/HinemosWS.war";
		}

		// VM管理オプションの適用有無をチェック
		File jarFile = new File(VmEJB_jar_FILE_NAME);
		m_log.debug("VmEJB.jar : " + VmEJB_jar_FILE_NAME);
		if(jarFile.exists()){
			m_log.info("VM Option is enable.");
			_isVmOption = true;
		} else {
			m_log.info("VM Option is disable.");
			_isVmOption = false;
		}

		// Webサービスの適用有無をチェック
		jarFile = new File(HinemosWS_war_FILE_NAME);
		m_log.debug("HinemosWS.war : " + HinemosWS_war_FILE_NAME);

		// ファイルが存在する場合
		if(jarFile.exists()){
			m_log.info("Web Service is enable.");
			_isWebService = true;
		} else {
			m_log.info("Web Service is disable.");
			_isWebService = false;
		}
	}

	/**
	 * 指定されたキーを持つプロパティを、プロパティリストから探します。
	 * そのキーがプロパティリストにないと、デフォルトのプロパティリスト、
	 * さらにそのデフォルト値が繰り返し調べられます。
	 * そのプロパティが見つからない場合は、null が返されます。
	 * @param key プロパティキー
	 * @return 指定されたキー値を持つこのプロパティリストの値
	 */
	public static String getProperty(String key){
		m_log.debug(key + " = " + properties.getProperty(key));
		return properties.getProperty(key);
	}

	/**
	 * 指定されたキーを持つプロパティを、プロパティリストから探します。
	 * そのキーがプロパティリストにないと、デフォルトのプロパティリスト、
	 * さらにそのデフォルト値が繰り返し調べられます。
	 * そのプロパティが見つからない場合は、デフォルト値の引数が返されます。
	 * @param key プロパティキー
	 * @param defaultValue デフォルト値
	 * @return 指定されたキー値を持つこのプロパティリストの値
	 */
	public static String getProperty(String key, String defaultValue){
		m_log.debug(key + " = " + properties.getProperty(key) + ", defaultValue = " + defaultValue);
		return properties.getProperty(key, defaultValue);
	}

	public static boolean isHaOption() {
		String jgroupsPartitionName = System.getProperty("jboss.partition.name");
		if (jgroupsPartitionName == null || "".equals(jgroupsPartitionName)) {
			return false;
		} else {
			return true;
		}
	}
}