/*

Copyright (C) 2011 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.commons.scheduler;

import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TriggerSchedulerFactory {
	private static Log m_log = LogFactory.getLog(TriggerSchedulerFactory.class);

	public static TriggerScheduler getScheduler(String instanceName) throws TriggerSchedulerException{
		m_log.debug("create Scheduler Instance. instanceName = " + instanceName);
		try {
			return new QuartzScheduler(instanceName);
		} catch (NamingException e) {
			m_log.warn("getScheduler() instanceName = " + instanceName + " : " + e.getClass().getSimpleName() + ", " + e.getMessage());
			throw new TriggerSchedulerException(e.getMessage(), e);
		}
	}
}