/*

Copyright (C) 2011 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.commons.scheduler;

import java.util.Map;

import javax.ejb.EJBLocalHome;

public interface TriggerScheduler {
	static final String TRIGGER_TYPE_SIMPLE = "simple";
	static final String TRIGGER_TYPE_CRON = "cron";
	static final String TRIGGER_TYPE_NONE = "none";

	void scheduleEjbLocalInvokerJobWithCronTrigger(
			String jobName,
			String jobGroupName,
			EJBLocalHome ejbLocalHome,
			String methodName,
			Object[] jdArgs,
			Class<Object>[] jdArgsType,
			Map<String, Object> jobDataMap,
			boolean resetOnRestartFlag,
			boolean validFlag,
			String cronExpression)
	throws TriggerSchedulerException;

	void scheduleEjbLocalInvokerJobWithSimpleTrigger(
			String jobName,
			String jobGroupName,
			EJBLocalHome ejbLocalHome,
			String methodName,
			Object[] jdArgs,
			Class<Object>[] jdArgsType,
			Map<String, Object> jobDataMap,
			boolean resetOnRestartFlag,
			boolean validFlag,
			long startTime,
			int intervalSecond)
	throws TriggerSchedulerException;

	void modifyEjbInvokerJobWithCronTrigger(String jobName, String jobGroupName, String cronExpression, boolean validFlag) throws TriggerSchedulerException;

	void modifyEjbInvokerJobWithSimpleTrigger(String jobName, String jobGroupName, int intervalSecond, boolean validFlag) throws TriggerSchedulerException;

	void pauseJob(String jobName ,String jobGroupName) throws TriggerSchedulerException;

	void deleteJob(String jobName ,String jobGroupName) throws TriggerSchedulerException;
}
