/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.commons.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlType;

/**
 * CommonTableTreeViewerクラス用にツリー構造化するためのクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
@XmlType(namespace = "http://common.ws.clustercontrol.com")
public class CommonTableTreeItem implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = -8296030294371572681L;

	/** 親 */
	private CommonTableTreeItem parent = null;

	/** 情報オブジェクト */
	private ArrayList<Object> data = null;

	/** 子の格納リスト */
	private List<CommonTableTreeItem> children = null;

	/**
	 * 引数なしコンストラクタ
	 */
	public CommonTableTreeItem(){
		super();
	}

	/**
	 * 引数の情報を保持したインスタンスを取得します。<BR>
	 * 
	 * @param parent
	 *            親のオブジェクト
	 * @param data
	 *            スコープ情報オブジェクト
	 */
	public CommonTableTreeItem(CommonTableTreeItem parent, ArrayList<Object> data) {

		this.setParent(parent);
		this.setData(data);

		if (parent != null) {
			parent.addChildren(this);
		}

		this.children = new ArrayList<CommonTableTreeItem>();
	}

	/**
	 * 親のオブジェクトを取得します。<BR>
	 * 
	 * @return 親
	 */
	public CommonTableTreeItem getParent() {
		return this.parent;
	}

	/**
	 * 親のオブジェクトを設定します。<BR>
	 * <p>
	 * 
	 * インスタンス化の際に親へ関係付けているため、子を削除するメソッドを実装した 後に可視性(スコープ)を拡大して下さい。 <br>
	 * また、新しい親への関係付けも行うように実装して下さい。
	 * 
	 * @return 親
	 */
	public void setParent(CommonTableTreeItem parent) {
		// DTOがループすると、webサービスが動作しないので、parentはsetしない。
		// クライアントでsetする。
		// this.parent = parent;
	}

	/**
	 * 情報を取得します。<BR>
	 * 
	 * @return 情報
	 */
	public ArrayList<Object> getData() {
		return this.data;
	}

	/**
	 * 情報を設定します。<BR>
	 * 
	 * @param data 情報
	 */
	public void setData(ArrayList<Object> data) {
		this.data = data;
	}

	/**
	 * 子のオブジェクトを追加します。<BR>
	 * <p>
	 * 
	 * childenの親はこのオブジェクトとして設定されます。
	 * 
	 * @param child   子
	 */
	public void addChildren(CommonTableTreeItem child) {
		child.setParent(this);
		children.add(child);
	}

	/**
	 * 子のオブジェクト数を取得します。<BR>
	 * 
	 * @return 子オブジェクトの数
	 */
	public int size() {
		return children.size();
	}

	// Webサービス(jaxb)のためgetter、setterを用意しておく
	@Deprecated
	public List<CommonTableTreeItem> getChildren() {
		return children;
	}

	@Deprecated
	public void setChildren(List<CommonTableTreeItem> children) {
		this.children = children;
	}
}