/*

Copyright (C) since 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.accesscontrol.ejb.entity;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

/**
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="UserRole"
 *    jndi-name="UserRole"
 *    type="CMP"
 *    view-type="local"
 *    schema="UserRoleSCHEMA"
 *    cmp-version="2.x"
 * 
 * @ejb.persistence
 *    table-name="public.cc_cfg_user_role"
 * 
 * @ejb.finder
 *    query="SELECT OBJECT(a) FROM UserRoleSCHEMA as a"
 *    signature="java.util.Collection findAll()"
 * 
 * @ejb.pk class="com.clustercontrol.accesscontrol.ejb.entity.UserRoleBeanPK"
 * 
 * @ejb.permission
 *    unchecked="true"
 * 
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=DefaultDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.read-ahead
 *    strategy="on-load"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @jboss.persistence
 *    datasource="java:/DefaultDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_cfg_user_role"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 * <!-- end-xdoclet-definition -->
 * @generated
 **/

public abstract class UserRoleBean implements javax.ejb.EntityBean {

	/**
	 * Generated Primary Key Class
	 * @generated
	 */
	public class PrimaryKey {
		/**
		 * @generated
		 */
		public java.lang.String userId;
		/**
		 * @generated
		 */
		public java.lang.String userRole;
	}

	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.create-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public UserRoleBeanPK ejbCreate(java.lang.String userId, java.lang.String userRole) throws javax.ejb.CreateException {
		// EJB 2.0 spec says return null for CMP ejbCreate methods.
		// TODO: YOU MUST INITIALIZE THE FIELDS FOR THE BEAN HERE.
		// setMyField("Something");
		// begin-user-code
		setUserId(userId);
		setUserRole(userRole);
		return null;
		// end-user-code
	}

	/**
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws javax.ejb.CreateException {
		// begin-user-code
		// end-user-code
	}

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field userId
	 *
	 * Returns the userId
	 * @return the userId
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="user_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(32)"
	 *     read-only="false"
	 * @ejb.pk-field
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getUserId();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the userId
	 * 
	 * @param java.lang.String the new userId value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setUserId(java.lang.String userId);

	/**
	 *
	 *
	 * <!-- begin-user-doc -->
	 * CMP Field userRole
	 *
	 * Returns the userRole
	 * @return the userRole
	 * 
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 *
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="user_role"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="varchar(64)"
	 *     read-only="false"
	 * @ejb.pk-field
	 *
	 * @ejb.interface-method
	 * 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract java.lang.String getUserRole();

	/**
	 * <!-- begin-user-doc -->
	 * Sets the userRole
	 * 
	 * @param java.lang.String the new userRole value
	 * <!-- end-user-doc -->
	 * 
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.interface-method
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public abstract void setUserRole(java.lang.String userRole);

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbActivate()
	 */
	@Override
	public void ejbActivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbLoad()
	 */
	@Override
	public void ejbLoad() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbPassivate()
	 */
	@Override
	public void ejbPassivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbRemove()
	 */
	@Override
	public void ejbRemove() throws RemoveException, EJBException,
	RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbStore()
	 */
	@Override
	public void ejbStore() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	@Override
	public void setEntityContext(EntityContext ctx) throws EJBException,
	RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	@Override
	public void unsetEntityContext() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/**
	 * 
	 */
	public UserRoleBean() {
		// TODO Auto-generated constructor stub
	}

	//==========================================
	// CMR fields
	//==========================================

	/**
	 * この権限が属するユーザエンティティを返します。<BR>
	 * 
	 * @return ユーザエンティティ
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 * 
	 * @ejb.relation
	 *   name="user-may-contain-userrole"
	 *   role-name="UserRoleToUser"
	 *   cascade-delete="true"
	 * 
	 * @jboss.relation
	 *   related-pk-field="userId"
	 *   fk-column="user_id"
	 *   batch-cascade-delete="true"
	 */
	public abstract UserLocal getUser();

	/**
	 * ユーザエンティティを格納します。<BR>
	 * 
	 * @param user ユーザエンティティ
	 * 
	 * @ejb.interface-method
	 *    view-type="local"
	 */
	public abstract void setUser(UserLocal user);
}
