/*
 * Generated by XDoclet - Do not edit!
 */
package com.clustercontrol.repository.ejb.session;

/**
 * Local interface for RepositoryController.
 * @generated 
 * @xdoclet-generated at ${TODAY}
 * @copyright The XDoclet Team
 * @author XDoclet
 * @version 4.0.3
 */
public interface RepositoryControllerLocal
   extends javax.ejb.EJBLocalObject
{
   /**
    * ファシリティツリー（スコープツリー）取得を取得します。 <BR> 取得したファシリティツリーには割り当てられたノードを含みます。<BR> このメソッドはクライアントの画面情報を作成するために 呼び出されます。クライアントのロケールを引数をして必要とします。<BR> （最上位のスコープという表記をscopeをいう表記を切り替えるため。）
    * @since 1.0.0
    * @param locale クライアントのロケール
    * @return FacilityTreeItemの階層オブジェクト    */
   public com.clustercontrol.repository.bean.FacilityTreeItem getFacilityTree( java.util.Locale locale ) ;

   /**
    * ファシリティツリー（スコープツリー）取得を取得します。(有効なノードのみ) <BR> 取得したファシリティツリーには割り当てられたノードを含みます。<BR> このメソッドはクライアントの画面情報を作成するために 呼び出されます。クライアントのロケールを引数をして必要とします。<BR> （最上位のスコープという表記をscopeをいう表記を切り替えるため。）
    * @since 1.0.0
    * @param locale クライアントのロケール
    * @return FacilityTreeItemの階層オブジェクト    */
   public com.clustercontrol.repository.bean.FacilityTreeItem getExecTargetFacilityTree( java.util.Locale locale ) ;

   /**
    * ファシリティツリー（スコープツリー）取得を取得します。(有効なノードのみ) <BR> 取得したファシリティツリーには割り当てられたノードを含みます。<BR> このメソッドはクライアントの画面情報を作成するために 呼び出されます。クライアントのロケールを引数をして必要とします。<BR> （最上位のスコープという表記をscopeをいう表記を切り替えるため。）
    * @since 4.0.0
    * @param facilityId ファシリティID
    * @param locale クライアントのロケール
    * @return FacilityTreeItemの階層オブジェクト    */
   public com.clustercontrol.repository.bean.FacilityTreeItem getExecTargetFacilityTree( java.lang.String facilityId,java.util.Locale locale ) ;

   /**
    * ノード一覧を取得します。<BR> リポジトリに登録されているすべてのノードを取得します。<BR> 戻り値はNodeInfoのArrayListで、NodeInfoには ノードの下記情報のみ格納されています。 ・ファシリティID ・ファシリティ名 ・IPアドレスバージョン、IPv4, Ipv6 ・説明 getNodeFacilityIdListを利用すること。（getNodeと組み合わせて利用する。）
    * @since 1.0.0
    * @return NodeInfoの配列    */
   public java.util.ArrayList getNodeList(  ) ;

   /**
    * 詳細版ノード一覧を取得します。<BR>
    * @since 4.0.0
    * @return NodeInfoの配列
    * @throws HinemosUnknown    */
   public java.util.List getNodeDetailList(  ) throws com.clustercontrol.fault.HinemosUnknown;

   /**
    * ノード一覧を取得します。<BR> クライアントなどで検索した場合に呼ばれ、該当するノード一覧を取得します。<BR> 引数はNodeInfoであり、"ファシリティID"、"ファシリティ名"、"説明"、 "IPアドレス"、"OS名"、"OSリリース"、"管理者"、"連絡先"が１つ以上含まれており、 その条件を元に該当するノードを戻り値とします。<BR> 戻り値はNodeInfoのArrayListで、NodeInfoには ノードの"ファシリティID"、"ファシリティ名"、"説明"のみ格納されています。<BR>
    * @since 1.0.0
    * @param property　検索条件のプロパティ
    * @return NodeInfoの配列    */
   public java.util.ArrayList getFilterNodeList( com.clustercontrol.repository.bean.NodeInfo property ) ;

   /**
    * 監視・ジョブ等の処理を実行する対象となる、ファシリティIDのリストを取得します。 引数で指定されたファシリティIDが、ノードかスコープによって、以下のようなリストを取得します。 ノードの場合 引数で指定されたfacilityIdが格納されたArrayList ただし、管理対象（有効/無効フラグが真）の場合のみ スコープの場合 配下に含まれるノードのファシリティIDが格納されたArrayList ただし、管理対象（有効/無効フラグが真）のみ
    * @since 3.0.0
    * @param facilityId 処理を実行する対象となるファシリティID
    * @return 有効なノードのリスト（有効なノードがひとつも含まれない場合は空のリスト）    */
   public java.util.ArrayList getExecTargetFacilityIdList( java.lang.String facilityId ) ;

   /**
    * ノードのファシリティIDリストを取得します。<BR> リポジトリにあるすべてのノードのリストを取得します。<BR> 戻り値は ファシリティID(String)のArrayList<BR> getNodeList() との違いはこちらの戻り値はArrayListの２次元ではなく、 単純にファシリティID（String）のみのArrayList
    * @since 1.0.0
    * @return ファシリティIDの配列    */
   public java.util.ArrayList getNodeFacilityIdList(  ) ;

   /**
    * ノードのファシリティIDリストを取得します。<BR> リポジトリにあるすべてのノードのリストを取得します。<BR> 戻り値は ファシリティID(String)のArrayList 引数のsortにtrueをセットした場合には、listがCollator.compare()にしたがってソートされる。<BR> getNodeList() との違いはこちらの戻り値はNodeInfoのArrayListではなく、 単純にファシリティID（String）のみのArrayList
    * @since 2.1.0
    * @param sort sort ソートするか？(する:true しない:false)
    * @return ファシリティIDの配列    */
   public java.util.ArrayList getNodeFacilityIdList( boolean sort ) ;

   /**
    * ノードの詳細プロパティを取得します。<BR> faciliyIDで指定されるノードの詳細プロパティを取得します。<BR>
    * @since 1.0.0
    * @param facilityId ファシリティID
    * @param locale クライアントのロケール
    * @return ノード情報プロパティ
    * @throws FacilityNotFound    */
   public com.clustercontrol.repository.bean.NodeInfo getNode( java.lang.String facilityId ) throws com.clustercontrol.fault.FacilityNotFound;

   /**
    * ファシリティパスを取得します。<BR> 第一引数がノードの場合は、パスではなく、ファシリティ名。<BR> 第一引数がスコープの場合は、第二引数との相対的なファシリティパスを取得します。<BR> (例　○○スコープ>××システム>DBサーバ)<BR>
    * @since 1.0.0
    * @param facilityId ファシリティID
    * @param parentFacilityId 上位のファシリティID
    * @return String ファシリティパス    */
   public java.lang.String getFacilityPath( java.lang.String facilityId,java.lang.String parentFacilityId ) ;

   /**
    * SNMPを利用してノードの情報を取得します。<BR> クライアントからSNMPで検出を行った際に呼び出されるメソッドです。<BR> SNMPポーリングにより、ノード詳細プロパティをセットし、クライアントに返す。 戻り値はNodeInfo
    * @since 2.1.2
    * @param ポーリング対象のIPアドレス、コミュニティ名、バージョン、ポート
    * @param locale クライアントのロケール
    * @return ノード情報
    * @throws HinemosUnknown    */
   public com.clustercontrol.repository.bean.NodeInfo getNodePropertyBySNMP( java.lang.String ipAddress,int port,java.lang.String community,java.lang.String version ) throws com.clustercontrol.fault.HinemosUnknown;

   /**
    * 条件のHashMapに該当するノードのファシリティIDのリストを返却する。<BR> このメソッドは性能が低いため、要注意。
    * @since 3.1.0
    * @return ArrayList<String>    */
   public java.util.ArrayList findByCondition( java.util.HashMap condition ) ;

   /**
    * IPアドレスから該当するノードのファシリティID一覧を取得する。
    * @since 4.0.0
    * @param ipaddr IPアドレス(Inet4Address or Inet6Address)
    * @return ファシリティIDのリスト
    * @throws HinemosUnknown 予期せぬ内部エラーが発生した場合    */
   public java.util.List getFacilityIdByIpAddress( java.net.InetAddress ipaddr ) throws com.clustercontrol.fault.HinemosUnknown;

   /**
    * ファシリティIDリストを取得します。<BR> 引数のホスト名（ノード名）またはIPアドレスに対応するノードのファシリティIDのリストを 取得します。<BR> 戻り値はファシリティID(String)のArrayList getNodeList(NodeInfo)を利用すること。
    * @since 1.0.0
    * @param hostName ホスト名（ノード名）
    * @param ipAddress　IPアドレス(v4)
    * @return ファシリティIDの配列    */
   public java.util.ArrayList getFacilityIdList( java.lang.String hostName,java.lang.String ipAddress ) ;

   /**
    * ノードを新規に追加します。<BR> またこのメソッドで組み込みスコープである"登録済みノード"スコープにも 割り当てが行われます。
    * @since 1.0.0
    * @param nodeinfo 追加するノード情報のプロパティ
    * @throws FacilityDuplicate    */
   public void addNode( com.clustercontrol.repository.bean.NodeInfo nodeInfo ) throws com.clustercontrol.fault.FacilityDuplicate, com.clustercontrol.fault.InvalidSetting;

   /**
    * ノードを新規に追加します。（リポジトリ更新TOPIC未送信選択可能）<BR> またこのメソッドで組み込みスコープである"登録済みノード"スコープにも 割り当てが行われます。
    * @since 1.0.0
    * @param info 追加するノード情報のプロパティ
    * @throws FacilityDuplicate    */
   public void addNode( com.clustercontrol.repository.bean.NodeInfo info,boolean topicSendFlg ) throws com.clustercontrol.fault.FacilityDuplicate, com.clustercontrol.fault.InvalidSetting;

   /**
    * ノードを変更します。<BR> 引数のpropertyには変更する属性のみを設定してください。<BR>
    * @since 1.0.0
    * @param info　変更するノード情報のプロパティ    */
   public void modifyNode( com.clustercontrol.repository.bean.NodeInfo info ) throws com.clustercontrol.fault.InvalidSetting, com.clustercontrol.fault.HinemosUnknown;

   /**
    * ノード詳細情報を一括変更します。<BR> クライアントにあるスコープを指定して変更を行うためのメソッド 引数のpropertyには変更する属性のみを設定してください。<BR>
    * @since 1.0.0
    * @param info　変更するノード情報のプロパティ
    * @param parentFacilityId　スコープのファシリティID    */
   public void modifyNode( com.clustercontrol.repository.bean.NodeInfo info,java.lang.String parentFacilityId ) throws com.clustercontrol.fault.InvalidSetting, com.clustercontrol.fault.HinemosUnknown;

   /**
    * ノード情報を削除します。<BR> faciityIDで指定されたノードをリポジトリから削除します。
    * @since 1.0.0
    * @param facilityId ファシリティID
    * @throws UsedFacility
    * @throws HinemosUnknown    */
   public void deleteNode( java.lang.String facilityId ) throws com.clustercontrol.fault.UsedFacility, com.clustercontrol.fault.HinemosUnknown;

   /**
    * ファシリティID一覧を取得します。<BR> あるスコープを指定してその直下にあるスコープとノードを取得します。<BR> このメソッドは引数としてそのスコープのファシリティIDを要求します。<BR> 戻り値はArrayListで中のFacilityInfoには子の "ファシリティID"、"ファシリティ名"、"説明"のみ格納されています。<BR>
    * @since 1.0.0
    * @param parentFacilityId ファシリティID
    * @return ScopeInfoの配列    */
   public java.util.ArrayList getFacilityList( java.lang.String parentFacilityId ) ;

   /**
    * スコープ用プロパティ情報を取得します。<BR>
    * @since 1.0.0
    * @param facilityId ファシリティID
    * @param locale クライアントのロケール
    * @return スコープのプロパティ情報（ファシリティID、ファシリティ名、説明）
    * @throws FacilityNotFound
    * @throws HinemosUnknown    */
   public com.clustercontrol.repository.bean.ScopeInfo getScope( java.lang.String facilityId ) throws com.clustercontrol.fault.FacilityNotFound, com.clustercontrol.fault.HinemosUnknown;

   /**
    * スコープを新規に追加します。<BR> parentFacilityIdで指定されるスコープの下にpropertyで指定されるスコープを 追加します。<BR> 引数propertyには、"ファシリティID"、"ファシリティ名"、"説明"（任意）を含める必要があります。
    * @since 1.0.0
    * @param parentFacilityId
    * @param property
    * @throws FacilityDuplicate    */
   public void addScope( java.lang.String parentFacilityId,com.clustercontrol.repository.bean.ScopeInfo property ) throws com.clustercontrol.fault.FacilityDuplicate, com.clustercontrol.fault.InvalidSetting, com.clustercontrol.fault.HinemosUnknown;

   /**
    * スコープを新規に追加します(表示順指定)。<BR> parentFacilityIdで指定されるスコープの下にpropertyで指定されるスコープを 追加します。<BR> 引数propertyには、"ファシリティID"、"ファシリティ名"、"説明"（任意）を含める必要があります。
    * @since 1.0.0
    * @param parentFacilityId
    * @param property
    * @param sortOrder
    * @throws FacilityDuplicate    */
   public void addScope( java.lang.String parentFacilityId,com.clustercontrol.repository.bean.ScopeInfo property,int displaySortOrder ) throws com.clustercontrol.fault.FacilityDuplicate, com.clustercontrol.fault.InvalidSetting, com.clustercontrol.fault.HinemosUnknown;

   /**
    * スコープを新規に追加します(表示順指定、リポジトリ更新TOPIC未送信選択可能)。<BR> parentFacilityIdで指定されるスコープの下にpropertyで指定されるスコープを 追加します。<BR> 引数propertyには、"ファシリティID"、"ファシリティ名"、"説明"（任意）を含める必要があります。
    * @since 1.0.0
    * @param parentFacilityId
    * @param info
    * @param sortOrder
    * @throws FacilityDuplicate    */
   public void addScope( java.lang.String parentFacilityId,com.clustercontrol.repository.bean.ScopeInfo info,int displaySortOrder,boolean topicSendFlg ) throws com.clustercontrol.fault.FacilityDuplicate, com.clustercontrol.fault.InvalidSetting, com.clustercontrol.fault.HinemosUnknown;

   /**
    * スコープの情報を変更します。<BR> 引数propertyで指定した内容でスコープ情報を更新します。<BR> 引数propertyには、"ファシリティID"、"ファシリティ名"、"説明"（任意）を含める必要があります。 propertyに含まれるファシリティIDに対応するスコープの情報が変更されます。<BR>
    * @since 1.0.0
    * @param info    */
   public void modifyScope( com.clustercontrol.repository.bean.ScopeInfo info ) throws com.clustercontrol.fault.InvalidSetting, com.clustercontrol.fault.HinemosUnknown;

   /**
    * スコープ情報を削除します。<BR> faciityIDで指定されたスコープをリポジトリから削除します。
    * @since 1.0.0
    * @param facilityId ファシリティID
    * @throws UsedFacility
    * @throws HinemosUnknown    */
   public void deleteScope( java.lang.String facilityId ) throws com.clustercontrol.fault.UsedFacility, com.clustercontrol.fault.HinemosUnknown;

   /**
    * 割当ノード一覧を取得します。<BR> あるファシリティIDの配下または直下のノード一覧を取得します。<BR> このメソッドでは、引数levelで直下または配下を制御します。<BR> 戻り値はNodeInfoのArrayListで、NodeInfoには ノードの"ファシリティID"、"ファシリティ名"、"説明"のみ格納されています。<BR>
    * @since 1.0.0
    * @param parentFacilityId
    * @param level　取得レベル 0:ALL(配下) 1:ONE_LEVEL（直下）
    * @return NodeInfoの配列    */
   public java.util.ArrayList getNodeList( java.lang.String parentFacilityId,int level ) ;

   /**
    * 割当スコープ一覧を取得します。<BR> 割り当てスコープ一覧とは、あるノードが属しているスコープすべてを 一覧表示したものです。 クライアントの割り当てスコープビューの表示データとなります。 戻り値はArrayListのArrayListで中のArrayListには"スコープ"が最上位からの スコープパス表記で（Stringで）格納されています。 外のArrayListには、そのレコードが順に格納されています。
    * @since 1.0.0
    * @param facilityId ノードのファシリティID
    * @return Stringの配列    */
   public java.util.ArrayList getNodeScopeList( java.lang.String facilityId ) ;

   /**
    * ファシリティIDリストを取得します。<BR> 引数に指定した親ファシリティIDの配下または直下のファシリティ（スコープ、ノード）の リストを取得します。<BR> 戻り値は ファシリティID（String）のArrayList
    * @since 1.0.0
    * @param parentFacilityId ファシリティID
    * @param level　取得レベル 0:ALL(配下) 1:ONE_LEVEL（直下）
    * @return ファシリティIDの配列    */
   public java.util.ArrayList getFacilityIdList( java.lang.String parentFacilityId,int level ) ;

   /**
    * ファシリティIDリストを取得します。<BR> 引数に指定した親ファシリティIDの配下または直下のファシリティ（スコープ、ノード）の リストを取得します。<BR> 戻り値は ファシリティID（String）のArrayList 引数のsortにtrueをセットした場合には、listがCollator.compare()にしたがってソートされる。
    * @since 2.1.0
    * @param parentFacilityId ファシリティID
    * @param level 取得レベル 0:ALL(配下) 1:ONE_LEVEL（直下）
    * @param sort ソートするか？(する:true しない:false)
    * @return ファシリティIDの配列    */
   public java.util.ArrayList getFacilityIdList( java.lang.String parentFacilityId,int level,boolean sort ) ;

   /**
    * ノードのファシリティIDリストを取得します。<BR> 引数に指定した親ファシリティIDの配下または直下のファシリティ（ノード）の リストを取得します。<BR> 戻り値は ファシリティID（String）のArrayList
    * @since 1.0.0
    * @param parentFacilityId ファシリティID
    * @param level 取得レベル 0:ALL(配下) 1:ONE_LEVEL（直下）
    * @return ファシリティIDの配列    */
   public java.util.ArrayList getNodeFacilityIdList( java.lang.String parentFacilityId,int level ) ;

   /**
    * ノードのファシリティIDリスト取得<BR> 引数に指定した親ファシリティIDの配下または直下のファシリティ（ノード）の リストを取得します。<BR> 戻り値は ファシリティID（String）のArrayList 引数のsortにtrueをセットした場合には、listがCollator.compare()にしたがってソートされる。
    * @since 2.1.0
    * @param parentFacilityId
    * @param level 取得レベル 0:ALL(配下) 1:ONE_LEVEL（直下）
    * @param sort sort ソートするか？(する:true しない:false)
    * @return ファシリティIDの配列    */
   public java.util.ArrayList getNodeFacilityIdList( java.lang.String parentFacilityId,int level,boolean sort,java.lang.Boolean valid ) ;

   /**
    * スコープへのノードの割り当てを行います。（リポジトリ更新TOPIC未送信選択可能）<BR> parentFacilityIdで指定されるスコープにfacilityIdsで指定されるノード群を 割り当てます。
    * @since 1.0.0
    * @param parentFacilityId　ノードを割り当てるスコープ
    * @param facilityIds 割り当てさせるノード(群)    */
   public void assignNodeScope( java.lang.String parentFacilityId,java.lang.String[] facilityIds,boolean topicSendFlg ) throws com.clustercontrol.fault.InvalidSetting, com.clustercontrol.fault.HinemosUnknown;

   /**
    * スコープへのノードの割り当てを行います。<BR> parentFacilityIdで指定されるスコープにfacilityIdsで指定されるノード群を 割り当てます。
    * @since 1.0.0
    * @param parentFacilityId　ノードを割り当てるスコープ
    * @param facilityIds 割り当てさせるノード(群)    */
   public void assignNodeScope( java.lang.String parentFacilityId,java.lang.String[] facilityIds ) throws com.clustercontrol.fault.InvalidSetting, com.clustercontrol.fault.HinemosUnknown;

   /**
    * ノードをスコープから削除します。（割り当てを解除します。）<BR> parentFacilityIdで指定されるスコープからfacilityIdsで指定されるノード群を 削除（割り当て解除）します。
    * @since 1.0.0
    * @param parentFacilityId ノードを取り除くスコープ
    * @param facilityIds 取り除かれるノード（群）    */
   public void releaseNodeScope( java.lang.String parentFacilityId,java.lang.String[] facilityIds ) throws com.clustercontrol.fault.InvalidSetting, com.clustercontrol.fault.HinemosUnknown;

   /**
    * ノードをスコープから削除します。（割り当てを解除します。リポジトリ更新TOPIC未送信選択可能）<BR> parentFacilityIdで指定されるスコープからfacilityIdsで指定されるノード群を 削除（割り当て解除）します。
    * @since 1.0.0
    * @param parentFacilityId ノードを取り除くスコープ
    * @param facilityIds 取り除かれるノード（群）    */
   public void releaseNodeScope( java.lang.String parentFacilityId,java.lang.String[] facilityIds,boolean topicSendFlg ) throws com.clustercontrol.fault.InvalidSetting, com.clustercontrol.fault.HinemosUnknown;

   /**
    * ファシリティがノードかどうかをチェックします。<BR> ファシリティIDに対応するものがノードかチェックし、結果をbooleanで返します。
    * @since 1.0.0
    * @param facilityId　ファシリティID
    * @return true：ノード　false:ノードではない（スコープ）
    * @throws FacilityNotFound 指定されたIDに該当するファシリティが存在しない場合    */
   public boolean isNode( java.lang.String facilityId ) throws com.clustercontrol.fault.FacilityNotFound;

   /**
    * セパレータ文字列を取得します。<BR> セパレータ文字列はスコープパス表示の際のスコープを区切る文字列
    * @generated 
    * @since 1.0.0
    * @return セパレータ文字列    */
   public java.lang.String getSeparator(  ) ;

   /**
    * リポジトリ更新のTOPICを送信する。<BR>
    * @since 3.1.0    */
   public void sendRepositoryUpdateTopic(  ) ;

   /**
    * ノード作成変更時に、利用可能プラットフォームを表示するためのメソッド。
    * @since 3.2.0
    * @return ArrayList<RepositoryTableInfo>
    * @throws HinemosUnknown    */
   public java.util.ArrayList getPlatformList(  ) throws com.clustercontrol.fault.HinemosUnknown;

   /**
    * ノード作成変更時に、仮想化種別hostのファシリティIDを表示するためのメソッド。
    * @since 3.2.0
    * @return ArrayList
    * @throws HinemosUnknown    */
   public java.util.ArrayList getHostList(  ) throws com.clustercontrol.fault.HinemosUnknown;

   /**
    * OpenFlowスイッチのノードを取得する。
    * @since 4.0.0
    * @return List
    * @throws HinemosUnknown    */
   public java.util.List getOpenFlowSwitchList(  ) throws com.clustercontrol.fault.HinemosUnknown;

   /**
    * ノード作成変更時に、利用可能な仮想化ソリューションを表示するためのメソッド。
    * @since 3.2.0
    * @return ArrayList
    * @throws HinemosUnknown    */
   public java.util.ArrayList getVmSolutionMstList(  ) throws com.clustercontrol.fault.HinemosUnknown;

   /**
    * ノード作成変更時に、利用可能な仮想化プロトコルを表示するためのメソッド。
    * @since 3.2.0
    * @return ArrayList
    * @throws HinemosUnknown    */
   public java.util.ArrayList getVmProtocolMstList(  ) throws com.clustercontrol.fault.HinemosUnknown;

   /**
    * リポジトリの最終更新時刻を取得
    * @return     */
   public java.util.Date getLastUpdate(  ) ;

   /**
    * エージェントの状態を返します。<BR>
    */
   public java.util.ArrayList getAgentStatusList(  ) ;

   /**
    * エージェントを再起動、アップデートします。<BR>
    * @param facilityId　ファシリティID
    * @param agentCommand エージェントに実行するコマンド。
    * @see com.clustercontrol.repository.bean.AgentCommandConstant    */
   public void restartAgent( java.util.ArrayList facilityIdList,int agentCommand ) ;

   public java.util.HashMap getAgentLibMap(  ) throws com.clustercontrol.fault.HinemosUnknown;

}
