/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.action;

import java.util.ArrayList;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.util.Messages;

/**
 * マスタテーブル定義を取得するクライアント側アクションクラス<BR>
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class GetMasterTableDefine {

	/** MIB */
	public static final int MIB = 0;

	/** トラップ名 */
	public static final int TRAP_NAME = 1;

	/** OID */
	public static final int TRAP_OID = 2;

	/** generic_id */
	public static final int GENERIC_ID = 3;

	/** specific_id */
	public static final int SPECIFIC_ID = 4;

	/** 重要度 */
	public static final int PRIORITY = 5;

	/** メッセージ */
	public static final int MESSAGE = 6;

	/////////以下、非表示カラム//////////////////

	/** 詳細説明 (非表示) */
	public static final int DESCR = 7;


	/** 初期表示時ソートカラム */
	public static final int SORT_COLUMN_INDEX = TRAP_NAME;

	/** 初期表示時ソートオーダー */
	public static final int SORT_ORDER = 1;


	/**
	 * マスタテーブル定義を取得します。<BR>
	 * 
	 * @return マスタテーブル定義
	 */
	@SuppressWarnings("unchecked")
	public static ArrayList get() {
		//テーブル定義配列
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(MIB,
				new TableColumnInfo(Messages.getString("mib"), TableColumnInfo.NONE, 0, SWT.LEFT));
		tableDefine.add(TRAP_NAME,
				new TableColumnInfo(Messages.getString("trap.name"), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(TRAP_OID,
				new TableColumnInfo(Messages.getString("oid"), TableColumnInfo.NONE, 120, SWT.LEFT));
		tableDefine.add(GENERIC_ID,
				new TableColumnInfo(Messages.getString("generic.id"), TableColumnInfo.NONE, 75, SWT.LEFT));
		tableDefine.add(SPECIFIC_ID,
				new TableColumnInfo(Messages.getString("specific.id"), TableColumnInfo.NONE, 75, SWT.LEFT));
		tableDefine.add(PRIORITY,
				new TableColumnInfo(Messages.getString("priority"), TableColumnInfo.PRIORITY, 70, SWT.LEFT));
		tableDefine.add(MESSAGE,
				new TableColumnInfo(Messages.getString("message"), TableColumnInfo.NONE, 150, SWT.LEFT));

		return tableDefine;
	}
}
