/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.notify.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.notify.dialog.NotifyTypeDialog;
import com.clustercontrol.notify.view.NotifyListView;

/**
 * 通知[一覧]ビューの作成アクションクラス<BR>
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class NotifyAddAction implements IViewActionDelegate {

	/** アクションID */
	public static final String ID = "com.clustercontrol.monitor.view.action.NotifyAddAction";

	/** ビュー */
	private IViewPart viewPart;
	/**
	 * 通知種別一覧ダイアログを表示します
	 */
	@Override
	public void run(IAction action) {
		NotifyListView view = (NotifyListView) this.viewPart.getAdapter(NotifyListView.class);
		NotifyTypeDialog dialog = new NotifyTypeDialog(this.viewPart.getSite()
				.getShell(), view.getListComposite());
		dialog.open();
	}

	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		// TODO Auto-generated method stub

	}

	/**
	 * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
	 */
	@Override
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}

}
