/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.maintenance.view;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.bean.Property;
import com.clustercontrol.maintenance.composite.MaintenanceListComposite;
import com.clustercontrol.maintenance.view.action.MaintenanceDeleteAction;
import com.clustercontrol.maintenance.view.action.MaintenanceDisableAction;
import com.clustercontrol.maintenance.view.action.MaintenanceEnableAction;
import com.clustercontrol.maintenance.view.action.MaintenanceModifyAction;
import com.clustercontrol.view.CommonViewPart;

/**
 * メンテナンス[一覧]ビュークラス<BR>
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class MaintenanceListView extends CommonViewPart {

	/** メンテナンス[一覧]ビューID */
	public static final String ID = "com.clustercontrol.maintenance.view.MaintenanceListView";

	/** メンテナンス[一覧]コンポジット */
	private MaintenanceListComposite composite = null;

	/** 検索条件 */
	private Property condition = null;

	/**
	 * コンストラクタ
	 */
	public MaintenanceListView() {
		super();
	}

	/**
	 * ViewPartへのコントロール作成処理<BR>
	 * 
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void createPartControl(Composite parent) {
		GridLayout layout = new GridLayout(1, true);
		parent.setLayout(layout);
		layout.marginHeight = 0;
		layout.marginWidth = 0;

		composite = new MaintenanceListComposite(parent, SWT.NONE);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		this.composite.setLayoutData(gridData);
		this.composite.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				//メンテナンス[履歴情報削除]ビューのインスタンスを取得
				IWorkbenchPage page = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage();
				IViewPart viewPart = page.findView(MaintenanceListView.ID);
				//選択アイテムを取得
				StructuredSelection selection = (StructuredSelection) event.getSelection();

				if ( viewPart != null && selection != null) {
					MaintenanceListView view = (MaintenanceListView) viewPart.getAdapter(MaintenanceListView.class);
					//ビューのボタン（アクション）の使用可/不可を設定する
					view.setEnabledAction(selection.size(), event.getSelection());
				}
			}
		});

		this.update();
	}

	/**
	 * 追加コンポジットを返します。
	 * 
	 * @return 追加コンポジット
	 */
	public Composite getListComposite() {
		return this.composite;
	}

	/**
	 * 検索条件にヒットした監視設定の一覧を表示します。
	 * <p>
	 * 
	 * conditionがnullの場合、全監視設定を表示します。
	 * 
	 * @param condition
	 *            検索条件
	 */
	public void update(Property condition) {
		this.condition = condition;

		this.update();
	}

	/**
	 * ビューを更新します。
	 * <p>
	 * 
	 * 検索条件が事前に設定されている場合、その条件にヒットする監視設定の一覧を 表示します <br>
	 * 検索条件が設定されていない場合は、全監視設定を表示します。
	 */
	public void update() {
		this.composite.update();
	}

	/**
	 * ビューのアクションの有効/無効を設定します。
	 * 
	 * @param num 選択イベント数
	 * @param selection ボタン（アクション）を有効にするための情報
	 */
	public void setEnabledAction(int num, ISelection selection) {
		//ビューアクションの使用可/不可を設定
		super.setEnabledAction(MaintenanceDeleteAction.ID, selection);
		super.setEnabledAction(MaintenanceModifyAction.ID, selection);
		super.setEnabledAction(MaintenanceEnableAction.ID, selection);
		super.setEnabledAction(MaintenanceDisableAction.ID, selection);

		if (num > 0){
			super.setEnabledAction(MaintenanceEnableAction.ID, true);
			super.setEnabledAction(MaintenanceDisableAction.ID, true);

			if(num == 1){
				super.setEnabledAction(MaintenanceDeleteAction.ID, true);
				super.setEnabledAction(MaintenanceModifyAction.ID, true);
			} else {
				super.setEnabledAction(MaintenanceDeleteAction.ID, false);
				super.setEnabledAction(MaintenanceModifyAction.ID, false);
			}
		} else {
			super.setEnabledAction(MaintenanceDeleteAction.ID, false);
			super.setEnabledAction(MaintenanceModifyAction.ID, false);
			super.setEnabledAction(MaintenanceEnableAction.ID, false);
			super.setEnabledAction(MaintenanceDisableAction.ID, false);
		}
	}
}
