/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.composite.action;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;

import com.clustercontrol.collectiverun.bean.ItemConstant;
import com.clustercontrol.collectiverun.composite.TreeComposite;
import com.clustercontrol.collectiverun.util.TreeItemUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.collectiverun.ItemInfo;
import com.clustercontrol.ws.collectiverun.TreeItem;

/**
 * 一括制御マスターをコピーするクライアント側アクションクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class CopyTreeItemAction extends Action {
	protected TreeComposite composite;

	public CopyTreeItemAction(TreeComposite composite) {
		this.composite = composite;

		setText(Messages.getString("copy"));
		setToolTipText(Messages.getString("copy"));
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	@Override
	public void run() {

		TreeItem selectItem = this.composite.getSelectItem();
		if(selectItem instanceof TreeItem){

			boolean copy = false;
			if(getInfo(selectItem).getType() == ItemConstant.TYPE_TYPE ||
					getInfo(selectItem).getType() == ItemConstant.TYPE_COMMAND ||
					getInfo(selectItem).getType() == ItemConstant.TYPE_COMMAND_PARAMETER ||
					getInfo(selectItem).getType() == ItemConstant.TYPE_PARAMETER ||
					getInfo(selectItem).getType() == ItemConstant.TYPE_SELECT_ITEM){
				copy = true;
			}

			if(copy){
				TreeItem copyItem = TreeItemUtil.copy(selectItem);
				TreeItem parent = selectItem.getParent();

				int maxOrderNo = TreeItemUtil.getMaxOrderNo(parent);

				ItemInfo copyInfo = getInfo(copyItem);

				copyInfo.setOrderNo(maxOrderNo + 1);

				TreeItemUtil.addChildren(selectItem.getParent(), copyItem);

				this.composite.setCreateItem(copyItem);
				this.composite.getTreeViewer().refresh(selectItem.getParent());
				this.composite.getTreeViewer().setSelection(
						new StructuredSelection(copyItem), true);
			}
		}
	}

	private ItemInfo getInfo(TreeItem item){
		if(item.getCommandInfo() != null){
			return item.getCommandInfo();
		}
		else if(item.getCommandParameterInfo() != null){
			return item.getCommandParameterInfo();
		}
		else if(item.getParameterInfo() != null){
			return item.getParameterInfo();
		}
		else if(item.getParameterSelectInfo() != null){
			return item.getParameterSelectInfo();
		}
		else if(item.getTypeInfo() != null){
			return item.getTypeInfo();
		}
		else{
			return null;
		}
	}
}
