/*

Copyright (C) since 2009 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */
package com.clustercontrol.calendar.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.calendar.bean.CalendarConstant;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.ws.calendar.CalendarInfo;

/**
 * カレンダ情報のDTOとプロパティを相互変換するためのユーティリティクラスです。
 * @since 0.1
 */
public class CalendarPropertyUtil {

	/**
	 * プロパティをカレンダ情報DTOに変換するメソッドです。
	 * 
	 * @param property
	 * @return カレンダ情報
	 */
	public static CalendarInfo property2dto(Property property){
		CalendarInfo info = new CalendarInfo();
		info.setValidTimeFrom(0L);
		info.setValidTimeTo(0L);
		info.setRegDate(0L);
		info.setUpdateDate(0L);
		info.setCheck(false);

		ArrayList object = null;

		// id
		object = PropertyUtil.getPropertyValue(property, CalendarConstant.ID);
		if (object.size() > 0) {
			info.setId((String)object.get(0));
		}
		//名前
		object = PropertyUtil.getPropertyValue(property, CalendarConstant.NAME);
		if (object.size() > 0) {
			info.setName((String)object.get(0));
		}
		//有効期間(From)
		object = PropertyUtil.getPropertyValue(property, CalendarConstant.VALID_TIME_FROM);
		if (object.size() > 0 && object.get(0) != null && !object.get(0).toString().equals("")) {
			info.setValidTimeFrom(((Date) (object.get(0))).getTime());
		}
		//有効期間(To)
		object = PropertyUtil.getPropertyValue(property, CalendarConstant.VALID_TIME_TO);
		if (object.size() > 0 && object.get(0) != null && !object.get(0).toString().equals("")) {
			info.setValidTimeTo(((Date) (object.get(0))).getTime());
		}
		//説明
		object = PropertyUtil.getPropertyValue(property, CalendarConstant.DESCRIPTION);
		if (object.size() > 0) {
			info.setDescription((String)object.get(0));
		}
		//登録者
		object = PropertyUtil.getPropertyValue(property, CalendarConstant.CREATOR_NAME);
		if (object.size() > 0) {
			info.setRegUser((String)object.get(0));
		}
		//登録日時
		object = PropertyUtil.getPropertyValue(property, CalendarConstant.CREATE_TIME);
		if (object.size() > 0 && object.get(0) != null && !object.get(0).toString().equals("")) {
			info.setRegDate(((Date) (object.get(0))).getTime());
		}
		//更新者
		object = PropertyUtil.getPropertyValue(property, CalendarConstant.MODIFIER_NAME);
		if (object.size() > 0) {
			info.setUpdateUser((String)object.get(0));
		}
		//更新日時
		object = PropertyUtil.getPropertyValue(property, CalendarConstant.MODIFY_TIME);
		if (object.size() > 0 && object.get(0) != null && !object.get(0).toString().equals("")) {
			info.setUpdateDate(((Date) (object.get(0))).getTime());
		}


		return info;
	}

	/**
	 * カレンダ情報DTOをプロパティに変換するメソッドです。
	 * 
	 * @param info
	 * @param mode
	 * @param locale
	 * @return プロパティ
	 */
	public static Property dto2property(CalendarInfo info, int mode, Locale locale){
		/** ローカル変数 */
		Property property = null;
		ArrayList propertyList = null;

		/** メイン処理 */
		property = getProperty(mode, locale);

		if(info != null){
			//id
			propertyList = PropertyUtil.getProperty(property, CalendarConstant.ID);
			((Property)propertyList.get(0)).setValue(info.getId());
			//名前
			propertyList = PropertyUtil.getProperty(property, CalendarConstant.NAME);
			if(info.getName() != null && info.getName().compareTo("") != 0){
				((Property)propertyList.get(0)).setValue(info.getName());
			}
			//有効期間(From)
			propertyList = PropertyUtil.getProperty(property, CalendarConstant.VALID_TIME_FROM);
			if(info.getValidTimeFrom() != null){
				((Property)propertyList.get(0)).setValue(new Date(info.getValidTimeFrom()));
			}
			//有効期間(To)
			propertyList = PropertyUtil.getProperty(property, CalendarConstant.VALID_TIME_TO);
			if(info.getValidTimeTo() != null){
				((Property)propertyList.get(0)).setValue(new Date(info.getValidTimeTo()));
			}
			//説明
			propertyList = PropertyUtil.getProperty(property, CalendarConstant.DESCRIPTION);
			if(info.getDescription() != null && info.getDescription().compareTo("") != 0){
				((Property)propertyList.get(0)).setValue(info.getDescription());
			}
			//登録者
			propertyList = PropertyUtil.getProperty(property, CalendarConstant.CREATOR_NAME);
			if(info.getRegUser() != null && info.getRegUser().compareTo("") != 0){
				((Property)propertyList.get(0)).setValue(info.getRegUser());
			}
			//登録日時
			propertyList = PropertyUtil.getProperty(property, CalendarConstant.CREATE_TIME);
			if(info.getRegDate() != null){
				((Property)propertyList.get(0)).setValue(new Date(info.getRegDate()));
			}
			//更新者
			propertyList = PropertyUtil.getProperty(property, CalendarConstant.MODIFIER_NAME);
			if(info.getUpdateUser() != null && info.getUpdateUser().compareTo("") != 0){
				((Property)propertyList.get(0)).setValue(info.getUpdateUser());
			}
			//更新日時
			propertyList = PropertyUtil.getProperty(property, CalendarConstant.MODIFY_TIME);
			if(info.getUpdateDate() != null){
				((Property)propertyList.get(0)).setValue(new Date(info.getUpdateDate()));
			}
		}

		return property;
	}


	/**
	 * カレンダ用プロパティを取得します。<BR>
	 * 
	 * @param mode
	 * @param locale
	 * @return カレンダ用プロパティ
	 */
	private static Property getProperty(int mode, Locale locale) {
		//カレンダID
		Property id =
			new Property(CalendarConstant.ID, Messages.getString("calendar.id", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		//カレンダ名
		Property name =
			new Property(CalendarConstant.NAME, Messages.getString("calendar.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_256);
		//有効期間(From)
		Property validTimeFrom =
			new Property(CalendarConstant.VALID_TIME_FROM, Messages.getString("valid.time", locale) + "(" + Messages.getString("start", locale) + ")",
					PropertyConstant.EDITOR_DATETIME);
		//有効期間(To)
		Property validTimeTo =
			new Property(CalendarConstant.VALID_TIME_TO, Messages.getString("valid.time", locale) + "(" + Messages.getString("end", locale) + ")"
					, PropertyConstant.EDITOR_DATETIME);
		//説明
		Property description =
			new Property(CalendarConstant.DESCRIPTION, Messages.getString("description", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_256);
		//登録日時
		Property createTime =
			new Property(CalendarConstant.CREATE_TIME, Messages.getString("create.time", locale), PropertyConstant.EDITOR_DATETIME);
		//登録者
		Property creatorName =
			new Property(CalendarConstant.CREATOR_NAME, Messages.getString("creator.name", locale), PropertyConstant.EDITOR_TEXT);
		//更新日時
		Property modifyTime =
			new Property(CalendarConstant.MODIFY_TIME, Messages.getString("update.time", locale), PropertyConstant.EDITOR_DATETIME);
		//更新者
		Property modifierName =
			new Property(CalendarConstant.MODIFIER_NAME, Messages.getString("modifier.name", locale), PropertyConstant.EDITOR_TEXT);

		//値を初期化
		id.setValue("");
		name.setValue("");
		validTimeFrom.setValue("");
		validTimeTo.setValue("");
		description.setValue("");
		createTime.setValue("");
		creatorName.setValue("");
		modifyTime.setValue("");
		modifierName.setValue("");

		//モードにより、変更可及びコピー可を設定
		if(mode == PropertyConstant.MODE_ADD){
			id.setModify(PropertyConstant.MODIFY_OK);
			name.setModify(PropertyConstant.MODIFY_OK);
			validTimeFrom.setModify(PropertyConstant.MODIFY_OK);
			validTimeTo.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
		}
		else if(mode == PropertyConstant.MODE_MODIFY){
			name.setModify(PropertyConstant.MODIFY_OK);
			validTimeFrom.setModify(PropertyConstant.MODIFY_OK);
			validTimeTo.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
		}

		Property property = new Property(null, null, "");

		// 初期表示ツリーを構成。
		property.removeChildren();
		property.addChildren(id);
		property.addChildren(name);
		property.addChildren(validTimeFrom);
		property.addChildren(validTimeTo);
		property.addChildren(description);
		property.addChildren(createTime);
		property.addChildren(creatorName);
		property.addChildren(modifyTime);
		property.addChildren(modifierName);

		return property;
	}
}
